/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/13, 14:44
!  AUTHOR(S): KOGA, Junichiro
!  File : ACVAtomEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import java.awt.Dimension;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.atomcoord.AtomEditor;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;

/**
 * Atomic configuration viewerpAtomEditor.
 * 
 * @author
 */
public class ACVAtomEditor extends AtomEditor implements ConfigData {
    private Logger logger = Logger.getLogger(ACVAtomEditor.class.getName());
    private CoordsViewerInterface parent;

    /** Creates a new instanceACVAtomEditoritor */
    public ACVAtomEditor(InputInterfaceTableColumns[] columns,
            ciss.phase_viewer.atomcoord.Atom atom, boolean newAtom,
            int atomIndex, String title, Dimension dimension, int pos,
            CoordsViewerInterface parent) {
        super(columns, atom, newAtom, atomIndex, title, dimension);
        this.parent = parent;
        parent.getCD().register(this);
    }

    public ACVAtomEditor(InputInterfaceTableColumns[] columns,
            ciss.phase_viewer.atomcoord.Atom atom, boolean newAtom,
            int atomIndex, String title, Dimension dimension,
            CoordsViewerInterface parent) {
        super(columns, atom, newAtom, atomIndex, title, dimension);
        this.parent = parent;
        parent.getCD().register(this);
    }

    public boolean needsUpdate() {
        return true;
    }

    public void configDataUpdate() {
        if (parent.getCD().getAtomCoords().getNumAt() <= atomIndex)
            return;
        ciss.phase_viewer.atomcoord.Atom newAtom = parent.getCD()
                .getAtomCoords().getAtomList().getAtomAt(atomIndex);
        if (newAtom != null) {
            super.setValue(newAtom);
        }
    }

    public void configDataUpdate(boolean bool, ConfigDataUpdateEvent e) {
        configDataUpdate();
    }

    protected void post() {
        parent.getCD().getAtomCoords().getAtomList().setUndoCount(1);
    }

    protected void removeSelected() {
        parent.getBasicOperations().removeSelectedAtoms();
        dispose();
    }
}
