/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : MaterialEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
// Copyright (C) 2005 Jun Mitani
package ciss.phase_viewer.pub.materialeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Light;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;

public class MaterialEditor extends JFrame implements ActionListener,
        ChangeListener, AdjustmentListener {

    // _OLoX
    private final static int RENDER_CANVAS_SIZE = 200;
    private final static int RENDER_CANVAS_BG_GRID_NUM = 8;

    // p[^ID
    private final static int ID_AMBIENT = 0;
    private final static int ID_DIFFUSE = 1;
    private final static int ID_SPECULAR = 2;
    private final static int ID_EMISSION = 3;
    private final static int ID_SHINIESS = 4;
    private final static int ID_TRANSPARENCY = 5;

    // UIi
    private JLabel paramNameLabels[] = new JLabel[6];
    private JButton paramButtons[] = new JButton[4];
    private JScrollBar paramScrollBars[] = new JScrollBar[2];
    private JColorChooser colorChooser;
    private JButton outputButton;
    private Color paramColors[] = { new Color(87, 61, 54),
            new Color(161, 50, 47), new Color(59, 60, 21),
            new Color(20, 17, 15) };
    private int selectedParamID = 0;
    String labelNames[] = { "Ambient()", "Diffuse(gU)", "Specular(ʌ)",
            "Emission(ˌ)", "Shiniess(Px)", "Transparency(x)" };

    private Appearance m_appearance;

    // _OLpX̍쐬
    private Canvas3D createCanvas() {
        GraphicsConfiguration config = SimpleUniverse
                .getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(config);
        canvas.setSize(RENDER_CANVAS_SIZE, RENDER_CANVAS_SIZE);

        SimpleUniverse universe = new SimpleUniverse(canvas);
        universe.getViewingPlatform().setNominalViewingTransform();
        universe.addBranchGraph(createBranchGraph());
        return canvas;
    }

    // BranchGroup ̍쐬
    private BranchGroup createBranchGraph() {
        BranchGroup branchGroup = new BranchGroup();

        // s̒ǉ
        branchGroup.addChild(createDirectionalLight());

        // ̒ǉ
        branchGroup.addChild(createAmbientLight());

        // wiC[W̒ǉ
        branchGroup.addChild(createBackgroundImage());

        // _OΏۂ̋̂ǉ
        branchGroup.addChild(createSphere());

        branchGroup.compile();

        return branchGroup;
    }

    // s̍쐬
    private Light createDirectionalLight() {
        DirectionalLight light = new DirectionalLight(true, new Color3f(1.0f,
                1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, -1.0f));
        light.setInfluencingBounds(new BoundingSphere(new Point3d(), 10.0));
        return light;
    }

    // ̍쐬
    private Light createAmbientLight() {
        AmbientLight light = new AmbientLight();
        light.setInfluencingBounds(new BoundingSphere(new Point3d(), 10.0));
        return light;
    }

    // wi摜̍쐬
    private Background createBackgroundImage() {
        BufferedImage bufferedImage = new BufferedImage(RENDER_CANVAS_SIZE,
                RENDER_CANVAS_SIZE, BufferedImage.TYPE_3BYTE_BGR);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, RENDER_CANVAS_SIZE, RENDER_CANVAS_SIZE);
        g.setColor(Color.black);
        int gridSize = RENDER_CANVAS_SIZE / RENDER_CANVAS_BG_GRID_NUM;
        for (int y = 0; y < RENDER_CANVAS_BG_GRID_NUM; y++) {
            for (int x = 0; x < RENDER_CANVAS_BG_GRID_NUM; x++) {
                if ((x + y) % 2 == 0) {
                    g.fillRect(x * gridSize, y * gridSize, gridSize, gridSize);
                }
            }
        }
        Background background = new Background(new ImageComponent2D(
                ImageComponent2D.FORMAT_RGB, bufferedImage));
        background
                .setApplicationBounds(new BoundingSphere(new Point3d(), 10.0));
        return background;
    }

    // Sphere ̍쐬
    private Sphere createSphere() {
        // Material ̍쐬
        Material material = new Material();
        material.setCapability(Material.ALLOW_COMPONENT_READ);
        material.setCapability(Material.ALLOW_COMPONENT_WRITE);
        material.setLightingEnable(true);

        // TransparencyAttributes ̍쐬
        TransparencyAttributes tansparency = new TransparencyAttributes(
                TransparencyAttributes.BLENDED, 0.0f);
        tansparency.setCapability(TransparencyAttributes.ALLOW_VALUE_READ);
        tansparency.setCapability(TransparencyAttributes.ALLOW_VALUE_WRITE);

        // Appearance ̍쐬
        m_appearance = new Appearance();
        m_appearance.setCapability(Appearance.ALLOW_MATERIAL_READ);
        m_appearance.setCapability(Appearance.ALLOW_MATERIAL_WRITE);
        m_appearance
                .setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_READ);
        m_appearance
                .setCapability(Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE);

        // Appearance  Material ݒ
        m_appearance.setMaterial(material);

        // Appearance  TransparencyAttributes ݒ
        m_appearance.setTransparencyAttributes(tansparency);

        // Sphere ̍쐬
        Sphere sphere = new Sphere(0.7f, Sphere.GENERATE_NORMALS, 128,
                m_appearance);
        sphere.getShape().setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
        sphere.getShape().setCapability(Shape3D.ALLOW_APPEARANCE_READ);

        return sphere;
    }

    // p[^̑I
    private void setSelectedParamID(int id) {
        paramNameLabels[selectedParamID].setBorder(null);
        selectedParamID = id;
        paramNameLabels[selectedParamID].setBorder(BorderFactory
                .createLineBorder(Color.blue));

        colorChooser.setBorder(BorderFactory
                .createTitledBorder(labelNames[selectedParamID]));
        colorChooser.setColor(paramColors[selectedParamID]);
    }

    // p[^ҏWpl̍쐬
    private JPanel createParamEditPanel() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(300, RENDER_CANVAS_SIZE));
        panel.setLayout(new GridLayout(6, 2, 10, 5));

        for (int i = 0; i < 6; i++) {
            // x̒ǉ
            panel.add(paramNameLabels[i] = new JLabel(labelNames[i],
                    JLabel.RIGHT));

            if (i < 4) {
                // {^̒ǉ
                paramButtons[i] = new JButton();
                panel.add(paramButtons[i]);
                paramButtons[i].addActionListener(this);
            } else {
                // XN[o[̒ǉ
                int barIndex = i - 4;
                paramScrollBars[barIndex] = new JScrollBar(
                        JScrollBar.HORIZONTAL, 0, 1, 0, 100);
                paramScrollBars[barIndex].addAdjustmentListener(this);
                panel.add(paramScrollBars[barIndex]);
            }
        }

        return panel;
    }

    // GUIi̍\z
    private void buildUI() {
        // 㕔pli_OLpX{p[^ҏWplj̍쐬
        JPanel panelNorth = new JPanel();
        panelNorth.setLayout(new FlowLayout());
        panelNorth.add(createCanvas());
        panelNorth.add(createParamEditPanel());

        // J[Ipl̍쐬
        JPanel panelCenter = new JPanel();
        colorChooser = new JColorChooser();
        colorChooser.getSelectionModel().addChangeListener(this);
        panelCenter.add(colorChooser);

        // pliR[ho̓{^j̍쐬
        JPanel panelSouth = new JPanel();
        panelSouth.add(outputButton = new JButton("R[ho"));
        outputButton.addActionListener(this);

        // 㕔plƉplt[ɒǉ
        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(panelNorth, BorderLayout.NORTH);
        getContentPane().add(panelCenter, BorderLayout.CENTER);
        getContentPane().add(panelSouth, BorderLayout.SOUTH);
    }

    // VFIꂽ̏
    public void stateChanged(ChangeEvent e) {
        setMaterialParam(selectedParamID, colorChooser.getColor());
    }

    // AgUAʌAˌ̃p[^ݒ
    private void setMaterialParam(int paramID, Color c) {
        paramColors[paramID] = c;
        paramButtons[paramID].setBackground(c);

        Material material = m_appearance.getMaterial();
        switch (paramID) {
        case ID_AMBIENT:
            material.setAmbientColor(new Color3f(c));
            break;
        case ID_DIFFUSE:
            material.setDiffuseColor(new Color3f(c));
            break;
        case ID_SPECULAR:
            material.setSpecularColor(new Color3f(c));
            break;
        case ID_EMISSION:
            material.setEmissiveColor(new Color3f(c));
            break;
        }
    }

    // PxAx̃p[^ݒ
    private void setMaterialParam(int paramID, float value) {
        switch (paramID) {
        case ID_SHINIESS:
            m_appearance.getMaterial().setShininess(value);
            break;
        case ID_TRANSPARENCY:
            m_appearance.getTransparencyAttributes().setTransparency(value);
            break;
        }
    }

    // XN[o[삳ꂽ̏
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getAdjustable().equals(paramScrollBars[0])) {
            setMaterialParam(ID_SHINIESS, paramScrollBars[0].getValue() * 1.28f);
        } else {
            setMaterialParam(ID_TRANSPARENCY,
                    paramScrollBars[1].getValue() / 100.0f);
        }
    }

    // {^ꂽ̏
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(outputButton)) {
            outputCode();
        } else {
            for (int i = 0; i < 4; i++) {
                if (e.getSource().equals(paramButtons[i])) {
                    setSelectedParamID(i);
                    break;
                }
            }
        }
    }

    // Appearance ݒpR[h̏o
    private void outputCode() {
        Material material = m_appearance.getMaterial();
        Color3f color = new Color3f();

        JFrame frame = new JFrame("Code");
        frame.setBounds(100, 100, 500, 250);
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        DecimalFormat form = new DecimalFormat("0.0000");

        textArea.append("Material material = new Material();\n");

        material.getAmbientColor(color);
        textArea.append("material.setAmbientColor(" + form.format(color.x)
                + "f, " + form.format(color.y) + "f, " + form.format(color.z)
                + "f);\n");

        material.getDiffuseColor(color);
        textArea.append("material.setDiffuseColor(" + form.format(color.x)
                + "f, " + form.format(color.y) + "f, " + form.format(color.z)
                + "f);\n");

        material.getSpecularColor(color);
        textArea.append("material.setSpecularColor(" + form.format(color.x)
                + "f, " + form.format(color.y) + "f, " + form.format(color.z)
                + "f);\n");

        material.getEmissiveColor(color);
        textArea.append("material.setEmissiveColor(" + form.format(color.x)
                + "f, " + form.format(color.y) + "f, " + form.format(color.z)
                + "f);\n");

        float shininess = material.getShininess();
        textArea.append("material.setShininess(" + form.format(shininess)
                + "f);\n");

        textArea.append("TransparencyAttributes tansparency = new TransparencyAttributes(TransparencyAttributes.BLENDED, "
                + form.format(m_appearance.getTransparencyAttributes()
                        .getTransparency()) + "f);\n");

        textArea.append("Appearance appearance = new Appearance();\n");
        textArea.append("appearance.setMaterial(material);\n");
        textArea.append("appearance.setTransparencyAttributes(tansparency);\n");

        frame.add(textArea);
        frame.setVisible(true);
    }

    // MaterialEditor ̃RXgN^
    public MaterialEditor() {
        super("MaterialEditor");
        // UIi̍\z
        buildUI();

        // p[^̏
        setSelectedParamID(0);
        for (int i = 0; i < 4; i++) {
            setMaterialParam(i, paramColors[i]);
        }

        paramScrollBars[0].setValue(30);
        paramScrollBars[1].setValue(3);
        setMaterialParam(ID_SHINIESS, 128.0f * 0.3f);
        setMaterialParam(ID_TRANSPARENCY, 0.03f);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        MaterialEditor materialEditor = new MaterialEditor();
        materialEditor.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        materialEditor.setBounds(10, 10, 600, 650);
        materialEditor.setVisible(true);
    }
}
