/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/27, 20:46
!  AUTHOR(S): KOGA, Junichiro
!  File : Log4jPropertiesCreator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.logger;

import java.io.File;

/**
 * log4jppropertiest@C̃ev[g쐬NX. Ƃȍ.
 * 
 * @author
 */
public class Log4jPropertiesCreator {

    private static String LS = System.getProperty("line.separator");

    private static String header1 = "#template created by: ciss.phase_viewer.logger.Log4jPropertiesCreator class"
            + LS
            + "#run it under the \"src\" directory by typing \"java -cp ../bin/chase.jar ciss.phase_viewer.logger.Log4jPropertiesCreator\""
            + LS
            + "log4j.rootCategory=INFO, dest3"
            + LS
            + "log4j.appender.dest1=org.apache.log4j.ConsoleAppender"
            + LS
            + "log4j.appender.dest1.layout=org.apache.log4j.PatternLayout"
            + LS
            + "log4j.appender.dest1.layout.ConversionPattern=%-5p %6.10r[%t]%x(%F:%L) - %m%n"
            + LS
            + "log4j.appender.dest2=org.apache.log4j.FileAppender"
            + LS
            + "log4j.appender.dest2.File=Log"
            + LS
            + "log4j.appender.dest2.layout=org.apache.log4j.PatternLayout"
            + LS
            + "log4j.appender.dest2.layout.ConversionPattern=%-5p %6.10r[%t]%x(%F:%L) - %m%n"
            + LS
            + "log4j.appender.dest3=ciss.phase_viewer.logger.JTextAreaAppender"
            + LS
            + "#log4j.appender.dest3.layout=org.apache.log4j.PatternLayout"
            + LS
            + "#log4j.appender.dest3.layout.ConversionPattern=%-5p %6.10r[%t]%x(%F:%L) - %m%n"
            + LS + "log4j.additivity.ciss.phase_viewer=false" + LS;

    private static String header2 = "#log4j.category.";
    private static String tail = "=DEBUG, dest3";

    /** Creates a new instance of Log4jPropertiesCreator */
    public Log4jPropertiesCreator() {
    }

    public static void main(String args[]) {
        System.out.print(header1);
        create(System.getProperty("user.dir"));
    }

    private static void create(String baseDir) {
        File base = new File(baseDir);
        File[] files = base.listFiles();
        String thisDir = System.getProperty("user.dir");
        int thisDirLen = thisDir.length();
        for (int i = 0; i < files.length; i++) {
            if (files[i].isDirectory()) {
                create(files[i].getAbsolutePath());
            }
            String file = files[i].getAbsolutePath();
            if (file.endsWith(".java")) {
                String foo = file.substring(thisDirLen + 1, file.length() - 5);
                String bar = foo.replace('\\', '.');
                System.out.print(header2 + bar + tail + LS);
            }
        }
    }

}
