/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : PropertiesManager.java
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Utils;

public class PropertiesManager {

    public static final int PROPERTIES_PVIEWER = 0; /*
                                                     * !<
                                                     * vOŜ̃vpeB[w肷intl
                                                     */
    public static final int PROPERTIES_ACV = 1;/* !< qzur[A[̃vpeB[w肷intl */
    public static final int PROPERTIES_SIZE = 2;/* !< q̏Ȃǂ̃vpeB[w肷intl */
    public static final int PROPERTIES_ELEMINFO = 3;/* !< f̃vpeB[w肷intl */
    public static final int PROPERTIES_INSTALLATION = 4;/*
                                                         * !<
                                                         * CXg[ɃRs[ׂvpeB[t@Cw肷vpeB[t@Cw肷intl
                                                         */
    public static final int PROPERTIES_LAST_USED_DIR = 5; /*
                                                           * !<
                                                           * uŌɗpfBNg[v
                                                           */

    public static final int PROPERTIES_WINDOW = 6; /* !< window̑ȂǂۑĂ */

    private static InstallationProperties installation;
    private static GlobalProperties Chase;
    private static GlobalProperties ACV;
    private static GlobalProperties Size;
    private static GlobalProperties Element;
    private static GlobalProperties Last_used_dir;
    private static GlobalProperties windows;

    private static Logger logger = Logger.getLogger(PropertiesManager.class
            .getName());

    // protected class PropertiesManager() { }

    public static GlobalProperties getGlobalProperties(int propertyType, boolean reload) {
        if (installation == null||reload) {
            installation = new InstallationProperties();
        }

        if (propertyType == PROPERTIES_INSTALLATION) {
            return installation;
        }

        if (propertyType == PROPERTIES_PVIEWER) {
            if (Chase == null||reload) {
                String FS = System.getProperty("file.separator");
                File defaultChaseini = new File(
                        System.getProperty("pviewer.home") + FS + "install"
                                + FS + "install_files" + FS
                                + "phase-viewer.ini");
                Properties props = new Properties();
                try {
                    props.load(new FileInputStream(defaultChaseini));
                } catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                Chase = (GlobalProperties) new ChaseProperties(installation,
                        props);
            }
            return Chase;
        } else if (propertyType == PROPERTIES_ACV) {
            if (ACV == null||reload) {
                InputStream inStream = GlobalProperties.class
                        .getResourceAsStream("/ciss/phase_viewer/settings/acvconfig.properties");
                if (System.getProperty("os.name").startsWith("Linux")
                        || Utils.parseJREVersion() >= 170)
                    inStream = GlobalProperties.class
                            .getResourceAsStream("/ciss/phase_viewer/settings/acvconfig_linux.properties");

                Properties props = new Properties();
                try {
                    props.load(inStream);
                } catch (java.io.IOException ioe) {
                    ioe.printStackTrace();
                }
                ACV = (GlobalProperties) new ACVProperties(installation, props);
            }
            return ACV;
        } else if (propertyType == PROPERTIES_SIZE) {
            if (Size == null||reload) {
                Size = (GlobalProperties) new SizeProperties(installation);
            }
            return Size;
        } else if (propertyType == PROPERTIES_ELEMINFO) {
            if (Element == null||reload) {
                Element = (GlobalProperties) new ElementProperties(installation);
            }
            return Element;
        } else if (propertyType == PROPERTIES_LAST_USED_DIR) {
            if (Last_used_dir == null||reload) {
                Last_used_dir = (GlobalProperties) new LastUsedDirProperties(
                        installation);
            }
            return Last_used_dir;
        } else if (propertyType == PROPERTIES_WINDOW) {
            if (windows == null||reload) {
                windows = (GlobalProperties) new WindowProperties(installation);
            }
            return windows;
        } else {
            logger.debug("wrong property type");
        }
        return null;
    }
    public static GlobalProperties getGlobalProperties(int propertyType) {
    	return getGlobalProperties(propertyType, false);
    }

}
