/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : GlobalProperties.java
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

import org.apache.log4j.Logger;

public abstract class GlobalProperties extends java.util.Properties {

	private static Logger logger = Logger.getLogger(GlobalProperties.class
			.getName());

	protected String fileName;
	protected int propertyType;

	protected InstallationProperties installation;

	protected String FS = System.getProperty("file.separator");
	protected String homeDir = System.getProperty("user.home");
	protected String instDir = System.getProperty("pviewer.home");
	protected String pviewerHomeDir = homeDir + FS + ".phase-viewer";

	private void init() {
		FS = System.getProperty("file.separator");
		homeDir = System.getProperty("user.home");
		instDir = System.getProperty("pviewer.home");
		pviewerHomeDir = homeDir + FS + ".phase-viewer";
	}

	protected GlobalProperties() {
		init();
		setFileName();
		loadProperty();
	}

	protected GlobalProperties(InstallationProperties installation) {
		init();
		this.installation = installation;
		setFileName();
		loadProperty();
	}

	protected GlobalProperties(InstallationProperties installation,
			Properties defaultProperties) {
		super(defaultProperties);
		init();
		this.installation = installation;
		setFileName();
		loadProperty();
	}

	abstract public String getFileName();

	abstract public int getPropertyType();

	abstract protected void setFileName();

	private void loadProperty() {
		try {
			if (new File(fileName).exists()) {
				super.load(new FileInputStream(fileName));
			}
		} catch (Exception exc) {
			// logger.debug("failed to load from file: "+fileName);
			// exc.printStackTrace();
		}
	}

	private static Vector listeners;

	/**
	 * ̃vpeB[̕ύXĎNXo^
	 *
	 * @param listener
	 *            o^Xi[
	 */
	public static void addPropertiesListener(PropertiesListener listener) {
		if (listeners == null)
			listeners = new Vector();
		listeners.addElement(listener);
	}

	/**
	 * Xi[폜
	 *
	 * @param listener
	 *            폜Xi[
	 */
	public static void removePropertiesListener(PropertiesListener listener) {
		if (listeners == null)
			return;
		listeners.remove(listener);
	}

	public void storeProperty() {
		try {
			if (new File(fileName).exists() && !new File(fileName).canWrite())
				return;
			super.store(new FileOutputStream(fileName), "last modification");
			if (listeners != null) {
				for (int i = 0; i < listeners.size(); i++) {
					((PropertiesListener) listeners.get(i))
							.propertiesStored(this);
				}
			}
		} catch (IOException exc) {
			logger.debug("failed to store property to file: " + fileName);
			exc.printStackTrace();
		}
	}

	public double getDoubleProperty(String key, double defaultValue) {
		String p = getProperty(key);
		if (p == null) {
			setProperty(key, String.valueOf(defaultValue));
			storeProperty();
			return defaultValue;
		}
		try {
			double d = Double.parseDouble(p);
			return d;
		} catch (NumberFormatException nfe) {
			return defaultValue;
		}
	}

	public int getIntProperty(String key, int defaultValue) {
		String p = getProperty(key);
		if (p == null) {
			setProperty(key, String.valueOf(defaultValue));
			storeProperty();
			return defaultValue;
		}
		try {
			int i = Integer.parseInt(p);
			return i;
		} catch (NumberFormatException nfe) {
			return defaultValue;
		}
	}

	public double[] getDoubleArrayProperty(String key, double[] defaultValue) {
		String p = getProperty(key);
		if (p == null) {
			String str = "";
			for (int i = 0; i < defaultValue.length; i++)
				str += String.valueOf(defaultValue[i]) + ",";
			str = str.substring(0, str.length() - 1);
			setProperty(key, str);
			storeProperty();
			return defaultValue;
		}
		try {
			String[] aa = p.split(",");
			double[] ret = new double[aa.length];
			for (int i = 0; i < aa.length; i++)
				ret[i] = Double.parseDouble(aa[i].trim());
			return ret;
		} catch (NumberFormatException nfe) {
			return defaultValue;
		}
	}

	public int[] getIntArrayProperty(String key, int[] defaultValue) {
		String p = getProperty(key);
		if (p == null) {
			String str = "";
			for (int i = 0; i < defaultValue.length; i++)
				str += String.valueOf(defaultValue[i]) + ",";
			str = str.substring(0, str.length() - 1);
			setProperty(key, str);
			storeProperty();
			return defaultValue;
		}
		try {
			String[] aa = p.split(",");
			int[] ret = new int[aa.length];
			for (int i = 0; i < aa.length; i++)
				ret[i] = Integer.parseInt(aa[i].trim());
			return ret;
		} catch (NumberFormatException nfe) {
			return defaultValue;
		}
	}

}
