/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/06, 19:26
!  AUTHOR(S): KOGA, Junichiro
!  File : EpsOutParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel.parsers;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;

/**
 * epsmaińuF_EPSOUTt@Cṽp[T[.
 * 
 * @author
 */
public class EpsOutParser extends OutputParser implements ProgressInfo {
    private Logger logger = Logger.getLogger(EpsOutParser.class.getName());

    private OutputData dielectric;

    /**
     * @param fileName
     *            F_EPSOUTt@Cւ̃pX.
     */
    public EpsOutParser(String fileName) {
        super(fileName);
    }

    protected boolean parse() {
        String dir = new File(fileName).getParent();

        String line = "";
        try {
            String firstLine = reader.readLine();
            if (firstLine.trim().startsWith("Dielectric Function")) {
                reader.readLine();
                String[] identDielectric = new String[] { "energy (ev)",
                        "real part", "imaginary part", "n", "k", "abs", "R" };
                Vector dat = new Vector();
                while ((line = reader.readLine()) != null) {
                    dat.addElement(line.trim().split("\\s+"));
                }
                String[][] foobar = new String[dat.size()][identDielectric.length];
                try {
                    for (int i = 0; i < dat.size(); i++) {
                        foobar[i] = (String[]) dat.elementAt(i);
                    }
                } catch (Exception exc) {
                    exc.printStackTrace();
                    logger.error("failed to parse " + fileName);
                }
                OutputData outputData = new OutputData(
                        "dielectric function and optical properties",
                        "dielectric function and optical properties",
                        identDielectric, foobar, null);
                outputData.setFileName(fileName);
                addOutputData(outputData);
            } else if (firstLine.trim().startsWith("Dielectric Tensor")) {
                String[] ident = new String[] { "energy (eV)", "xx", "yy",
                        "zz", "xy", "xz", "yz" };
                Vector dat = new Vector();
                Vector dat2 = new Vector();
                reader.readLine();
                reader.readLine();
                while ((line = reader.readLine()) != null) {
                    String[] real = line.trim().split("\\s+");
                    dat.addElement(real);
                    line = reader.readLine();
                    line = line.replaceAll("\\(", "");
                    line = line.replaceAll("\\)", "");
                    String[] foo = line.trim().split("\\s+");
                    String[] foo2 = new String[foo.length + 1];
                    foo2[0] = real[0];
                    for (int i = 1; i < foo2.length; i++) {
                        foo2[i] = foo[i - 1];
                    }
                    dat2.addElement(foo2);
                }
                String[][] foobar = new String[dat.size()][ident.length];
                String[][] foobar2 = new String[dat2.size()][ident.length];
                try {
                    for (int i = 0; i < dat.size(); i++) {
                        foobar[i] = (String[]) dat.elementAt(i);
                        foobar2[i] = (String[]) dat2.elementAt(i);
                    }
                } catch (Exception exc) {
                    exc.printStackTrace();
                    logger.error("failed to parse " + fileName);
                }
                OutputData outputData = new OutputData("real part",
                        "dielectric tensor", ident, foobar, null);
                OutputData outputData2 = new OutputData("imaginary part",
                        "dielectric tensor", ident, foobar2, null);
                outputData.setFileName(fileName);
                outputData2.setFileName(fileName);
                addOutputData(outputData);
                addOutputData(outputData2);
            }
        } catch (IOException ioe) {
            logger.error("failed parse of F_EPSOUT file");
            ioe.printStackTrace();
            return false;
        } finally {
            isDone = true;
            try {
                reader.close();
            } catch (Exception exc) {
            }
        }

        return true;
    }

    public String getCurrentMessage() {
        return null;
    }

}
