/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 19:13
!  AUTHOR(S): KOGA, Junichiro
!  File : ChargePanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.postprocessing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class ChargePanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(ChargePanel.class.getName());

    /** Creates a new instance of ChargePanel */
    public ChargePanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(new ChargePanelPanel(projectInfo.getInputInterface()));
    }

    public void init() {
    }

    public void initializeProject() {
    }

}

class ChargePanelPanel extends PhaseInputItems {
    private static Logger logger = Logger.getLogger(ChargePanelPanel.class
            .getName());

    protected ChargePanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    private ChoicePanelPhase cppchargesw;
    private ChoicePanelPhase cppfiletype;
    private ChoicePanelPhase cpptype;
    private ChoicePanelPhase cppsw_partial;

    public void createGUI() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

        JPanel p_charge = new JPanel();
        // p_charge.setLayout(new GridLayout(2, 2, 1, 1));
        p_charge.setLayout(new BoxLayout(p_charge, BoxLayout.X_AXIS));

        String[] chargesw = { "postprocessing.charge.sw_charge_rspace" };
        cppchargesw = new ChoicePanelPhase(chargesw, inputInterface,
                "charge output", ON_OFF, ON_OFF_DUPLI, this);
        Dimension dim = cppchargesw.getPreferredSize();
        Dimension newdim = new Dimension(dim.width + 20, dim.height);
        cppchargesw.setPreferredSize(newdim);
        p_charge.add(cppchargesw);

        String[] filetype = { "postprocessing.charge.filetype" };
        String[] types = { NO_SELECTION, "cube", "density_only" };
        cppfiletype = new ChoicePanelPhase(filetype, inputInterface,
                "file type", types, this);
        p_charge.add(cppfiletype);

        cppchargesw.getComboBox().addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                if (cppchargesw.getComboBox().getSelectedIndex() == 1)
                    cppfiletype.getComboBox().setSelectedIndex(1);
            }
        });

        String[] title = { "postprocessing.charge.title" };
        InputPanelPhase ipptitle = new InputPanelPhase(title, inputInterface,
                "title", InputPanelPhase.NONE, 15, this, true);
        p_charge.add(ipptitle);

        cppchargesw.registerDisabableGUI(new int[] { 0, 2 }, cppfiletype);
        cppchargesw.registerDisabableGUI(new int[] { 0, 2 }, ipptitle);

        p_charge.setBorder(new TitledBorder("valence charge"));

        JPanel p_partial = new JPanel();
        p_partial.setLayout(new BoxLayout(p_partial, BoxLayout.Y_AXIS));
        p_partial.setBorder(new TitledBorder("partial charge"));

        JPanel p_partial1 = new JPanel();
        p_partial1.setLayout(new BoxLayout(p_partial1, BoxLayout.X_AXIS));
        JPanel p_partial2 = new JPanel();
        p_partial2.setLayout(new BoxLayout(p_partial2, BoxLayout.X_AXIS));

        String tag_partial = "postprocessing.charge.partial_charge.";
        String[] sw_partial = new String[] { tag_partial + "sw_partial_charge" };
        cppsw_partial = new ChoicePanelPhase(sw_partial, inputInterface,
                "partial charge", ON_OFF, ON_OFF_DUPLI, this);

        String[] partial_type = new String[] { tag_partial
                + "partial_charge_filetype" };
        String[] choice_partial_type = new String[] {
                ChoicePanelPhase.NO_SELECTION, "individual", "integrated" };
        Vector choice_dupli = new Vector();
        choice_dupli.add(new String[] { "1", "separate" });
        cpptype = new ChoicePanelPhase(partial_type, inputInterface,
                "file type", choice_partial_type, choice_dupli, this);

        String[] min = { tag_partial + "Erange_min" };
        InputPanelPhase ippmin = new InputPanelPhase(min, inputInterface,
                "Erange (min)", InputPanelPhase.ENERGY, 7, this);
        String[] max = { tag_partial + "Erange_max" };
        InputPanelPhase ippmax = new InputPanelPhase(max, inputInterface,
                "Erange (max)", InputPanelPhase.ENERGY, 7, this);
        String[] delta = { tag_partial + "Erange_delta" };
        InputPanelPhase ippdelta = new InputPanelPhase(delta, inputInterface,
                "delta", InputPanelPhase.ENERGY, 7, this);

        p_partial1.add(cppsw_partial);
        p_partial1.add(cpptype);
        p_partial2.add(ippmin);
        p_partial2.add(ippmax);
        p_partial2.add(ippdelta);
        p_partial.add(p_partial1);
        p_partial.add(p_partial2);
        int[] disa = new int[] { 0, 2 };
        cppsw_partial.registerDisabableGUI(disa, cpptype);
        cppsw_partial.registerDisabableGUI(disa, ippmin);
        cppsw_partial.registerDisabableGUI(disa, ippmax);
        cppsw_partial.registerDisabableGUI(disa, ippdelta);
        cppsw_partial.getComboBox().addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                if (cppsw_partial.getComboBox().getSelectedIndex() == 1)
                    cpptype.getComboBox().setSelectedIndex(1);
            }
        });

        p.add(p_charge);
        p.add(p_partial);
        this.add(p);
    }

}
