/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/18, 16:53
!  AUTHOR(S): KOGA, Junichiro
!  File : AxisAttribute.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.graph.plotattributes;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import ciss.phase_viewer.common.FontChooser;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesEditor;
import ciss.phase_viewer.graph.plotattributes.PlotAttributesSubEditor;

/**
 * ̑𑀍.
 * 
 * @author
 */
public class AxisAttribute extends PlotAttributesSubEditor {
    private Logger logger = Logger.getLogger(AxisAttribute.class.getName());

    private XYPlot xyplot;
    private int DOMAIN = 0;
    private int RANGE = 1;

    /** Creates a new instance of AxisAttribute */
    public AxisAttribute(PlotAttributesEditor parent) {
        super(parent);
    }

    public boolean updateChart() {
        int numaxis = tpaxis.getTabCount();
        for (int i = 0; i < numaxis; i++) {
            logger.debug("updating axis number: " + i);
            ((AxisPanel) tpaxis.getComponentAt(i)).updateAxis();
        }
        return true;
    }

    private int numdomain;
    private int numrange;

    protected void init() {
        if (parent == null) {
            logger.debug("'parent' is null.");
            return;
        }
        Plot plot = parent.getSelectedPlot();
        if (plot == null) {
            logger.debug("'plot' is null.");
            return;
        }

        if (plot instanceof XYPlot) {
            xyplot = (XYPlot) plot;
        } else {
            return;
        }

        numdomain = xyplot.getDomainAxisCount();
        numrange = xyplot.getRangeAxisCount();
    }

    private JTabbedPane tpaxis;

    protected void initGUI() {
        removeAll();
        tpaxis = new JTabbedPane();
        setLayout(new GridLayout());
        for (int i = 0; i < numdomain; i++) {
            String xaxi = "x-axis";
            if (i > 0) {
                xaxi += String.valueOf(i);
            }
            tpaxis.addTab(xaxi,
                    new AxisPanel((NumberAxis) xyplot.getDomainAxis(i), DOMAIN,
                            i));
        }
        for (int i = 0; i < numrange; i++) {
            String yaxi = "y-axis";
            if (i > 0) {
                yaxi += String.valueOf(i);
            }
            tpaxis.addTab(
                    yaxi,
                    new AxisPanel((NumberAxis) xyplot.getRangeAxis(i), RANGE, i));
        }
        add(tpaxis);
    }

    public void plotChanged(Plot plot) {
        updateChart();
        init();
        initGUI();
        revalidate();
    }

    class AxisPanel extends JPanel {
        private int mode = DOMAIN;
        private int ID;
        private NumberAxis axis;
        private AxisPanel me;

        protected AxisPanel(NumberAxis axis, int mode, int ID) {
            super();
            this.mode = mode;
            this.ID = ID;
            me = this;
            this.axis = axis;
            setLayout(new BorderLayout());
            init();
        }

        void updateAxis() {
            if (comborange.getSelectedIndex() == 0) {
                axis.setAutoRange(true);
            } else {
                try {
                    axis.setAutoRange(false);
                    double min = Double.valueOf(tarangemin.getText())
                            .doubleValue();
                    double max = Double.valueOf(tarangemax.getText())
                            .doubleValue();
                    axis.setLowerBound(min);
                    axis.setUpperBound(max);
                } catch (NumberFormatException nfe) {
                    logger.error("invalid min/max specification.");
                }
            }

            if (combotics.getSelectedIndex() == 1) {
                axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                try {
                    int tic = Integer.parseInt(taticunits.getText());
                    axis.setTickUnit(new NumberTickUnit((double) tic));
                } catch (NumberFormatException exc) {
                    logger.error("invalid 'tic'");
                }
            } else if (combotics.getSelectedIndex() == 2) {
                try {
                    axis.setTickUnit(new NumberTickUnit(Double
                            .parseDouble(taticunits.getText())));
                } catch (NumberFormatException e) {
                    logger.error("invalid 'tic'");
                }
            }
            axis.setTickLabelFont(btnticfont.getFont());

            if (cblog.isSelected()) {
                axis = new LogarithmicAxis(axis.getLabel());
                ((LogarithmicAxis) axis).setLog10TickLabelsFlag(true);
                XYSeriesCollection col = (XYSeriesCollection) xyplot
                        .getDataset(ID);
                int numseries = col.getSeriesCount();
                for (int i = 0; i < numseries; i++) {
                    XYSeries series = col.getSeries(i);
                    for (int j = 0; j < series.getItemCount(); j++) {
                        double x = series.getX(j).doubleValue();
                        double y = series.getY(j).doubleValue();
                        if (mode == DOMAIN) {
                            if (x == 0.d) {
                                x = 0.000000000000001d;
                            }
                            double newx = Math.abs(x);
                            series.remove(j);
                            series.add(newx, y);
                        } else if (mode == RANGE) {
                            if (y == 0.d) {
                                y = 0.000000000000001d;
                            }
                            double newy = Math.abs(y);
                            series.remove(j);
                            series.add(x, newy);
                        }
                    }
                    for (int j = 0; j < series.getItemCount(); j++) {
                        logger.debug("data no." + j + ": x = " + series.getX(j)
                                + ", y = " + series.getY(j));
                    }
                }
                if (mode == DOMAIN) {
                    xyplot.setDomainAxis(axis);
                } else if (mode == RANGE) {
                    xyplot.setRangeAxis(ID, axis);
                }
            } else {
                if (axis instanceof LogarithmicAxis) {
                    axis = new NumberAxis(axis.getLabel());
                    if (mode == DOMAIN) {
                        xyplot.setDomainAxis(axis);
                    } else if (mode == RANGE) {
                        xyplot.setRangeAxis(ID, axis);
                    }
                }
            }

            if (cbgrid.isSelected()) {
                if (mode == DOMAIN) {
                    xyplot.setDomainGridlinesVisible(false);
                } else if (mode == RANGE) {
                    xyplot.setRangeGridlinesVisible(false);
                }
            }

            String label = taaxislabel.getText();
            axis.setLabel(label);
            axis.setLabelFont(btnaxisfont.getFont());
        }

        private JTextField taticunits;
        private JComboBox combotics;

        private JComboBox comborange;
        private JTextField tarangemin;
        private JTextField tarangemax;

        private JButton btnaxisfont;
        private JButton btnticfont;
        private JTextField taaxislabel;
        private JCheckBox cblog;
        private JCheckBox cbgrid;

        private void init() {
            JPanel paxis = new JPanel();
            paxis.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1;
            constraints.weighty = 0;
            constraints.fill = GridBagConstraints.HORIZONTAL;

            /* axis label */
            JPanel plabel = new JPanel();
            plabel.setLayout(new BoxLayout(plabel, BoxLayout.X_AXIS));
            taaxislabel = new JTextField(25);
            taaxislabel.setText(axis.getLabel());

            Font labelfont = axis.getLabelFont();
            btnaxisfont = new JButton("select font");
            btnaxisfont.setFont(labelfont);
            plabel.setBorder(new TitledBorder("axis label"));
            plabel.add(taaxislabel);
            plabel.add(btnaxisfont);

            paxis.add(plabel, constraints);

            /* tics */
            JPanel ptics = new JPanel();
            ptics.setLayout(new BoxLayout(ptics, BoxLayout.X_AXIS));
            String[] strtics = { "auto", "integer", "real" };
            combotics = new JComboBox(strtics);
            JPanel pcombotics = new JPanel();
            pcombotics.setBorder(new TitledBorder("tic mode"));
            pcombotics.add(combotics);

            taticunits = new JTextField(20);
            taticunits.setText(String.valueOf(axis.getTickUnit().getSize()));
            JPanel ptftic = new JPanel();
            ptftic.setBorder(new TitledBorder("tick units"));
            ptftic.add(taticunits);
            Font ticfont = axis.getTickLabelFont();
            btnticfont = new JButton("select font");
            btnticfont.setFont(ticfont);

            ptics.setBorder(new TitledBorder("tics"));
            ptics.add(pcombotics);
            ptics.add(ptftic);
            ptics.add(btnticfont);

            constraints.gridy = 1;
            paxis.add(ptics, constraints);

            /* range */
            String[] strrange = { "auto", "manual" };
            JPanel prange = new JPanel();
            prange.setLayout(new BoxLayout(prange, BoxLayout.X_AXIS));
            comborange = new JComboBox(strrange);
            JPanel pcomborange = new JPanel();
            pcomborange.setBorder(new TitledBorder("range mode"));
            pcomborange.add(comborange);
            tarangemin = new JTextField(15);
            tarangemin.setText(String.valueOf(axis.getRange().getLowerBound()));
            tarangemax = new JTextField(15);
            tarangemax.setText(String.valueOf(axis.getRange().getUpperBound()));

            JPanel ptfmin = new JPanel();
            ptfmin.setBorder(new TitledBorder("min value"));
            ptfmin.add(tarangemin);

            JPanel ptfmax = new JPanel();
            ptfmax.setBorder(new TitledBorder("max value"));
            ptfmax.add(tarangemax);

            prange.setBorder(new TitledBorder("range"));
            prange.add(pcomborange);
            prange.add(ptfmin);
            prange.add(ptfmax);

            constraints.gridy = 2;
            paxis.add(prange, constraints);

            /* log scale, show grid */
            JPanel ploggrid = new JPanel();
            // ploggrid.setLayout(new BoxLayout(ploggrid, BoxLayout.X_AXIS));
            cblog = new JCheckBox("log scale");
            cbgrid = new JCheckBox("do not show grid");
            ploggrid.add(cblog);
            ploggrid.add(cbgrid);
            ploggrid.setBorder(new TitledBorder("other axis-related properties"));

            constraints.gridy = 3;
            paxis.add(ploggrid, constraints);

            add(paxis, BorderLayout.NORTH);

            btnaxisfont.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    Font font = FontChooser.chooseFont(btnaxisfont.getFont(),
                            me);
                    btnaxisfont.setFont(font);
                }
            });

            btnticfont.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    Font font = FontChooser.chooseFont(btnticfont.getFont(), me);
                    btnticfont.setFont(font);
                }
            });

            combotics.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    if (combotics.getSelectedIndex() == 0) {
                        taticunits.setEnabled(false);
                    } else {
                        taticunits.setEnabled(true);
                    }
                }
            });
            combotics.setSelectedIndex(0);

            comborange.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    if (comborange.getSelectedIndex() == 0) {
                        tarangemax.setEnabled(false);
                        tarangemin.setEnabled(false);
                    } else {
                        tarangemax.setEnabled(true);
                        tarangemin.setEnabled(true);
                    }
                }
            });
            comborange.setSelectedIndex(0);
        }
    }

}
