/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/11/20 13:41:38
!  AUTHOR(S): KOGA, Junichiro
!  File : SeriesInfo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.graph.plotattributes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

import org.apache.log4j.Logger;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;

/**
 * Series̎wɕKvȏێ.
 */
public class SeriesInfo {
    private Logger logger = Logger.getLogger(SeriesInfo.class.getName());

    public static int LINE = 0;

    public static int SHAPE = 1;

    public static int LINE_AND_SHAPE = 2;

    private XYPlot xyplot;

    private Color color;

    private int plottype = 0;

    private int linetype = 0;

    private int shapetype = 0;

    private int index;

    private float linewidth = -1.f;

    private double shapesize = -1.d;

    /**
     * @param xyplot
     *            SeriesƊ֘AtꂽXYPlotIuWFNg
     * @param index
     *            ԖڂSeriesȂ̂w.
     */
    public SeriesInfo(XYPlot xyplot, int index) {
        this.xyplot = xyplot;
        this.index = index;
        init();
    }

    /**
     * wSeriesInfoRs[ď.
     * 
     * @param info
     */
    public SeriesInfo(SeriesInfo info) {
        copy(info);
    }

    private void init() {
        XYItemRenderer renderer = xyplot.getRenderer();
        color = (Color) renderer.getSeriesPaint(index);
        Stroke stroke = renderer.getBaseStroke();
        if (stroke instanceof BasicStroke) {
            linewidth = ((BasicStroke) stroke).getLineWidth();
        }
        shapesize = renderer.getBaseShape().getBounds().width;
    }

    /**
     * vbgZbg. _, Ȃ.
     * 
     * @param plottype
     *            vbg.
     */
    public void setPlotType(int plottype) {
        this.plottype = plottype;
    }

    /**
     * ̎w
     * 
     * @param linetype
     *            w.
     */
    public void setLineType(int linetype) {
        this.linetype = linetype;
    }

    /**
     * shapevbgۂ, shapě`w.
     * 
     * @param shapetype
     *            ushapev
     */
    public void setShapeType(int shapetype) {
        this.shapetype = shapetype;
    }

    /**
     * `.
     * 
     * @param linewidth
     *            
     */
    public void setLineWidth(float linewidth) {
        this.linewidth = linewidth;
    }

    /**
     * u`v̑傫`
     * 
     * @param shapesize
     *            `̑傫.
     */
    public void setShapeSize(double shapesize) {
        this.shapesize = shapesize;
    }

    /**
     * Series̕`Fw.
     * 
     * @param color
     *            w肵Series̐F
     */
    public void setColor(Color color) {
        this.color = color;
    }

    /**
     * Őݒ肵ColorԂ.
     * 
     * @return color
     */
    public Color getColor() {
        return color;
    }

    /**
     * uvbgv̎擾.
     * 
     * @return vbg
     */
    public int getPlotType() {
        return plottype;
    }

    /**
     * ̋Lq@̎擾
     * 
     * @return ̋Lq@
     */
    public int getLineType() {
        return linetype;
    }

    /**
     * _̎擾
     * 
     * @return _
     */
    public int getShapeType() {
        return shapetype;
    }

    /**
     * ̎擾
     * 
     * @return 
     */
    public float getLineWidth() {
        return linewidth;
    }

    /**
     * _̑傫擾.
     * 
     * @return _̑傫
     */
    public double getShapeSize() {
        return shapesize;
    }

    public String toString() {
        return "index: " + index + " color: " + color + " plottype: "
                + plottype + " linetype: " + linetype + " shapetype: "
                + shapetype + " linewidth: " + linewidth + " shapesize: "
                + shapesize;
    }

    public void copy(SeriesInfo info) {
        this.color = info.getColor();
        this.linetype = info.getLineType();
        this.linewidth = info.getLineWidth();
        this.plottype = info.getPlotType();
        this.shapesize = info.getShapeSize();
        this.shapetype = info.getShapeType();
    }

    /**
     * SeriesɊ֘AtꂽXYPlot, wrenderer̃CfbNX𗘗pčXV.
     * 
     * @param rendererIndex
     *            _[̃CfbNX
     * @return ܂sȂꍇfalse
     */
    public boolean update(int rendererIndex) {
        return update(this.xyplot, rendererIndex, index);
    }

    /**
     * Series, wXYPlotXV.
     * 
     * @param xyPlot
     *            XVXYPlot.
     * @return ܂sȂꍇfalse
     */
    public boolean update(XYPlot xyPlot) {
        return update(xyPlot, 0, 0);
    }

    /**
     * Series, wXYPlotXV.
     * 
     * @param xyPlot
     *            XVXYPlot.
     * @param rendererIndex
     *            XVV[Ỹ_[̃CfbNX
     * @return ܂Ȃꍇfalse
     */
    public boolean update(XYPlot xyPlot, int rendererIndex) {
        return update(xyPlot, rendererIndex, index);
    }

    /**
     * SeriesInfoɎwXYPlotXV.
     * 
     * @param xyPlot
     *            XVXYPlot.
     * @param rendererIndex
     *            _[̃CfbNX. ftHg: 0
     * @param ΉSeries̃CfbNX
     *            . ftHg: 0
     * @return ܂sȂꍇfalse
     */
    public boolean update(XYPlot xyPlot, int rendererIndex, int seriesIndex) {
        StandardXYItemRenderer srenderer = null;
        if (xyplot.getRenderer(rendererIndex) instanceof StandardXYItemRenderer) {
            logger.debug("rendererIndex: " + rendererIndex);
            srenderer = (StandardXYItemRenderer) xyplot
                    .getRenderer(rendererIndex);
        } else {
            logger.error("invalid renderer.");
            return false;
        }

        logger.debug(this);
        float linewidth = this.getLineWidth();
        double shapesize = this.getShapeSize();

        srenderer.setDrawSeriesLineAsPath(true);
        if (this.getPlotType() == LINE) {
            shapesize = 0.0d;
            srenderer.setBaseShapesVisible(false);
            srenderer.setPlotLines(true);
        } else if (this.getPlotType() == SHAPE) {
            linewidth = -1.f;
            srenderer.setBaseShapesVisible(true);
            srenderer.setPlotLines(false);
        } else if (this.getPlotType() == LINE_AND_SHAPE) {
            srenderer.setBaseShapesVisible(true);
            srenderer.setPlotLines(true);
        }

        logger.debug("line width, shape size: " + linewidth + ", " + shapesize);

        PlotShapesAndLines psal = new PlotShapesAndLines();
        srenderer.setShapesFilled(true);
        srenderer.setSeriesPaint(seriesIndex, this.getColor());
        srenderer.setSeriesShape(seriesIndex,
                psal.getShape(this.getShapeType(), shapesize));
        srenderer.setSeriesStroke(seriesIndex,
                psal.getLine(this.getLineType(), linewidth));
        xyplot.setRenderer(rendererIndex, srenderer);

        return true;
    }
}
