/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 11:36
!  AUTHOR(S): KOGA, Junichiro
!  File : GUIBootButton.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.EventObject;

import javax.swing.JButton;
import javax.swing.JDesktopPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * 
 * @author KOGA, Junichiro
 */
public class GUIBootButton extends JButton implements Command {
    private static Logger logger = Logger.getLogger(GUIBootButton.class
            .getName());

    private InputInterface inputInterface;

    private Object arg;
    private Object[] args;
    private JDesktopPane desktop;
    private Class cla;
    private int choice = 0;

    public GUIBootButton(String buttonName, InputInterface inputInterface,
            Class cla, ActionListener listener) {
        super(buttonName);
        super.addActionListener(listener);
        this.args = new Object[] { inputInterface };
        this.desktop = Desk.getDesktop();
        this.cla = cla;
    }

    public GUIBootButton(String buttonName, AtomCoords atomCoords, Class cla,
            ActionListener listener) {
        super(buttonName);
        super.addActionListener(listener);
        this.args = new Object[] { atomCoords, new Integer(0) };
        this.desktop = Desk.getDesktop();
        this.cla = cla;
    }

    public void setChoice(int choice) {
        this.choice = choice;
        args = new Object[] { args[0], new Integer(choice) };
    }

    public void execute(EventObject e) {
        Constructor[] constructors = cla.getDeclaredConstructors();
        try {
            Object o = constructors[0].newInstance(args);
            InternalFrameChase frame = (InternalFrameChase) o;
            frame.setVisible(true);
            logger.debug("successfully loaded GUI: " + cla.getName());
        } catch (Exception ie) {
            logger.error("failed to load GUI: " + cla.getName());
            ie.printStackTrace();
        }
    }

}
