/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/06/02, 19:00
!  AUTHOR(S): KOGA, Junichiro
!  File : ProcessMenu.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.mainpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.process.ProcessViewer;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.Execute;
import ciss.phase_viewer.ssh.SessionCreator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.ssh.hosts.MyUserInfo;

import com.jcraft.jsch.Session;

/**
 * 
 * @author KOGA, Junichiro
 */
class ProcessMenu extends JMenu {
    /** Creates a new instance of ProcessMenu */
    public ProcessMenu(String title, int shortcut) {
        super(title);
        setMnemonic(shortcut);
        init();
    }

    private void init() {
        this.getPopupMenu().setLightWeightPopupEnabled(false);
        addMenuListener(new MenuListenerProcess(this));
    }
}

class MenuListenerProcess implements MenuListener {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(MenuListenerProcess.class.getName());

    private JMenu window;
    private HostList hostlist = HostList.getHostList();

    protected MenuListenerProcess(JMenu window) {
        this.window = window;
    }

    public void menuSelected(MenuEvent e) {
        int numhosts = hostlist.size();
        for (int i = 0; i < numhosts; i++) {
            ProcessMenuItem pmi = new ProcessMenuItem(hostlist.getHostInfo(i));
            window.add(pmi);
        }
    }

    public void menuDeselected(MenuEvent e) {
        window.removeAll();
    }

    public void menuCanceled(MenuEvent e) {
        window.removeAll();
    }

}

class ProcessMenuItem extends JMenuItem {

    private HostInfo hostinfo;

    protected ProcessMenuItem(HostInfo hostinfo) {
        super(hostinfo.getName());
        this.hostinfo = hostinfo;
        init();
    }

    private void init() {
        addActionListener(new ProcessMenuItemListener(hostinfo));
    }
}

class ProcessMenuItemListener implements ActionListener {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(ProcessMenuItemListener.class.getName());

    private HostInfo hostinfo;

    protected ProcessMenuItemListener(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    public void actionPerformed(ActionEvent e) {
        doIt();
    }

    private void doIt() {
        String command;
        MyUserInfo userinfo = new MyUserInfo(hostinfo);
        String user = hostinfo.getProperty("username");
        String hostname = hostinfo.getProperty("address");

        if (hostname.trim().equals("127.0.0.1")
                || hostname.trim().equals("localhost")) {
            if (ConstParameters.osName.toLowerCase().trim()
                    .startsWith("windows")) {
                GlobalProperties propChase = PropertiesManager
                        .getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);
                String taskmgr = propChase.getProperty("taskmgr");
                MyThread th = new MyThread(taskmgr);
                return;
            } else {
                ProcessViewer psv = new ProcessViewer();
                psv.start();
                return;
            }
        }

        try {
            Session session = SessionCreator.getSession(hostinfo);
            Execute exe = new Execute(session);
            ProcessViewer psv = new ProcessViewer(exe, user);
            psv.start();
        } catch (Exception exc) {
            logger.error("failed connection");
            exc.printStackTrace();
        }

    }

}
