/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : InternalFrameChase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.mainpanel;

import java.awt.Dimension;

import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import org.apache.log4j.Logger;

public abstract class InternalFrameChase extends AbstractInternalFrameChase {
    private static Logger logger = Logger.getLogger(InternalFrameChase.class
            .getName());

    public InternalFrameChase() {
        super();
    }

    public InternalFrameChase(Dimension size) {
        super(size);
    }

    public InternalFrameChase(String title) {
        super(title);
    }

    public InternalFrameChase(String title, Dimension size) {
        super(title, size);
    }

    public InternalFrameChase(String title, boolean b1) {
        super(title, b1);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2) {
        super(title, b1, b2);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2, boolean b3) {
        super(title, b1, b2, b3);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2, boolean b3,
            boolean b4) {
        super(title, b1, b2, b3, b4);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2, boolean b3,
            boolean b4, Dimension size) {
        super(title, b1, b2, b3, b4, size);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2, boolean b3,
            boolean b4, Dimension size, String ID) {
        super(title, b1, b2, b3, b4, size, ID);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2, boolean b3,
            boolean b4, Dimension size, boolean initVisible) {
        super(title, b1, b2, b3, b4, size, initVisible);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2, boolean b3,
            boolean b4, int location) {
        super(title, b1, b2, b3, b4, location);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2, boolean b3,
            boolean b4, Dimension size, int location) {
        super(title, b1, b2, b3, b4, size, location);
    }

    public InternalFrameChase(String title, boolean b1, boolean b2, boolean b3,
            boolean b4, Dimension size, int location, boolean initVisible) {
        super(title, b1, b2, b3, b4, size, location, initVisible);
    }

    void addListeners() {
        String listen2 = props
                .getProperty("listen_to_activation_of_internal_frame");
        if (listen2 == null || !listen2.trim().equals("false")) {
            super.addInternalFrameListener(new InternalFrameAdapterChase());
        }
    }

    public boolean isHeavyWeight() {
        return false;
    }

    public void dispose() {
        postProcess(this);
        super.dispose();
    }

    /**
     * InternalFrameI; dispose()Ă񂾂ƎInternalFrameIԂɂ, ݂ȂƂ.
     * 
     * @param frame
     *            ^[QbgInternalFrame
     */
    public static void postProcess(JInternalFrame frame) {
        Desk desktop = ((Desk) Desk.getDesktop());
        JInternalFrame[] frames = desktop.getAllFrames();
        JInternalFrame prevframe = null;
        if (frames != null) {
            for (int i = 0; i < frames.length; i++) {
                if (frames[i] == frame) {
                    if (i == frames.length - 1) {
                        prevframe = frames[0];
                    } else {
                        prevframe = frames[i + 1];
                    }
                    break;
                }
            }
        }
        if (prevframe != null) {
            try {
                prevframe.setSelected(true);
            } catch (Exception exc) {
            }
        }
    }
}

class InternalFrameAdapterChase extends InternalFrameAdapter {

    protected InternalFrameAdapterChase() {
    }

    public void internalFrameActivated(InternalFrameEvent ife) {
        ChaseFrame fr = (ChaseFrame) ife.getSource();
        fr.selected();
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        InternalFrameChase.postProcess((JInternalFrame) e.getSource());
    }

    public void internalFrameIconified(InternalFrameEvent e) {
        super.internalFrameIconified(e);
        // JComponent component =
        // ((JInternalFrame)e.getSource()).getDesktopIcon();
        // Dimension dimen =
        // ((Desktop)Desktop.getDesktop()).getScrollPane().getSize();
        // component.setLocation(component.getLocation().x,
        // (int)(dimen.getHeight()-component.getSize().getHeight()));
    }

    public void internalFrameClosed(InternalFrameEvent ife) {
        // ((Desktop) Desktop.getDesktop()).selectLast();
        ((Desk) Desk.getDesktop()).scrollBarUpdate();
    }

}
