/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/12, 11:39
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseProgressMonitor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.mainpanel;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.TimerTask;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

import org.apache.log4j.Logger;

/**
 * CGUIɂProgressMonitor... ܂肤܂ĂȂǈꉞ\ł?
 */
public class ChaseProgressMonitor extends JPanel {
    private static ChaseProgressMonitor monitor;
    private Logger logger = Logger.getLogger(ChaseProgressMonitor.class
            .getName());
    private JProgressBar progressBar;
    private JLabel label;
    private java.util.Timer timer = new java.util.Timer();
    private ProgressInfo info;

    private JPanel mon;
    private String ws = "                                                                              ";
    private boolean bool = true;

    /** Creates a new instance of ChaseProgressMonitor */
    private ChaseProgressMonitor() {
        setLayout(new BorderLayout());
        setMaximumSize(new Dimension(600, 40));
        mon = this;
        progressBar = new JProgressBar(0, 100);
        progressBar.setStringPainted(true);
        label = new JLabel(ws);
        add(label, BorderLayout.WEST);
        add(progressBar, BorderLayout.CENTER);
    }

    public static ChaseProgressMonitor getMonitor() {
        if (monitor == null) {
            monitor = new ChaseProgressMonitor();
        }
        return monitor;
    }

    void init() {
        progressBar.setVisible(false);
    }

    private MonitorTask task;

    public void setProgress(ProgressInfo info_) {
        if (info_ == null) {
            return;
        }
        this.info = info_;
        String name = "";
        String s = info_.getNameOfProgress();
        if (s != null) {
            name = s;
        }
        label.setText(name);
        progressBar.setMinimum(0);
        progressBar.setMaximum(info.getLength());
        progressBar.setVisible(true);
        // progressBar.paintImmediately(0,0,Chase.getScreenWidth(),Chase.getScreenHeight());
        revalidate();
        timer = new java.util.Timer();
        task = new MonitorTask();
        timer.schedule(task, 0, 100);
    }

    /**
     * vOXIɎ~߂. OłĂׂ.
     */
    public void stop() {
        task.cancel();
        progressBar.setValue(0);
        label.setText(ws);
        progressBar.setVisible(false);
        if (info != null) {
            info.done();
            info = null;
        }
    }

    class MonitorTask extends TimerTask {
        MonitorTask() {
        }

        public void run() {
            if (info == null) {
                return;
            }
            progressBar.setValue(info.getCurrent());
            String message = info.getCurrentMessage();
            if (message != null && message.length() != 0) {
                label.setText(message);
            }
            if (info == null) {
                return;
            }
            if (info.isDone()) {
                stop();
            }
            // progressBar.paintImmediately(0,0,Chase.getScreenWidth(),Chase.getScreenHeight());
            // label.paintImmediately(0,0,Chase.getScreenWidth(),Chase.getScreenHeight());
            revalidate();
        }

    }

    class DummyInfo implements ProgressInfo {
        long boot;

        DummyInfo() {
            boot = Calendar.getInstance().getTimeInMillis();
        }

        public boolean isDone() {
            long now = Calendar.getInstance().getTimeInMillis();
            if (now - boot > 10) {
                return true;
            }
            return false;
        }

        public String getNameOfProgress() {
            return ws;
        }

        public int getLength() {
            return 100;
        }

        public String getCurrentMessage() {
            return null;
        }

        public int getCurrent() {
            return 0;
        }

        public void done() {
        }

    }
}
