/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : Chase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.mainpanel;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

public class Chase {
    private static Logger logger = Logger.getLogger(Chase.class.getName());

    private static ChaseGUI gui;

    private final String FS = System.getProperty("file.separator");

    public Chase(boolean splash) {
        // check if this is a first-time boot, and copy setting files if
        // necessary
        if (!this.checkInstallation()) {
            System.out.println("failed installation ... exiting program");
            System.exit(0);
        }
        gui = new ChaseGUI(splash);
    }

    public static ChaseGUI getGUI() {
        return gui;
    }

    public static void updateUI() {
        try {
            SwingUtilities.updateComponentTreeUI(gui);
        } catch (Exception exc) {
            // logger.error("failed update of UI");
            // exc.printStackTrace();
        }
    }

    public static void setUI(String str) {
        try {
            UIManager.setLookAndFeel(str);
            updateUI();
        } catch (Exception exc) {
            logger.error("Error loading L&F: " + str);
            exc.printStackTrace();
        }
    }

    private boolean checkInstallation() {
        boolean ret = true;

        String chaseini = System.getProperty("user.home") + FS
                + ".phase-viewer";
        String chaseInstDir = System.getProperty("pviewer.home") + FS
                + "install" + FS + "install_files";

        File file = new File(chaseini);
        if (!file.exists()) {
            if (!file.mkdir()) {
                System.out.println("failed to create " + chaseini
                        + " ... exiting program");
                System.exit(0);
            }
        } else if (!file.isDirectory()) {
            System.out.println(chaseini
                    + " must be a directory ... exiting program");
            System.exit(0);
        }

        GlobalProperties gpini = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_INSTALLATION);
        Enumeration filenames = gpini.propertyNames();

        ret = generateDefaultDotChaseDir(false);
        return ret;
    }

    /**
     * .phase-viewerfBNg[̒g쐬B㏑邩ȂIׂB
     * 
     * @param overwrite
     *            ㏑Ȃtrue
     * @return t@C̃Rs[Ɏsꍇfalse.
     */
    public static boolean generateDefaultDotChaseDir(boolean overwrite) {
        boolean ret = true;
        String FS = System.getProperty("file.separator");
        String chaseini = System.getProperty("user.home") + FS
                + ".phase-viewer";
        String chaseInstDir = System.getProperty("pviewer.home") + FS
                + "install" + FS + "install_files";

        GlobalProperties gpini = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_INSTALLATION);
        Enumeration filenames = gpini.propertyNames();

        while (filenames.hasMoreElements()) {
            String ident = (String) filenames.nextElement();
            String value = gpini.getProperty(ident);
            File checkFile = new File(chaseini + FS + value);
            if (!checkFile.exists() || overwrite) {
                try {
                    File origFile = new File(chaseInstDir + FS + value);
                    if (!origFile.isDirectory()) {
                        ExternalProgramExecuter.copy(chaseInstDir + FS + value,
                                chaseini + FS + value);
                        // System.out.println("copied " + chaseInstDir + FS
                        // + value + " to " + chaseini + FS + value);
                        logger.debug("copied " + chaseInstDir + FS + value
                                + " to " + chaseini + FS + value);
                    } else {
                        Utils.copyDir(new File(chaseInstDir + FS + value),
                                new File(chaseini));
                        // System.out.println("copied dir: " + value);
                        logger.debug("copied dir: " + value);
                    }
                } catch (Exception exc) {
                    System.out.println("failed to copy " + chaseInstDir + FS
                            + value);
                    logger.error("failed to copy " + chaseInstDir + FS + value);
                    return false;
                }
            }
        }

        Vector<String> subprojs = ProjectBrowserUtils
                .getSupportedSubProjectTypes();
        for (String subproj : subprojs) {
            File jobscriptDir = new File(chaseini + FS + "scripts" + FS
                    + "jobcontrol" + FS + subproj);
            if (!jobscriptDir.exists()) {
                if (!jobscriptDir.mkdir()) {
                    System.out.println("failed to create " + jobscriptDir
                            + " ... exiting program");
                    System.exit(0);
                }
                File fromDir = new File(chaseInstDir + FS + "scripts" + FS
                        + "jobcontrol" + FS + subproj);
                File toDir = jobscriptDir.getParentFile();
                if(fromDir.exists())
                    Utils.copyDir(fromDir,toDir);
            }
        }

        return ret;
    }
}
