/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/25, 18:31
!  AUTHOR(S): KOGA, Junichiro
!  File : FontChooser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.common;

import java.awt.Component;
import java.awt.Font;

import org.apache.log4j.Logger;

import say.swing.JFontChooser;

/**
 * FontIpGUIN.
 * 
 * @author
 */
public class FontChooser {
    private static Logger logger = Logger
            .getLogger(FontChooser.class.getName());

    /** Creates a new instance of FontChooser */
    private FontChooser() {
    }

    public static Font chooseFont(Font initialfont, Component parent) {
        JFontChooser fontChooser = new JFontChooser();
        fontChooser.setSelectedFont(initialfont);
        int result = fontChooser.showDialog(parent);
        if (result == JFontChooser.OK_OPTION) {
            Font choosedFont = fontChooser.getSelectedFont();
            return choosedFont;
        } else {
            Font choosedFont = new Font("Helvetica", Font.PLAIN, 12);
            return choosedFont;
        }
    }

}
