/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/25, 19:21
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseExporter.java
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord.io;

import java.beans.PropertyChangeListener;
import java.io.File;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.jdom.XMLUtils;

/**
 * uChaseqzu`vɂo.
 *
 * @author
 */
public class ChaseExporter implements Exporter {
    private Logger logger = Logger.getLogger(ChaseExporter.class.getName());

    /** Creates a new instance of ChaseExporter */
    public ChaseExporter() {
    }

    public void createOptionsPanel(boolean heavy,
            PropertyChangeListener listener, String fileName) {
    }

    public boolean writeAtomCoordsTo(
            ciss.phase_viewer.atomcoord.AtomCoords[] coords, String fileName) {
        logger.info("exporting atomic coordinates in 'phase-viewer' format to file "
                + fileName);
        if (coords == null || coords.length == 0) {
            logger.error("no coordinates to export.");
            return false;
        }

        String version = "";
        try {
            Document foo = XMLUtils.getDocumentFromURL(ChaseExporter.class
                    .getResource("/ciss/phase_viewer/main/properties.xml"));
            version = " version "
                    + foo.getRootElement().getChildTextTrim("version");
        } catch (Exception exc) {
            exc.printStackTrace();
        }

        Document document = new Document();
        Element root = new Element("chase_atomic_coordinates");
        document.setRootElement(root);
        root.setAttribute(new Attribute("creator", "PHASE-Viewer" + version));
        root.setAttribute(new Attribute("numframes", String
                .valueOf(coords.length)));
        for (int i = 0; i < coords.length; i++) {
            logger.info("doing frame no. " + i);
            root.addContent(coords[i].getXMLElement(i));
        }
        XMLUtils.saveDocumentTo(document, fileName);
        logger.info("...done.");
        return true;
    }

    public boolean hasOptions() {
        return false;
    }

    public String getType() {
        return "phase-viewer";
    }

    public javax.swing.filechooser.FileFilter getFileFilter() {
        return new ChaseFileFilter();
    }

    public void setOptions(java.util.HashMap options) {
    }

	@Override
	public String getDefaultFileName() {
		return "chase.xml";
	}

}

class ChaseFileFilter extends javax.swing.filechooser.FileFilter {
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }

        String fileName = f.getName().toLowerCase();

        if (fileName != null) {
            if (fileName.endsWith(".phase-viewer") || fileName.endsWith(".xml")) {
                return true;
            } else {
                return false;
            }
        }

        return false;
    }

    public String getDescription() {
        return "chase atomic coordinates file (*.xml)";
    }
}
