/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/04, 15:22
!  AUTHOR(S): KOGA, Junichiro
!  File : Plane.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.geom;

import javax.media.j3d.BranchGroup;
import javax.vecmath.Point3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.VectorOperations;

/**
 * ""\. ʂ, @xNgƌ_^Ώ[?Ȃ͂.
 * 
 * @author
 */
public class Plane extends BranchGroup implements Comparable {
    private Logger logger = Logger.getLogger(Plane.class.getName());
    protected Point3f origin = new Point3f(0.0f, 0.0f, 0.0f);
    protected Point3f normal = new Point3f(0.0f, 0.0f, 1.0f);

    protected Point3f origin_buff = new Point3f(origin);
    protected Point3f normal_buff = new Point3f(normal);

    /**
     * ftHglŏ. _: 0,0,0 @xNg: 0,0,1
     */
    public Plane() {
    }

    /**
     * @xNg^ď. ꉞ, KiĂ邱Ƃz.
     * 
     * @param normal
     *            @xNg
     */
    public Plane(Point3f normal) {
        this.normal = new Point3f(normal);
        normalizeNorm();
    }

    /**
     * @xNg_^ď.
     * 
     * @param normal
     *            @xNg
     * @param origin
     *            _
     */
    public Plane(Point3f normal, Point3f origin) {
        this.normal = new Point3f(normal);
        this.origin = new Point3f(origin);
        normalizeNorm();
    }

    /**
     * @xNgKi.
     */
    public void normalizeNorm() {
        double[] test = new double[] { (double) normal.x, (double) normal.y,
                (double) normal.z };
        double res = VectorOperations.norm(test);
        if (res == 0) {
            normal.x = 0;
            normal.y = 0;
            normal.z = 1;
            return;
        }
        normal.x = normal.x / ((float) res);
        normal.y = normal.y / ((float) res);
        normal.z = normal.z / ((float) res);
    }

    /**
     * ̖ʂƂ̊Ԃ̋Qbg. ɂ, ǂ瑤. Ȃ͂.
     */
    public float getDistanceFrom(Point3f from) {
        double[] foo = new double[] { (double) from.x, (double) from.y,
                (double) from.z };
        double[] normd = new double[] { (double) normal.x, (double) normal.y,
                (double) normal.z };
        double[] origd = new double[] { (double) origin.x, (double) origin.y,
                (double) origin.z };
        return (float) VectorOperations.getDistanceFromPlane(foo, normd, origd,
                true);
    }

    /**
     * ̖ʂ̖@xNgԂ.
     * 
     * @return ̖ʂ̖@xNg
     */
    public Point3f getNormalVector() {
        return this.normal;
    }

    /**
     * ̖ʂ̌_Ԃ.
     * 
     * @return ̖ʂ̌_
     */
    public Point3f getOrigin() {
        return this.origin;
    }

    /**
     * _Vɐݒ肵Ȃ
     * 
     * @param origin
     */
    public void setOrigin(Point3f origin) {
        this.origin = origin;
    }

    /**
     * @xNgVɐݒ肵Ȃ. Ki͏ɍs.
     * 
     * @param normal
     *            @xNg
     */
    public void setNormalVector(Point3f normal) {
        this.normal = normal;
        normalizeNorm();
    }

    /**
     * "origin"_牓傫
     * 
     * @param r
     * @return r_ꍇ+1, ߂ꍇ-1, ȏꍇ0Ԃ.
     */
    public int compareTo(Object o) {
        if (!(o instanceof Plane)) {
            return -1;
        }
        Plane pl = (Plane) o;
        Point3f orig = pl.getOrigin();
        float disto = orig.distance(new Point3f());
        float distthis = origin.distance(new Point3f());
        if (distthis - disto < 0) {
            return -1;
        } else if (disto == distthis) {
            return 0;
        } else {
            return 1;
        }
    }

    /**
     * @return _̋ȏꍇtrue
     */
    public boolean equals(Object obj) {
        if (obj == this)
            return true; // .

        if (!(obj instanceof Plane)) {
            return false;
        }
        Plane pl = (Plane) obj;
        Point3f orig = pl.getOrigin();
        float disto = orig.distance(new Point3f());
        float distthis = origin.distance(new Point3f());
        return disto == distthis;
    }

}
