/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser.projectcreator;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreeNode;
import jp.advancesoft.chase.projectbrowser.ProjectInfo;
import jp.advancesoft.chase.projectbrowser.ProjectManipulator;
import jp.advancesoft.chase.projectbrowser.projectcreator.NewProjectCreator;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeEvent;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChangeListener;
import jp.advancesoft.chase.projectbrowser.projectcreator.ProjectStateChanger;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SubProjectCreatorPanel
extends JPanel
implements ProjectStateChanger {
    private Logger logger = Logger.getLogger((String)SubProjectCreatorPanel.class.getName());
    private ProjectDirBrowserNode parentNode;
    private Vector components = new Vector();
    private JComboBox cbtype;
    private JTextField name;
    private ProjectDirBrowser dirBrowser;
    private Vector listeners = new Vector();

    public SubProjectCreatorPanel(ProjectDirBrowserNode parentNode, ProjectDirBrowser dirBrowser) {
        this.parentNode = parentNode;
        this.dirBrowser = dirBrowser;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setBorder(new TitledBorder("sub project info"));
        JPanel pcb = new JPanel();
        pcb.setLayout(new GridLayout(1, 1));
        pcb.setBorder(new TitledBorder("sub project type"));
        this.cbtype = new JComboBox(this.getTypeList());
        pcb.add(this.cbtype);
        p.add(pcb);
        JPanel pname = new JPanel();
        pname.setBorder(new TitledBorder("sub project name"));
        pname.setLayout(new GridLayout(1, 1));
        this.name = new JTextField(this.getDefaultName(), 10);
        pname.add(this.name);
        p.add(pname);
        this.components.addElement(this.cbtype);
        this.components.addElement(this.name);
        this.cbtype.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SubProjectCreatorPanel.this.name.setText(SubProjectCreatorPanel.this.getDefaultName());
            }
        });
        this.add(p);
        this.add(new JPanel());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.components.size(); ++i) {
            JComponent comp = (JComponent)this.components.elementAt(i);
            comp.setEnabled(enabled);
        }
    }

    public void manipulateProjectState() {
        this.createElement();
        this.notifyListeners();
    }

    public void setParentNode(ProjectDirBrowserNode parentNode) {
        this.parentNode = parentNode;
    }

    protected void createElement() {
        String sname = this.name.getText();
        String type = this.cbtype.getSelectedItem().toString();
        this.logger.debug((Object)("name and type of sub project...: " + sname + " " + type));
        Element elem = new Element("subproject");
        elem.setAttribute(new Attribute("display", "true"));
        Element elemname = new Element("name");
        elemname.setText(sname);
        elem.addContent((Content)elemname);
        Element elemdate = new Element("date");
        elemdate.setText(Calendar.getInstance().getTime().toString());
        elem.addContent((Content)elemdate);
        Element elemtype = new Element("type");
        elemtype.setText(type);
        elem.addContent((Content)elemtype);
        Element elemdir = new Element("directory");
        String dir = this.parentNode.getProjectInfo().getProjectDirectory() + System.getProperty("file.separator") + sname;
        elemdir.setText(dir);
        elem.addContent((Content)elemdir);
        File f = new File(dir);
        if (!f.exists() && !f.mkdirs()) {
            this.logger.error((Object)("failed to create " + dir));
            return;
        }
        ProjectDirBrowserNode nd = new ProjectDirBrowserNode(elem, this.dirBrowser);
        nd.addProjectDirBrowserNodeChangeListener(this.dirBrowser);
        this.dirBrowser.addObject(this.parentNode, nd, true);
        ProjectManipulator component = ProjectManipulator.createProjectManipulator(nd.getProjectInfo());
        if (component == null) {
            return;
        }
        component.initializeProject(nd);
    }

    protected void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ProjectStateChangeListener listener = (ProjectStateChangeListener)this.listeners.elementAt(i);
            listener.projectStateChanged(new ProjectStateChangeEvent(this, this.name.getText()));
        }
    }

    public void addProjectStateChangeListener(ProjectStateChangeListener listener) {
        this.listeners.addElement(listener);
    }

    private Vector getTypeList() {
        Element elem = this.getProjSpecElement();
        List list = elem.getChildren("project");
        Vector<String> retvec = new Vector<String>();
        for (int i = 0; i < list.size(); ++i) {
            Element pro = (Element)list.get(i);
            String type = pro.getChildTextTrim("type");
            if (!type.equals("sub")) continue;
            retvec.addElement(pro.getChildTextTrim("name"));
        }
        return retvec;
    }

    private Element getProjSpecElement() {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        URL projurl = null;
        projurl = SubProjectCreatorPanel.class.getResource(ProjectManipulator.PROJECT_MANIPULATOR_XML_PATH);
        try {
            doc = builder.build(projurl);
        }
        catch (JDOMException jde) {
            this.logger.error((Object)("failed to parse " + projurl));
            this.logger.error((Object)"unrecoverable error... contact AdvanceSoft.");
        }
        catch (IOException ioe) {
            this.logger.error((Object)("failed to parse " + projurl));
            this.logger.error((Object)"unrecoverable error... contact AdvanceSoft.");
        }
        Element elem = doc.getRootElement();
        if (!elem.getName().equals("root")) {
            this.logger.error((Object)"invalid ProjectSpecification file... contact AdvanceSoft.");
        }
        return elem;
    }

    private String getDefaultName() {
        Enumeration<TreeNode> enumeration = this.parentNode.children();
        String ret = this.cbtype.getSelectedItem().toString() + "-project";
        boolean proj = false;
        Vector<String> vec = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String name;
            ProjectDirBrowserNode node = (ProjectDirBrowserNode)enumeration.nextElement();
            ProjectInfo info = node.getProjectInfo();
            if (info.getInfoType() != 2 || !(name = info.getProjectName().toLowerCase()).startsWith(ret.toLowerCase())) continue;
            vec.addElement(name);
        }
        if (vec.size() == 0) {
            return ret;
        }
        return NewProjectCreator.getNonDupliString(ret, vec);
    }
}

