/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.DummyImage;
import jp.advancesoft.chase.mainpanel.InternalHeavyFrameChase;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

class InternalHeavyFrameAdapterChase
extends InternalFrameAdapter {
    private static Logger logger = Logger.getLogger((String)InternalHeavyFrameAdapterChase.class.getName());
    private Component[] buff;
    private InternalHeavyFrameChase fr;
    private Robot robot;
    private GlobalProperties props = PropertiesManager.getGlobalProperties(0);
    private boolean allow_light_overlay_heavy = true;

    protected InternalHeavyFrameAdapterChase() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException ex) {
            logger.error((Object)"failed to create Robot");
        }
        String str = this.props.getProperty("allow_light_overlay_heavy");
        if (str == null || str.equalsIgnoreCase("false")) {
            this.allow_light_overlay_heavy = false;
        }
    }

    protected Component[] getBuffer() {
        return this.buff;
    }

    public void internalFrameActivated(InternalFrameEvent ife) {
        this.fr = (InternalHeavyFrameChase)ife.getSource();
        this.fr.aboutTobeActivated();
        Container cont = this.fr.getContentPane();
        this.activate(this.fr);
        this.fr.selected();
        this.fr.activated();
    }

    protected void activate(JInternalFrame fr) {
        if (!this.allow_light_overlay_heavy) {
            return;
        }
        Container lcont = fr.getContentPane();
        if (this.buff == null) {
            return;
        }
        for (int i = 0; i < this.buff.length; ++i) {
            if (!(this.buff[i] instanceof Panel)) continue;
            this.buff[i].setVisible(true);
        }
        fr.setGlassPane(new JPanel());
        fr.setLayer(0);
    }

    public void internalFrameDeactivated(InternalFrameEvent ife) {
        this.fr = (InternalHeavyFrameChase)ife.getSource();
        this.fr.aboutTobeDeactivated();
        this.fr.stopAllAnimations();
        Container cont = this.fr.getContentPane();
        this.deactivate(this.fr);
        this.fr.deactivated();
        logger.debug((Object)"successfully deactivated...");
    }

    protected void deactivate(JInternalFrame fr) {
        if (!this.allow_light_overlay_heavy) {
            return;
        }
        Container cont = fr.getContentPane();
        int locx = 0;
        int locy = 0;
        boolean hasLocation = true;
        try {
            locx = fr.getRootPane().getLocationOnScreen().x;
            locy = fr.getRootPane().getLocationOnScreen().y;
        }
        catch (Exception exc) {
            hasLocation = false;
        }
        logger.debug((Object)("pos: " + locx + " " + locy));
        int width = fr.getSize().width;
        int height = fr.getSize().height;
        Rectangle bounds = new Rectangle(locx, locy, width, height);
        BufferedImage image = null;
        int maxCount = 10;
        int count = 0;
        do {
            if (this.robot == null) {
                logger.error((Object)"failed to capture screen...");
                return;
            }
            image = this.robot.createScreenCapture(bounds);
            if (image == null) continue;
            DummyImage dummy = new DummyImage(image);
            fr.setGlassPane(dummy);
            break;
        } while (++count < maxCount);
        this.buff = cont.getComponents();
        if (this.buff != null && this.buff.length > 0) {
            for (int i = 0; i < this.buff.length; ++i) {
                if (!(this.buff[i] instanceof Panel)) continue;
                this.buff[i].setVisible(false);
            }
        }
        fr.setLayer(0);
    }

    public void internalFrameClosed(InternalFrameEvent ife) {
        ((Desktop)Desktop.getDesktop()).scrollBarUpdate();
    }
}

