/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.install;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.install.Installer;
import jp.advancesoft.chase.settings.PropertyPanel;

class InstallerPanel
extends JFrame {
    private final int FILE = 0;
    private final int DIRECTORY = 1;
    private int[] x = new int[]{380, 380, 0};
    private int[] y = new int[]{280, 330, 0};
    private int count = 0;
    private String FS = System.getProperty("file.separator");
    private String osName = System.getProperty("os.name");
    private String javapath = System.getProperty("java.home") + this.FS + "bin" + this.FS + "java";
    private String chaseiniini = System.getProperty("user.dir") + this.FS + "install_files" + this.FS;
    private Installer installer;
    private Container container;
    private MyMessageBox mbox = new MyMessageBox();
    private PropertyPanel propertyPanel;
    private Properties prop = new Properties();
    private JTextField tfeditor = new JTextField(20);
    private JTextField tfgs = new JTextField(20);
    private JTextField tfemacs = new JTextField(20);
    private JTextField tfmpi = new JTextField(20);
    private JTextField tfbrowser = new JTextField(20);
    private JTextField tfBSV = new JTextField(20);
    private JButton btneditor = new JButton("choose...");
    private JButton btngs = new JButton("choose...");
    private JButton btnemacs = new JButton("choose...");
    private JButton btnmpi = new JButton("choose...");
    private JButton btnbrowser = new JButton("choose...");
    private JButton btnBSV = new JButton("chooser...");
    private boolean mpiEnable = true;
    private JButton btnrc = new JButton("choose...");
    private JButton btnjava = new JButton("choose...");
    private JButton btnjavaopt = new JButton("choose...");
    private JTextField tfrc = new JTextField(20);
    private JTextField tfjava = new JTextField(20);
    private JTextField tfjavaopt = new JTextField(20);
    private JButton btnprev = new JButton("previous");
    private JButton btnnext = new JButton("next");
    private JButton btncancel = new JButton("cancel");
    private boolean guiEnabled = false;
    private String chaseDir = new File(System.getProperty("user.dir")).getParent();
    private String editor = new String();
    private String gs = new String();
    private String browser = new String();
    private String mpirunpath = new String();
    private String BSV = new String();
    private String chasedir = this.chaseDir;

    protected InstallerPanel() {
        super("Welcome to chase-3pt installer application");
        this.createInstallerGUI();
    }

    protected InstallerPanel(Installer installer) {
        super("Welcome to chase-3pt installer application");
        this.installer = installer;
        System.out.println("system: " + this.osName);
        if (this.osName.toLowerCase().trim().startsWith("windows")) {
            this.javapath = this.javapath + ".exe";
        }
        this.createInstallerGUI();
    }

    protected InstallerPanel(Installer installer, boolean guiEnabled) {
        super("Welcome to chase-3pt installer application");
        this.installer = installer;
        this.guiEnabled = guiEnabled;
        System.out.println("system: " + this.osName);
        if (this.osName.toLowerCase().trim().startsWith("windows")) {
            this.javapath = this.javapath + ".exe";
        }
        this.createInstallerGUI();
    }

    private void createInstallerGUI() {
        this.propertyPanel = new PropertyPanel();
        this.container = this.getContentPane();
        this.container.setLayout(new FlowLayout());
        this.container.add(this.createInstallOptionsPanel());
        this.container.add(this.createButtonPanel());
        this.osName = this.osName.toLowerCase().trim();
        this.chaseiniini = this.osName.startsWith("windows") ? this.chaseiniini + "chase_win32.ini" : (this.osName.startsWith("mac") ? this.chaseiniini + "chase_OSX.ini" : (this.osName.startsWith("linux") ? this.chaseiniini + "chase_linux.ini" : this.chaseiniini + "chase_generic.ini"));
        try {
            System.out.println("load property file: " + this.chaseiniini);
            this.prop.load(new FileInputStream(this.chaseiniini));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.mbox.setText("couldn't find chase.ini", !this.guiEnabled);
            this.mbox.setText("installation failed", !this.guiEnabled);
            System.exit(0);
        }
        if (this.guiEnabled) {
            this.addActionListeners();
            this.setSize(this.x[0], this.y[0]);
            this.setInitialText();
            this.setVisible(true);
            this.setDefaultCloseOperation(3);
        } else {
            this.setInitialText();
            this.count = 2;
            this.redraw();
        }
    }

    private void setInitialText() {
        this.editor = this.prop.getProperty("editor");
        if (this.editor != null) {
            this.tfeditor.setText(this.editor);
        }
        this.gs = this.prop.getProperty("gs");
        if (this.gs != null) {
            this.tfgs.setText(this.gs);
        }
        this.mpirunpath = this.prop.getProperty("mpirunpath");
        if (this.mpirunpath != null) {
            this.tfmpi.setText(this.mpirunpath);
        }
        this.browser = this.prop.getProperty("browser");
        if (this.browser != null) {
            this.tfbrowser.setText(this.browser);
        }
        this.BSV = this.prop.getProperty("BioStationViewer");
        if (this.BSV != null) {
            this.tfBSV.setText(this.BSV);
        }
        this.tfrc.setText(this.chaseDir + this.FS + "bin");
        this.tfjava.setText(this.javapath);
        this.mpiEnable = Boolean.valueOf(this.prop.getProperty("mpienable").trim());
    }

    private JPanel createInstallOptionsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("install options"));
        p.add(this.propertyPanel.createTF(this.tfrc, this.btnrc, "rc path"));
        p.add(this.propertyPanel.createTF(this.tfjava, this.btnjava, "java path"));
        this.tfjavaopt.setPreferredSize(new Dimension(100, 27));
        p.add(this.propertyPanel.createTFonly(this.tfjavaopt, "java options (e.g. -Xmx256m)"));
        return p;
    }

    private JPanel createPanelExternal() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("external program path (you may set these later)"));
        p.add(this.propertyPanel.createTF(this.tfeditor, this.btneditor, "editor"));
        p.add(this.propertyPanel.createTF(this.tfgs, this.btngs, "gs"));
        p.add(this.propertyPanel.createTF(this.tfmpi, this.btnmpi, "mpirun"));
        if (!this.mpiEnable) {
            this.tfmpi.setEnabled(false);
            this.btnmpi.setEnabled(false);
        }
        p.add(this.propertyPanel.createTF(this.tfbrowser, this.btnbrowser, "browser"));
        return p;
    }

    private void addActionListeners() {
        this.btnnext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.count++;
                InstallerPanel.this.redraw();
            }
        });
        this.btnprev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.count--;
                InstallerPanel.this.redraw();
            }
        });
        this.btncancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.setVisible(false);
                InstallerPanel.this.mbox.setText("installation canceled", !InstallerPanel.this.guiEnabled);
                System.exit(0);
            }
        });
        this.btnrc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfrc, 1);
            }
        });
        this.btnjava.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfjava, 0);
            }
        });
        this.btneditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfeditor, 0);
            }
        });
        this.btngs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfgs, 0);
            }
        });
        this.btnmpi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfmpi, 0);
            }
        });
        this.btnbrowser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfbrowser, 0);
            }
        });
        this.btnBSV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InstallerPanel.this.bootFileChooser(InstallerPanel.this.tfBSV, 0);
            }
        });
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        if (this.count == 0) {
            this.btnprev.setEnabled(false);
        } else {
            this.btnprev.setEnabled(true);
        }
        if (this.count == 1) {
            this.btnnext.setText("Install");
        } else {
            this.btnnext.setText("next");
        }
        p.add(this.btnprev);
        p.add(this.btnnext);
        p.add(this.btncancel);
        return p;
    }

    private void redraw() {
        this.container.removeAll();
        this.setVisible(false);
        this.setSize(this.x[this.count], this.y[this.count]);
        if (this.count == 0) {
            this.container.add(this.createInstallOptionsPanel());
            this.container.add(this.createButtonPanel());
            this.setVisible(true);
        } else if (this.count == 1) {
            this.container.add(this.createPanelExternal());
            this.container.add(this.createButtonPanel());
            this.setVisible(true);
        } else if (this.count == 2) {
            this.installer.setRC(this.tfrc.getText().trim());
            this.installer.setJava(this.tfjava.getText().trim());
            this.installer.setJavaOpts(this.tfjavaopt.getText().trim());
            this.createProp();
            this.installer.setProperties(this.prop);
            this.installer.startInstall();
        }
        if (this.count <= 0) {
            this.btnprev.setEnabled(false);
            this.count = 0;
        } else if (this.count >= 1) {
            this.btnprev.setEnabled(true);
        }
    }

    private void createProp() {
        if (this.guiEnabled) {
            this.prop.setProperty("editor", this.tfeditor.getText().trim());
            this.prop.setProperty("gs", this.tfgs.getText().trim());
            this.prop.setProperty("java", this.tfjava.getText().trim());
            this.prop.setProperty("browser", this.tfbrowser.getText().trim());
            this.prop.setProperty("mpirunpath", this.tfmpi.getText().trim());
            this.prop.setProperty("BioStationViewer", this.tfBSV.getText().trim());
            this.prop.setProperty("chasedir", this.chaseDir);
        } else {
            this.prop.setProperty("editor", this.editor);
            this.prop.setProperty("gs", this.gs);
            this.prop.setProperty("java", this.javapath);
            this.prop.setProperty("browser", this.browser);
            this.prop.setProperty("mpirunpath", this.mpirunpath);
            this.prop.setProperty("BioStationViewer", this.BSV);
            this.prop.setProperty("chasedir", this.chaseDir);
        }
        if (this.osName.toLowerCase().trim().startsWith("windows")) {
            this.prop.setProperty("taskmgr", "TASKMGR.EXE");
        }
    }

    private void bootFileChooser(JTextField tf, int mode) {
        JFileChooser fdlg = new JFileChooser();
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("choose");
        fdlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (mode == 0) {
            fdlg.setFileSelectionMode(0);
        } else if (mode == 1) {
            fdlg.setFileSelectionMode(1);
        } else {
            System.out.println("wrong specification of mode");
            return;
        }
        if (fdlg.showDialog(this.container, "Select") != 0) {
            return;
        }
        tf.setText(fdlg.getSelectedFile().getAbsolutePath());
    }

    public static void main(String[] args) {
        InstallerPanel panel = new InstallerPanel();
    }
}

