/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.filebrowser;

import com.jcraft.jsch.ChannelSftp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import jp.advancesoft.chase.filebrowser.FileBrowserTree;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import org.apache.log4j.Logger;

class ComboBoxFileBrowser
extends JComboBox {
    private static Logger logger = Logger.getLogger((String)ComboBoxFileBrowser.class.getName());
    private RemoteFile root;
    private FileBrowserTree tree;
    private ChannelSftp c;

    protected ComboBoxFileBrowser(FileBrowserTree tree, ChannelSftp c) {
        this.tree = tree;
        this.c = c;
        this.createCombo();
    }

    private void addListener() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComboBoxFileBrowser.this.tree.setNewRoot(new RemoteFile((String)ComboBoxFileBrowser.this.getSelectedItem(), ComboBoxFileBrowser.this.c));
                ComboBoxFileBrowser.this.createCombo();
            }
        });
    }

    private void createCombo() {
        this.removeAllItems();
        this.root = this.tree.getCurrentRoot();
        if (this.root != null) {
            RemoteFile[] parents = this.getParents(this.root);
            String[] itemStrings = null;
            if (parents != null && parents.length != 0) {
                int i;
                itemStrings = new String[parents.length];
                for (i = 0; i < parents.length; ++i) {
                    logger.debug((Object)("parent no. " + i + " is " + parents[i]));
                    itemStrings[i] = parents[i].getAbsolutePath();
                }
                for (i = parents.length - 1; i >= 0; --i) {
                    logger.debug((Object)("adding item no. " + i + ", elem " + itemStrings[i]));
                    this.addItem(itemStrings[i]);
                }
            }
            this.setSelectedIndex(this.getItemCount() - 1);
            this.addListener();
            this.setVisible(false);
            this.setVisible(true);
            this.revalidate();
        }
    }

    private RemoteFile[] getParents(RemoteFile base) {
        String dirnow = new String(base.getAbsolutePath());
        RemoteFile parent = base;
        Vector<RemoteFile> fileVector = new Vector<RemoteFile>();
        int parentCount = 0;
        fileVector.addElement(parent);
        while (true) {
            parent = (RemoteFile)parent.getParentFile();
            if (++parentCount >= 100 || parent == null) break;
            logger.debug((Object)("parentdir: " + parent));
            fileVector.addElement(parent);
        }
        logger.debug((Object)("num. parents: " + parentCount));
        RemoteFile[] retFile = new RemoteFile[fileVector.size()];
        for (int i = 0; i < fileVector.size(); ++i) {
            retFile[i] = (RemoteFile)fileVector.get(i);
        }
        return retFile;
    }
}

