/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import jp.advancesoft.chase.common.MyMessageBox;

public class ExcelAdapter
implements ActionListener {
    private String rowstring;
    private String value;
    private Clipboard system;
    private StringSelection stsel;
    private JTable jTable1;
    private MyMessageBox mbox = new MyMessageBox();

    public ExcelAdapter(JTable myJTable) {
        this.jTable1 = myJTable;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        this.jTable1.registerKeyboardAction(this, "Copy", copy, 0);
        this.jTable1.registerKeyboardAction(this, "Paste", paste, 0);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public JTable getJTable() {
        return this.jTable1;
    }

    public void setJTable(JTable jTable1) {
        this.jTable1 = jTable1;
    }

    public void actionPerformed(ActionEvent e) {
        int j;
        if (e.getActionCommand().compareTo("Copy") == 0) {
            StringBuffer sbf = new StringBuffer();
            int numcols = this.jTable1.getSelectedColumnCount();
            int numrows = this.jTable1.getSelectedRowCount();
            int[] rowsselected = this.jTable1.getSelectedRows();
            int[] colsselected = this.jTable1.getSelectedColumns();
            if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
                JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
                return;
            }
            for (int i = 0; i < numrows; ++i) {
                for (j = 0; j < numcols; ++j) {
                    sbf.append(this.jTable1.getValueAt(rowsselected[i], colsselected[j]));
                    if (j >= numcols - 1) continue;
                    sbf.append("\t");
                }
                sbf.append("\n");
            }
            this.stsel = new StringSelection(sbf.toString());
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.system.setContents(this.stsel, this.stsel);
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            System.out.println("Trying to Paste");
            int startRow = this.jTable1.getSelectedRows()[0];
            int startCol = this.jTable1.getSelectedColumns()[0];
            try {
                String trstring = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                System.out.println("String is:" + trstring);
                StringTokenizer st1 = new StringTokenizer(trstring, System.getProperty("line.separator"));
                int i = 0;
                while (st1.hasMoreTokens()) {
                    this.rowstring = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(this.rowstring, "\t");
                    if (st2.countTokens() <= 1) {
                        st2 = new StringTokenizer(this.rowstring, " ");
                    }
                    if (st2.countTokens() <= 1) {
                        st2 = new StringTokenizer(this.rowstring, ",");
                    }
                    j = 0;
                    while (st2.hasMoreTokens()) {
                        this.value = st2.nextToken();
                        if (startRow + i < this.jTable1.getRowCount() && startCol + j < this.jTable1.getColumnCount()) {
                            this.jTable1.setValueAt(this.value.trim(), startRow + i, startCol + j);
                        }
                        System.out.println("Putting " + this.value + "atrow=" + startRow + i + "column=" + startCol + j);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                this.mbox.setText("failed paste");
                ex.printStackTrace();
            }
        }
    }
}

