/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.Cell;
import jp.advancesoft.chase.atomcoord.ImporterBase;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.pmodel.Pmodel;
import jp.advancesoft.pmodel.PmodelException;
import org.apache.log4j.Logger;

class CIFImporter
extends ImporterBase {
    private static Logger logger = Logger.getLogger((String)CIFImporter.class.getName());
    private DecimalFormat formater = ConstParameters.formater;

    protected CIFImporter(File file, AtomCoords coords) {
        super(file, coords);
        this.list.clear();
    }

    public boolean importAtomCoords() {
        String gamma;
        String beta;
        String alpha;
        String c;
        String b;
        String a;
        boolean bret = true;
        this.list.clear();
        try {
            FileReader reader = new FileReader(this.file);
            BufferedReader br = new BufferedReader(reader);
        }
        catch (Exception e) {
            logger.warn((Object)("file " + this.file + " could not be opened"));
            return false;
        }
        String str = new String();
        String fileName = this.file.getAbsolutePath();
        logger.info((Object)("parsing cif file... " + fileName));
        Pmodel pmodel = new Pmodel();
        try {
            pmodel.makeLattice(fileName);
        }
        catch (PmodelException exception) {
            logger.warn((Object)"unsupported symmetry type");
            return false;
        }
        int NumAt = pmodel.getNumberOfAtoms();
        double[][] DAtom = pmodel.getInternalPosition();
        String[] Symbols = pmodel.getSymbol();
        DAtom = this.coords.isCart() ? pmodel.getCartesianPosition() : pmodel.getInternalPosition();
        for (int i = 0; i < NumAt; ++i) {
            String[] Atoms = new String[3];
            String element = Symbols[i];
            logger.debug((Object)("atom :" + i + " name: " + element));
            for (int j = 0; j < 3; ++j) {
                try {
                    Atoms[j] = this.formater.format(DAtom[i][j]);
                    continue;
                }
                catch (NumberFormatException ne) {
                    ne.printStackTrace();
                    logger.warn((Object)("failed to cast pos data for atom " + i + "; may not be a number"));
                    return false;
                }
            }
            Atom at = new Atom(element, Atoms);
            this.list.addAtom(at);
        }
        logger.debug((Object)this.list);
        double[] cellAngle = pmodel.getCellAngle();
        double[] cellLength = pmodel.getCellLength();
        double[][] cellVec = pmodel.getCellVec();
        try {
            a = this.formater.format(cellLength[0]);
            b = this.formater.format(cellLength[1]);
            c = this.formater.format(cellLength[2]);
            alpha = this.formater.format(cellAngle[0]);
            beta = this.formater.format(cellAngle[1]);
            gamma = this.formater.format(cellAngle[2]);
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)"failed to cast celldata: may not be a number");
            return false;
        }
        Cell cell = new Cell(a, b, c, alpha, beta, gamma);
        this.coords.setCell(cell);
        String[] av = new String[3];
        String[] bv = new String[3];
        String[] cv = new String[3];
        for (int i = 0; i < 3; ++i) {
            try {
                av[i] = this.formater.format(cellVec[0][i]);
                bv[i] = this.formater.format(cellVec[1][i]);
                cv[i] = this.formater.format(cellVec[2][i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)"failed to cast celldata: may not be a number");
                return false;
            }
        }
        Cell cellv = new Cell(av, bv, cv);
        this.coords.setCell(cellv);
        return bret;
    }

    public boolean importCell() {
        boolean ret = true;
        return true;
    }
}

