/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer;

import java.util.Vector;
import jp.advancesoft.chase.acviewer.ConfigData;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.common.ElementInfo;
import jp.advancesoft.chase.common.TaggedString;
import org.apache.log4j.Logger;

public class ConfigDataManager {
    private Logger logger = Logger.getLogger((String)ConfigDataManager.class.getName());
    private String[][] XYZ;
    private String[][] originalXYZ;
    private int NumAt;
    private double lenmax;
    private double[] com;
    private boolean cellorigin;
    private double[] cellorigin_vec;
    private boolean validcell = true;
    private AtomCoords coords;
    private AtomCoords coords_buff;
    private double[][] cell;
    private String[] elements;
    private TaggedString[][] auxils;
    private double[][] Dpos;
    private int[] mobile;
    private int[] weight;
    private Vector holdsConfigList = new Vector();

    public ConfigDataManager(AtomCoords coords) {
        this.coords = coords;
        this.coords_buff = coords.getCopy();
        this.init();
    }

    public void setCoords(AtomCoords coords) {
        this.coords = coords;
        this.init();
        this.update();
    }

    public void setCoords(AtomCoords coords, boolean rescale) {
        this.coords = coords;
        this.init();
        this.update(rescale);
    }

    public void setCoordsNoUpdate(AtomCoords coords) {
        this.coords = coords;
        this.init();
    }

    private void init() {
        this.validcell = this.coords.isCellValid(0);
        this.NumAt = this.coords.getNumAt();
        if (this.validcell) {
            this.cell = this.coords.getCellDouble(0);
        }
        this.Dpos = this.coords.getPosDouble();
        this.elements = this.coords.getElements();
        this.auxils = this.coords.getAuxils();
        this.cellorigin = this.coords.isInternal();
    }

    public void register(ConfigData data) {
        this.holdsConfigList.addElement(data);
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean rescaleOnUpdate) {
        int n = this.holdsConfigList.size();
        for (int i = 0; i < n; ++i) {
            ConfigData data = (ConfigData)this.holdsConfigList.get(i);
            if (!data.needsUpdate()) continue;
            data.configDataUpdate(rescaleOnUpdate);
        }
    }

    public AtomCoords getAtomCoords() {
        return this.coords;
    }

    public double[][] getOriginalCellVec() {
        double[][] cell_buff = null;
        if (this.validcell) {
            cell_buff = this.coords_buff.getCellDouble(0);
        }
        return cell_buff;
    }

    public double[][] getPos() {
        return this.Dpos;
    }

    public double[] getPos(int key) {
        return this.Dpos[key];
    }

    public double[][] getForce() {
        return this.coords.getForceDouble();
    }

    public double[] getForce(int key) {
        return this.coords.getForceDouble()[key];
    }

    public double[][] getOriginalPos() {
        return this.coords_buff.getPosDouble();
    }

    public String[] getOriginalElements() {
        String[] elements_buff = this.coords_buff.getElements();
        return elements_buff;
    }

    public TaggedString[][] getOriginalAuxils() {
        TaggedString[][] auxils_buff = this.coords_buff.getAuxils();
        return auxils_buff;
    }

    public void setPos(double[][] Dpos) {
        this.Dpos = Dpos;
    }

    public void setPos(double[] Dpos, int key) {
        this.Dpos[key] = Dpos;
    }

    public double[][] getCell() {
        return this.cell;
    }

    public void setCell(double[][] cell) {
        this.cell = cell;
    }

    public String[] getElements() {
        return this.elements;
    }

    public int getAtomicNumber(int key) {
        String elemtmp = this.elements[key];
        ElementInfo ei = new ElementInfo();
        return ei.getNumberFromSymbol(elemtmp) - 1;
    }

    public void setElements(String elements, int key) {
        this.elements[key] = elements;
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void setAuxils(TaggedString[][] auxils) {
        this.auxils = auxils;
    }

    public void setAuxils(TaggedString[] auxils, int key) {
        this.auxils[key] = auxils;
    }

    public TaggedString[][] getAuxils() {
        return this.auxils;
    }

    public TaggedString[] getAuxils(int key) {
        return this.auxils[key];
    }

    public void setLenMax(double lenmax) {
        this.lenmax = lenmax;
    }

    public double getLenMax() {
        return this.lenmax;
    }

    public double[] getCOM() {
        return this.com;
    }

    public void setCOM(double[] com) {
        this.com = com;
    }

    public void setNumAt(int NumAt) {
        this.NumAt = NumAt;
    }

    public int getNumAt() {
        return this.NumAt;
    }

    public boolean getCellOrigin() {
        return this.cellorigin;
    }

    public void setCellOriginVector(double cellx, double celly, double cellz) {
        this.cellorigin_vec = new double[3];
        this.cellorigin_vec[0] = cellx;
        this.cellorigin_vec[1] = celly;
        this.cellorigin_vec[2] = cellz;
    }

    public double[] getCellOriginVector() {
        return this.cellorigin_vec;
    }

    private void setValidCell(boolean validcell) {
        this.validcell = validcell;
    }

    public boolean getValidCell() {
        return this.coords.isCellValid(0);
    }

    public double[] getPosfromVirtualWorld(double x, double y, double z) {
        double lenmax = this.getLenMax();
        double[] jusin = this.getCOM();
        double[] dnewpos = new double[]{x * lenmax + jusin[0], y * lenmax + jusin[1], z * lenmax + jusin[2]};
        return dnewpos;
    }
}

