/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Common.BaseWindow;
import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.EnergyGraphPanel;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.TrajectoryTextAssignWindow;
import AbinitMp.Viewer.VideoControlPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class TrajectoryControlWindow
extends BaseWindow {
    public AbinitMpViewer viewer;
    private EnergyGraphPanel graphPanel;
    private VideoControlPanel videoControlPanel;
    private TrajectoryTextAssignWindow trajectoryTextAssignWindow;
    private FileItem fileItem;
    public TrajectoryFile trajectoryFile;
    private JFileChooser saveDirChooser;
    private JFileChooser saveImageChooser;

    public TrajectoryControlWindow(AbinitMpViewer abinitMpViewer, FileItem fileItem) {
        super(MyResourceBundle.getResourceString("TrajectoryControlWindow.Title"));
        Serializable serializable;
        this.viewer = abinitMpViewer;
        this.fileItem = fileItem;
        this.trajectoryFile = (TrajectoryFile)fileItem.file;
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("TrajectoryControlWindow.fileMenuTitle", "TrajectoryControlWindow.fileMenu", (Action)new fileListener()));
        this.getJMenuBar().add(this.addCheckBoxMenuItem("TrajectoryControlWindow.modeMenuTitle", "TrajectoryControlWindow.modeMenu", new modeListener()));
        this.getJMenuBar().add(this.addMenuItem("TrajectoryControlWindow.textMenuTitle", "TrajectoryControlWindow.textMenu", (Action)new textListener()));
        this.getJMenuBar().add(this.addCheckBoxMenuItem("TrajectoryControlWindow.widthMenuTitle", "TrajectoryControlWindow.widthMenu", new widthListener()));
        this.mainPanel.setLayout(new BorderLayout());
        if (this.trajectoryFile.type == 0 || this.trajectoryFile.type == 1) {
            this.graphPanel = new EnergyGraphPanel(this.trajectoryFile);
            serializable = new JScrollPane(this.graphPanel, 20, 30);
            this.graphPanel.setScrollBar(serializable.getHorizontalScrollBar());
            this.mainPanel.add((Component)serializable, "Center");
        }
        this.videoControlPanel = new VideoControlPanel(this);
        this.mainPanel.add((Component)this.videoControlPanel, "South");
        this.trajectoryFile.getInterpolator().setVideoControlPanel(this.videoControlPanel);
        this.pack();
        this.trajectoryTextAssignWindow = new TrajectoryTextAssignWindow(abinitMpViewer);
        serializable = this.getSize();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > 2000) {
            dimension.width /= 2;
        }
        if (this.trajectoryFile.type == 0 || this.trajectoryFile.type == 1) {
            int n = this.trajectoryFile.labelIndex == -1 ? this.trajectoryFile.dataNum * 300 + 230 : (this.trajectoryFile.dataNum - 1) * 300 + 230;
            if (dimension.height < n) {
                n = dimension.height;
            }
            this.setBounds(dimension.width - 300, 0, 300, n);
        } else {
            this.setBounds(dimension.width - 300, 0, 300, 195);
        }
    }

    public VideoControlPanel getVideoControlPanel() {
        return this.videoControlPanel;
    }

    public void drawCurrentStepGraph(int n) {
        if (this.graphPanel != null) {
            this.graphPanel.setCurrentStep(n);
        }
    }

    public TrajectoryTextAssignWindow getTrajectoryTextAssignWindow() {
        return this.trajectoryTextAssignWindow;
    }

    public static void main(String[] stringArray) {
        TrajectoryControlWindow trajectoryControlWindow = new TrajectoryControlWindow(null, null);
        trajectoryControlWindow.setVisible(true);
        trajectoryControlWindow.setDefaultCloseOperation(3);
    }

    class widthListener
    extends AbstractAction {
        widthListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.isSelected()) {
                TrajectoryControlWindow.this.graphPanel.setWidthMode(1);
            } else {
                TrajectoryControlWindow.this.graphPanel.setWidthMode(0);
            }
        }
    }

    class textListener
    extends AbstractAction {
        textListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("TrajectoryControlWindow.textMenu");
            char c = string.charAt(0);
            if (TrajectoryControlWindow.this.getNemonic(stringArray[0]) == c) {
                TrajectoryControlWindow.this.trajectoryTextAssignWindow.setVisible(true);
            }
        }
    }

    class modeListener
    extends AbstractAction {
        modeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.isSelected()) {
                TrajectoryControlWindow.this.videoControlPanel.setLoopCount(-1);
            } else {
                TrajectoryControlWindow.this.videoControlPanel.setLoopCount(1);
            }
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("TrajectoryControlWindow.fileMenu");
            char c = string.charAt(0);
            if (TrajectoryControlWindow.this.getNemonic(stringArray[0]) == c) {
                if (TrajectoryControlWindow.this.saveDirChooser == null) {
                    TrajectoryControlWindow.this.saveDirChooser = new JFileChooser(".");
                    TrajectoryControlWindow.this.saveDirChooser.setPreferredSize(new Dimension(500, 300));
                    TrajectoryControlWindow.this.saveDirChooser.setFileSelectionMode(1);
                }
                if (TrajectoryControlWindow.this.saveDirChooser.showSaveDialog(TrajectoryControlWindow.this.videoControlPanel) == 0) {
                    File file = TrajectoryControlWindow.this.saveDirChooser.getSelectedFile();
                    TrajectoryControlWindow.this.videoControlPanel.createAnimationFile(file);
                }
            } else if (TrajectoryControlWindow.this.getNemonic(stringArray[1]) == c) {
                Object object;
                Object object2;
                if (TrajectoryControlWindow.this.saveImageChooser == null) {
                    TrajectoryControlWindow.this.saveImageChooser = new JFileChooser(".");
                    TrajectoryControlWindow.this.saveImageChooser.setPreferredSize(new Dimension(500, 500));
                    object2 = new ExampleFileFilter(new String[]{"jpg", "png"}, "Image file");
                    object = new ExampleFileFilter(new String[]{"eps", "ps"}, "Postscript file");
                    FileFilter fileFilter = TrajectoryControlWindow.this.saveImageChooser.getFileFilter();
                    TrajectoryControlWindow.this.saveImageChooser.addChoosableFileFilter((FileFilter)object2);
                    TrajectoryControlWindow.this.saveImageChooser.addChoosableFileFilter((FileFilter)object);
                    TrajectoryControlWindow.this.saveImageChooser.setFileFilter(fileFilter);
                }
                if (TrajectoryControlWindow.this.saveImageChooser.showSaveDialog(TrajectoryControlWindow.this.graphPanel) == 0) {
                    object2 = TrajectoryControlWindow.this.saveImageChooser.getSelectedFile();
                    object = ((File)object2).getPath();
                    int n = ((String)object).lastIndexOf(".");
                    String string2 = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
                    if (n == -1) {
                        string2 = "jpg";
                        object = ((String)object).concat("." + string2);
                        object2 = new File((String)object);
                    }
                    if (string2.equals("eps") || string2.equals("ps")) {
                        TrajectoryControlWindow.this.graphPanel.outputPsFile((String)object);
                    } else if (string2.equals("jpg") || string2.equals("jpeg") || string2.equals("png")) {
                        try {
                            ImageIO.write((RenderedImage)TrajectoryControlWindow.this.graphPanel.createImage(), string2, (File)object2);
                        }
                        catch (Exception exception) {
                            System.out.println("output imagefile failed!!");
                        }
                    }
                }
            } else if (TrajectoryControlWindow.this.getNemonic(stringArray[2]) == c) {
                TrajectoryControlWindow.this.setVisible(false);
            }
        }
    }
}

