/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Display.IsosurfaceValue;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButton;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Tool.MySlider;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.SectionAssignWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;

public class IsosurfaceValuePanel
extends GridBagLayoutPanel {
    private AbinitMpViewer viewer;
    public IsosurfaceValue value;
    public FileItem fileItem;
    private JTextField valueText;
    private JTextField minText;
    private JTextField maxText;
    private MyButton colorButton;
    private MySlider transSlider;
    private IsosurfaceValuePanel me;
    private MyComboBox minMaxComboBox;
    private MyRadioButton userColorRadioButton;
    private MyRadioButton valueColorRadioButton;
    private String[] minMaxLabel = new String[]{"Min Max(bule,red)", "Min Max(red,blue)"};
    private MyRadioButton bboxOnRadioButton;
    private MyRadioButton bboxOffRadioButton;
    private MyButton bboxColorButton;
    private JTextField minValueText;
    private JTextField maxValueText;
    private MyButton colorPlusButton;
    private MyButton colorMinusButton;
    private SectionAssignWindow sectionAssignWindow;

    public IsosurfaceValuePanel(AbinitMpViewer abinitMpViewer, FileItem fileItem) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        int n = 0;
        this.me = this;
        this.viewer = abinitMpViewer;
        this.value = fileItem.isosurfaceValue;
        this.fileItem = fileItem;
        this.setBorder(new TitledBorder(""));
        this.valueText = new JTextField();
        this.valueText.setPreferredSize(new Dimension(50, 28));
        this.valueText.setText(Float.toString(this.value.value));
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("IsosurfaceValuePanel.value")), 0, 0, 5, 1, 1.0, 0.0);
        this.layoutObject(this.valueText, 5, 0, 10, 1, 1.0, 0.0);
        FlowLayout flowLayout = new FlowLayout(0);
        if (fileItem.type == 1 || fileItem.type == 2 || fileItem.type == 9) {
            this.minMaxComboBox = new MyComboBox(this.minMaxLabel);
            this.layoutObject(this.minMaxComboBox, 0, 1, 5, 1, 1.0, 0.0);
            object = new MyPanel();
            this.minText = new JTextField();
            this.minText.setPreferredSize(new Dimension(100, 28));
            this.minText.setText(Float.toString(this.value.minValue));
            this.maxText = new JTextField();
            this.maxText.setPreferredSize(new Dimension(100, 28));
            this.maxText.setText(Float.toString(this.value.maxValue));
            ((Container)object).add(this.minText);
            ((Container)object).add(this.maxText);
            this.layoutObject(object, 5, 1, 10, 1, 1.0, 0.0);
            n = 2;
        } else if (fileItem.type == 14) {
            object = new colorListener();
            serializable2 = new MyPanel(flowLayout);
            this.colorMinusButton = new MyButton();
            this.colorMinusButton.setPreferredSize(new Dimension(50, 25));
            this.colorMinusButton.setBackground(this.value.colorMinus.get());
            this.colorMinusButton.addActionListener((ActionListener)object);
            this.colorPlusButton = new MyButton();
            this.colorPlusButton.setPreferredSize(new Dimension(50, 25));
            this.colorPlusButton.setBackground(this.value.colorPlus.get());
            this.colorPlusButton.addActionListener((ActionListener)object);
            ((Container)serializable2).add(new MyLabel("-"));
            ((Container)serializable2).add(this.colorMinusButton);
            ((Container)serializable2).add(new MyLabel("+"));
            ((Container)serializable2).add(this.colorPlusButton);
            n = 2;
            this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("IsosurfaceValuePanel.color")), 0, 1, 5, 1, 1.0, 0.0);
            this.layoutObject(serializable2, 5, 1, 10, 1, 1.0, 0.0);
        } else {
            this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("IsosurfaceValuePanel.color")), 0, 1, 5, 1, 1.0, 0.0);
            object = new MyPanel(flowLayout);
            this.userColorRadioButton = new MyRadioButton();
            this.valueColorRadioButton = new MyRadioButton();
            this.userColorRadioButton.setSelected(true);
            serializable2 = new ButtonGroup();
            ((ButtonGroup)serializable2).add(this.userColorRadioButton);
            ((ButtonGroup)serializable2).add(this.valueColorRadioButton);
            this.colorButton = new MyButton();
            this.colorButton.setPreferredSize(new Dimension(50, 28));
            this.colorButton.setBackground(this.value.colorMinus.get());
            this.colorButton.addActionListener(new colorListener());
            ((Container)object).add(this.userColorRadioButton);
            ((Container)object).add(this.colorButton);
            this.layoutObject(object, 5, 1, 10, 1, 1.0, 0.0);
            serializable = new MyPanel(flowLayout);
            ((Container)serializable).add(this.valueColorRadioButton);
            ((Container)serializable).add(new MyLabel("Min"));
            this.minValueText = new JTextField("1e-8");
            this.minValueText.setPreferredSize(new Dimension(50, 25));
            ((Container)serializable).add(this.minValueText);
            ((Container)serializable).add(new MyLabel("Max"));
            this.maxValueText = new JTextField("0.1");
            this.maxValueText.setPreferredSize(new Dimension(50, 25));
            ((Container)serializable).add(this.maxValueText);
            this.layoutObject(serializable, 5, 2, 10, 1, 1.0, 0.0);
            n = 3;
        }
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("IsosurfaceValuePanel.transparency")), 0, n, 5, 1, 1.0, 0.0);
        object = new MyPanel();
        this.transSlider = new MySlider(0, 100, 0);
        this.transSlider.setPreferredSize(new Dimension(150, 40));
        this.transSlider.setPaintTicks(true);
        this.transSlider.setMajorTickSpacing(50);
        this.transSlider.setPaintTrack(true);
        this.transSlider.setPaintLabels(true);
        this.transSlider.getLabelTable().put(new Integer(100), new MyLabel("100", 0));
        this.transSlider.setLabelTable(this.transSlider.getLabelTable());
        serializable2 = new MyLabel("0");
        ((JComponent)serializable2).setPreferredSize(new Dimension(25, 28));
        this.transSlider.addChangeListener(new SliderListener((MyLabel)serializable2));
        this.transSlider.setValue(this.value.transparency);
        ((Container)object).add(this.transSlider);
        ((Container)object).add((Component)serializable2);
        this.layoutObject(object, 5, n, 10, 1, 1.0, 0.0);
        ++n;
        this.bboxOnRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
        this.bboxOffRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.bboxOnRadioButton);
        ((ButtonGroup)serializable).add(this.bboxOffRadioButton);
        MyPanel myPanel = new MyPanel(flowLayout);
        this.bboxOffRadioButton.setSelected(true);
        this.bboxColorButton = new MyButton();
        this.bboxColorButton.setPreferredSize(new Dimension(40, 25));
        this.bboxColorButton.setBackground(this.value.bboxColor.get());
        this.bboxColorButton.addActionListener(new colorListener());
        myPanel.add(this.bboxOnRadioButton);
        myPanel.add(this.bboxColorButton);
        myPanel.add(this.bboxOffRadioButton);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("IsosurfaceValuePanel.boundingBox")), 0, n, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, n, 10, 1, 1.0, 0.0);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("section")), 0, ++n, 5, 1, 1.0, 0.0);
        MyPanel myPanel2 = new MyPanel();
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("set"));
        myPanel2.add(myButton);
        this.layoutObject(myPanel2, 5, n, 10, 1, 1.0, 0.0);
        myButton.addActionListener(new sectionListener());
    }

    public IsosurfaceValue getValue() {
        this.value.value = Float.parseFloat(this.valueText.getText());
        this.value.transparency = this.transSlider.getValue();
        this.value.boundingBox = this.bboxOnRadioButton.isSelected();
        this.value.bboxColor = new Color3f(this.bboxColorButton.getBackground());
        if (this.minText != null) {
            this.value.minValue = this.minText.getText() != null ? Float.parseFloat(this.minText.getText()) : 0.0f;
            this.value.maxValue = this.maxText.getText() != null ? Float.parseFloat(this.maxText.getText()) : 0.0f;
            this.value.potentialColor = this.minMaxComboBox.getSelectedIndex() == 0;
        } else if (this.fileItem.type == 14) {
            this.value.colorPlus = new Color3f(this.colorPlusButton.getBackground());
            this.value.colorMinus = new Color3f(this.colorMinusButton.getBackground());
        } else {
            this.value.colorMinus = new Color3f(this.colorButton.getBackground());
            this.value.minValue = this.minValueText.getText() != null ? Float.parseFloat(this.minValueText.getText()) : 0.0f;
            this.value.maxValue = this.maxValueText.getText() != null ? Float.parseFloat(this.maxValueText.getText()) : 0.0f;
            this.value.userOrValueColor = this.userColorRadioButton.isSelected();
        }
        return this.value;
    }

    public void closeSectionAssignWindow() {
        if (this.sectionAssignWindow != null) {
            this.sectionAssignWindow.undisplaySectionNode();
            this.sectionAssignWindow.setVisible(false);
        }
    }

    public SectionAssignWindow getSectionAssignWindow() {
        return this.sectionAssignWindow;
    }

    private class SliderListener
    implements ChangeListener {
        MyLabel tf;

        public SliderListener(MyLabel myLabel) {
            this.tf = myLabel;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MySlider mySlider = (MySlider)changeEvent.getSource();
            this.tf.setText(Integer.toString(mySlider.getValue()));
        }
    }

    private class sectionListener
    implements ActionListener {
        private sectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (IsosurfaceValuePanel.this.fileItem.isosurfaceValue.sectionAssignWindow == null) {
                IsosurfaceValuePanel.this.sectionAssignWindow = new SectionAssignWindow(IsosurfaceValuePanel.this.viewer, IsosurfaceValuePanel.this.fileItem, IsosurfaceValuePanel.this.value);
                IsosurfaceValuePanel.this.fileItem.isosurfaceValue.sectionAssignWindow = IsosurfaceValuePanel.this.sectionAssignWindow;
            }
            IsosurfaceValuePanel.this.sectionAssignWindow.setVisible(true);
        }
    }

    private class colorListener
    implements ActionListener {
        private colorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            Color color = myButton.getBackground();
            color = JColorChooser.showDialog(IsosurfaceValuePanel.this.me, "Color", color);
            if (color != null) {
                myButton.setBackground(color);
            }
        }
    }
}

