/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Structure.NodeData;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButton;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;

public class DisplayAttributePanel
extends GridBagLayoutPanel {
    public NodeData value;
    private MyComboBox modelComboBox;
    private MyComboBox colorComboBox;
    private MyRadioButton displayOnRadioButton;
    private MyRadioButton displayOffRadioButton;
    private MyRadioButton onRadioButton;
    private MyRadioButton onWithNoRadioButton;
    private MyRadioButton offRadioButton;
    private MyRadioButton nameRadioButton;
    private MyRadioButton noRadioButton;
    private MyButton colorButton;
    private DisplayAttributePanel me;
    private AbinitMpViewer abinitMpViewer;

    public DisplayAttributePanel(NodeData nodeData, int n, AbinitMpViewer abinitMpViewer) {
        this.abinitMpViewer = abinitMpViewer;
        this.me = this;
        this.value = new NodeData(nodeData);
        this.value.type = n;
        if (n == 2) {
            this.setBorder(new TitledBorder("Residue"));
        } else {
            this.setBorder(new TitledBorder("Atom"));
        }
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("DisplayAttributePanel.display")), 0, 0, 5, 1, 1.0, 0.0);
        this.displayOnRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
        this.displayOffRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.displayOnRadioButton);
        buttonGroup.add(this.displayOffRadioButton);
        MyPanel myPanel = new MyPanel(new FlowLayout(0));
        myPanel.add(this.displayOnRadioButton);
        myPanel.add(this.displayOffRadioButton);
        this.layoutObject(myPanel, 5, 0, 10, 1, 1.0, 0.0);
        if (nodeData.visible) {
            this.displayOnRadioButton.setSelected(true);
        } else {
            this.displayOffRadioButton.setSelected(true);
        }
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("DisplayAttributePanel.label")), 0, 1, 5, 1, 1.0, 0.0);
        if (n == 2) {
            this.onRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
            this.onWithNoRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("DisplayAttributePanel.nameAndNo"));
            this.offRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.onRadioButton);
            buttonGroup.add(this.onWithNoRadioButton);
            buttonGroup.add(this.offRadioButton);
            myPanel = new MyPanel(new FlowLayout(0));
            myPanel.add(this.onRadioButton);
            myPanel.add(this.onWithNoRadioButton);
            myPanel.add(this.offRadioButton);
            this.layoutObject(myPanel, 5, 1, 0, 1, 1.0, 0.0);
            if (nodeData.label == 1) {
                this.onRadioButton.setSelected(true);
            } else if (nodeData.label == 3) {
                this.onWithNoRadioButton.setSelected(true);
            } else {
                this.offRadioButton.setSelected(true);
            }
        } else if (n == 3) {
            this.nameRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("DisplayAttributePanel.name"));
            this.noRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("DisplayAttributePanel.no"));
            this.offRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.nameRadioButton);
            buttonGroup.add(this.noRadioButton);
            buttonGroup.add(this.offRadioButton);
            myPanel = new MyPanel();
            myPanel.add(this.nameRadioButton);
            myPanel.add(this.noRadioButton);
            myPanel.add(this.offRadioButton);
            this.layoutObject(myPanel, 5, 1, 10, 1, 1.0, 0.0);
            if (nodeData.label == 1) {
                this.nameRadioButton.setSelected(true);
            } else if (nodeData.label == 2) {
                this.noRadioButton.setSelected(true);
            } else {
                this.offRadioButton.setSelected(true);
            }
        }
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("DisplayAttributePanel.color")), 0, 2, 5, 1, 1.0, 0.0);
        this.colorComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("DisplayAttributePanel.colorStrings"));
        this.colorComboBox.setSelectedIndex(nodeData.color);
        this.layoutObject(this.colorComboBox, 5, 2, 10, 1, 1.0, 0.0);
        this.colorButton = new MyButton();
        this.colorButton.setPreferredSize(new Dimension(50, 28));
        if (nodeData.colorValue != null) {
            this.colorButton.setBackground(nodeData.colorValue.get());
        }
        this.colorButton.addActionListener(new colorListener());
        this.layoutObject(this.colorButton, 15, 2, 5, 1, 1.0, 0.0);
        if (n == 2) {
            this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("DisplayAttributePanel.model")), 0, 3, 5, 1, 1.0, 0.0);
            this.modelComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("DisplayAttributePanel.modelStrings"));
            this.modelComboBox.setSelectedIndex(nodeData.model);
            this.layoutObject(this.modelComboBox, 5, 3, 10, 1, 1.0, 0.0);
        }
    }

    public boolean conform() {
        this.getValue();
        this.abinitMpViewer.setDisplayAttribute(this.value);
        return true;
    }

    public void close() {
        this.abinitMpViewer.clearHighlightSelection(true);
    }

    public NodeData getValue() {
        this.value.visible = this.displayOnRadioButton.isSelected();
        if (this.value.type == 3) {
            this.value.label = this.nameRadioButton.isSelected() ? 1 : (this.noRadioButton.isSelected() ? 2 : 0);
        } else {
            this.value.label = this.onRadioButton.isSelected() ? 1 : (this.onWithNoRadioButton.isSelected() ? 3 : 0);
            this.value.model = this.modelComboBox.getSelectedIndex();
        }
        this.value.color = this.colorComboBox.getSelectedIndex();
        return this.value;
    }

    private class colorListener
    implements ActionListener {
        private colorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = null;
            if (DisplayAttributePanel.this.value.colorValue != null) {
                color = DisplayAttributePanel.this.value.colorValue.get();
            }
            if ((color = JColorChooser.showDialog(DisplayAttributePanel.this.me, "Color", color)) != null) {
                DisplayAttributePanel.this.value.colorValue = new Color3f(color);
                DisplayAttributePanel.this.colorButton.setBackground(color);
                DisplayAttributePanel.this.value.color = 15;
                DisplayAttributePanel.this.colorComboBox.setSelectedIndex(DisplayAttributePanel.this.value.color);
            }
        }
    }
}

