/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.AbinitMpFile.Cpf2denInputFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.PdbFile;
import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class Cpf2denInputFilePanel
extends GridBagLayoutPanel {
    private JTextField cpfFileText;
    private JTextField gridFileText;
    private JTextField numberOfGridXText;
    private JTextField numberOfGridYText;
    private JTextField numberOfGridZText;
    private JTextField domainXminText;
    private JTextField domainXmaxText;
    private JTextField domainYminText;
    private JTextField domainYmaxText;
    private JTextField domainZminText;
    private JTextField domainZmaxText;
    private JTextField valueText;
    private JTextField fragmentNoText;
    private JTextField homoNoText;
    private JTextField lumoNoText;
    private MyComboBox propertyComboBox;
    private MyPanel fragmentNoPanel;
    private MyPanel homoLumoNoPanel;
    private JFileChooser cpfFileChooser;
    private JFileChooser gridFileChooser;

    public Cpf2denInputFilePanel() {
        int n = 0;
        FlowLayout flowLayout = new FlowLayout(0);
        this.cpfFileText = new JTextField(30);
        this.gridFileText = new JTextField(30);
        this.numberOfGridXText = new JTextField(5);
        this.numberOfGridYText = new JTextField(5);
        this.numberOfGridZText = new JTextField(5);
        this.domainXminText = new JTextField(5);
        this.domainXmaxText = new JTextField(5);
        this.domainYminText = new JTextField(5);
        this.domainYmaxText = new JTextField(5);
        this.domainZminText = new JTextField(5);
        this.domainZmaxText = new JTextField(5);
        this.valueText = new JTextField(7);
        this.fragmentNoText = new JTextField(5);
        this.homoNoText = new JTextField(5);
        this.lumoNoText = new JTextField(5);
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("cpf", "Check Point file");
        this.cpfFileChooser = new JFileChooser(".");
        FileFilter fileFilter = this.cpfFileChooser.getFileFilter();
        this.cpfFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.cpfFileChooser.setFileFilter(fileFilter);
        this.cpfFileChooser.setPreferredSize(new Dimension(500, 500));
        ExampleFileFilter exampleFileFilter2 = new ExampleFileFilter(new String[]{"mo", "den", "esp", "map", "efv"}, "Grid file");
        this.gridFileChooser = new JFileChooser(".");
        FileFilter fileFilter2 = this.gridFileChooser.getFileFilter();
        this.gridFileChooser.addChoosableFileFilter(exampleFileFilter2);
        this.gridFileChooser.setFileFilter(fileFilter2);
        this.gridFileChooser.setPreferredSize(new Dimension(500, 500));
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("file"));
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("file"));
        myButton.addActionListener(new cpfFileListener());
        myButton2.addActionListener(new gridFileListener());
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.cpfFile")), 0, 0, 5, 1, 1.0, 0.0);
        this.layoutObject(this.cpfFileText, 5, n, 5, 1, 1.0, 0.0);
        this.layoutObject(myButton, 10, n, 5, 1, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.gridFile")), 0, 1, 5, 1, 1.0, 0.0);
        this.layoutObject(this.gridFileText, 5, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(myButton2, 10, n, 5, 1, 1.0, 0.0);
        this.propertyComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("Cpf2denInputFileWindow.property.options"));
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.property")), 0, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(this.propertyComboBox, 5, n, 0, 1, 1.0, 0.0);
        this.propertyComboBox.addActionListener(new propertyListener());
        this.layoutObject(new JLabel(" "), 0, ++n, 5, 1, 1.0, 0.0);
        this.fragmentNoPanel = new MyPanel(flowLayout);
        this.fragmentNoPanel.add(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.fragmentNo")));
        this.fragmentNoPanel.add(this.fragmentNoText);
        this.layoutObject(this.fragmentNoPanel, 5, n, 5, 1, 1.0, 0.0);
        this.layoutObject(new JLabel(" "), 0, ++n, 5, 1, 1.0, 0.0);
        this.homoLumoNoPanel = new MyPanel(flowLayout);
        this.homoLumoNoPanel.add(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.moRange")));
        this.homoLumoNoPanel.add(this.homoNoText);
        this.homoLumoNoPanel.add(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.lumo")));
        this.homoLumoNoPanel.add(this.lumoNoText);
        this.layoutObject(this.homoLumoNoPanel, 5, n, 5, 1, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.gridSize")), 0, ++n, 5, 1, 1.0, 0.0);
        MyPanel myPanel = new MyPanel(flowLayout);
        myPanel.add(new JLabel("X"));
        myPanel.add(this.numberOfGridXText);
        myPanel.add(new JLabel("Y"));
        myPanel.add(this.numberOfGridYText);
        myPanel.add(new JLabel("Z"));
        myPanel.add(this.numberOfGridZText);
        this.layoutObject(myPanel, 5, n, 5, 1, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.domainX")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(new JLabel(MyResourceBundle.getResourceString("min")));
        myPanel.add(this.domainXminText);
        myPanel.add(new JLabel(MyResourceBundle.getResourceString("max")));
        myPanel.add(this.domainXmaxText);
        this.layoutObject(myPanel, 5, n, 5, 1, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.domainY")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(new JLabel(MyResourceBundle.getResourceString("min")));
        myPanel.add(this.domainYminText);
        myPanel.add(new JLabel(MyResourceBundle.getResourceString("max")));
        myPanel.add(this.domainYmaxText);
        this.layoutObject(myPanel, 5, n, 5, 1, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.domainZ")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(new JLabel(MyResourceBundle.getResourceString("min")));
        myPanel.add(this.domainZminText);
        myPanel.add(new JLabel(MyResourceBundle.getResourceString("max")));
        myPanel.add(this.domainZmaxText);
        this.layoutObject(myPanel, 5, n, 5, 1, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("Cpf2denInputFileWindow.value")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(this.valueText);
        this.layoutObject(myPanel, 5, n, 5, 1, 1.0, 0.0);
        this.initialize();
    }

    public void setCpfFileDomain(CheckPointFile checkPointFile) {
        float f = 1.0E10f;
        float f2 = -1.0E10f;
        float f3 = 1.0E10f;
        float f4 = -1.0E10f;
        float f5 = 1.0E10f;
        float f6 = -1.0E10f;
        PdbFile pdbFile = checkPointFile.pdbFile;
        this.cpfFileText.setText(checkPointFile.filename);
        Vector vector = pdbFile.chains;
        for (int i = 0; i < vector.size(); ++i) {
            AtomData atomData;
            int n;
            ChainData chainData = (ChainData)vector.get(i);
            Vector vector2 = chainData.atomTable;
            Vector vector3 = chainData.hemTable;
            for (n = 0; n < vector2.size(); ++n) {
                atomData = (AtomData)vector2.get(n);
                f = Math.min(atomData.x, f);
                f3 = Math.min(atomData.y, f3);
                f5 = Math.min(atomData.z, f5);
                f2 = Math.max(atomData.x, f2);
                f4 = Math.max(atomData.y, f4);
                f6 = Math.max(atomData.z, f6);
            }
            for (n = 0; n < vector3.size(); ++n) {
                atomData = (AtomData)vector3.get(n);
                f = Math.min(atomData.x, f);
                f3 = Math.min(atomData.y, f3);
                f5 = Math.min(atomData.z, f5);
                f2 = Math.max(atomData.x, f2);
                f4 = Math.max(atomData.y, f4);
                f6 = Math.max(atomData.z, f6);
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("###0.000");
        this.domainXminText.setText(decimalFormat.format(f - 2.0f));
        this.domainXmaxText.setText(decimalFormat.format(f2 + 2.0f));
        this.domainYminText.setText(decimalFormat.format(f3 - 2.0f));
        this.domainYmaxText.setText(decimalFormat.format(f4 + 2.0f));
        this.domainZminText.setText(decimalFormat.format(f5 - 2.0f));
        this.domainZmaxText.setText(decimalFormat.format(f6 + 2.0f));
    }

    public void initialize() {
        this.cpfFileText.setText("");
        this.gridFileText.setText("");
        this.numberOfGridXText.setText("64");
        this.numberOfGridYText.setText("64");
        this.numberOfGridZText.setText("64");
        this.domainXminText.setText("");
        this.domainXmaxText.setText("");
        this.domainYminText.setText("");
        this.domainYmaxText.setText("");
        this.domainZminText.setText("");
        this.domainZmaxText.setText("");
        this.valueText.setText("0.001");
        this.fragmentNoText.setText("1");
        this.homoNoText.setText("0");
        this.lumoNoText.setText("0");
        this.propertyComboBox.setSelectedIndex(0);
    }

    public void setParameter(Cpf2denInputFile cpf2denInputFile) {
        this.cpfFileText.setText(cpf2denInputFile.getCpfFile());
        this.gridFileText.setText(cpf2denInputFile.getGridFile());
        this.numberOfGridXText.setText(cpf2denInputFile.getNumberOfGridX());
        this.numberOfGridYText.setText(cpf2denInputFile.getNumberOfGridY());
        this.numberOfGridZText.setText(cpf2denInputFile.getNumberOfGridZ());
        this.domainXminText.setText(cpf2denInputFile.getDomainXmin());
        this.domainXmaxText.setText(cpf2denInputFile.getDomainXmax());
        this.domainYminText.setText(cpf2denInputFile.getDomainYmin());
        this.domainYmaxText.setText(cpf2denInputFile.getDomainYmax());
        this.domainZminText.setText(cpf2denInputFile.getDomainZmin());
        this.domainZmaxText.setText(cpf2denInputFile.getDomainZmax());
        this.valueText.setText(cpf2denInputFile.getValue());
        this.fragmentNoText.setText(cpf2denInputFile.getFragmentNo());
        this.homoNoText.setText(cpf2denInputFile.getHomoNo());
        this.lumoNoText.setText(cpf2denInputFile.getLumoNo());
        this.propertyComboBox.setSelectedIndex(cpf2denInputFile.getProperty());
    }

    public void setParameterToFile(Cpf2denInputFile cpf2denInputFile) {
        cpf2denInputFile.set(this.cpfFileText.getText(), this.gridFileText.getText(), this.numberOfGridXText.getText(), this.numberOfGridYText.getText(), this.numberOfGridZText.getText(), this.domainXminText.getText(), this.domainXmaxText.getText(), this.domainYminText.getText(), this.domainYmaxText.getText(), this.domainZminText.getText(), this.domainZmaxText.getText(), this.valueText.getText(), this.fragmentNoText.getText(), this.homoNoText.getText(), this.lumoNoText.getText(), this.propertyComboBox.getSelectedIndex());
    }

    class gridFileListener
    extends AbstractAction {
        gridFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Cpf2denInputFilePanel.this.gridFileChooser.showOpenDialog(null) == 0) {
                Cpf2denInputFilePanel.this.gridFileText.setText(Cpf2denInputFilePanel.this.gridFileChooser.getSelectedFile().getPath());
            }
        }
    }

    class cpfFileListener
    extends AbstractAction {
        cpfFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Cpf2denInputFilePanel.this.cpfFileChooser.showOpenDialog(null) == 0) {
                String string = Cpf2denInputFilePanel.this.cpfFileChooser.getSelectedFile().getPath();
                CheckPointFile checkPointFile = new CheckPointFile(string);
                if (checkPointFile.filename != null) {
                    Cpf2denInputFilePanel.this.cpfFileText.setText(string);
                    Cpf2denInputFilePanel.this.setCpfFileDomain(checkPointFile);
                }
            }
        }
    }

    class propertyListener
    extends AbstractAction {
        propertyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyComboBox myComboBox = (MyComboBox)actionEvent.getSource();
            if (myComboBox.getSelectedIndex() == 0) {
                Cpf2denInputFilePanel.this.fragmentNoPanel.setVisible(true);
                Cpf2denInputFilePanel.this.homoLumoNoPanel.setVisible(true);
            } else {
                Cpf2denInputFilePanel.this.fragmentNoPanel.setVisible(false);
                Cpf2denInputFilePanel.this.homoLumoNoPanel.setVisible(false);
            }
        }
    }
}

