/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Display;

import AbinitMp.Tool.MathFunc;

public class ColorMap {
    private static final int MAX_COLOR_TABLE = 5;
    private ColorTable[] colorTable = new ColorTable[5];
    private float[] threshold = new float[5];
    private int valueRangeType;
    private static final int SEQUENTIAL = 0;
    private static final int MIX = 1;
    private static final int REVERSE = 2;
    private float minValue;
    private float maxValue;
    private static final int DEFAULT_RANGE = 8;
    private int scaleType;
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static final int POTENTIAL = 0;
    public static final int POTENTIAL_REVERSE = 1;
    public static final int DENSITY = 2;

    public ColorMap() {
        this.setInitialData(0);
    }

    public ColorMap(float f, float f2, int n) {
        this.setInitialData(0);
        this.minValue = f;
        this.maxValue = f2;
        this.scaleType = n;
        this.setThreshold();
    }

    public ColorMap(float f, float f2, int n, int n2) {
        this.setInitialData(n2);
        this.minValue = f;
        this.maxValue = f2;
        this.scaleType = n;
        this.setThreshold();
    }

    public ColorMap(float f, float f2, boolean bl) {
        if (bl) {
            this.setInitialData(0);
        } else {
            this.setInitialData(1);
        }
        this.minValue = f;
        this.maxValue = f2;
        this.scaleType = 0;
        this.setThreshold();
    }

    private void setInitialData(int n) {
        float[][] fArrayArray = new float[][]{{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f}, {0.5f, 0.5f, 1.0f, 0.5f, 0.5f, 0.0f}, {1.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.0f}, {1.0f, 0.5f, 0.5f, 0.0f, -0.5f, -0.5f}, {1.0f, 0.0f, 0.0f, 0.0f, -0.5f, -0.5f}};
        float[][] fArrayArray2 = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {1.0f, 0.5f, 0.5f, 0.0f, 0.5f, 0.5f}, {1.0f, 1.0f, 1.0f, 0.0f, 0.5f, 0.5f, 0.0f}, {0.5f, 0.5f, 1.0f, -0.5f, -0.5f, 0.0f}, {0.0f, 0.0f, 1.0f, -0.5f, -0.5f, 0.0f}};
        float[][] fArrayArray3 = new float[][]{{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f}, {1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f}};
        switch (n) {
            case 0: {
                for (int i = 0; i < 5; ++i) {
                    this.colorTable[i] = new ColorTable(fArrayArray[i]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 5; ++i) {
                    this.colorTable[i] = new ColorTable(fArrayArray2[i]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 5; ++i) {
                    this.colorTable[i] = new ColorTable(fArrayArray3[i]);
                }
                break;
            }
        }
    }

    public void setThreshold() {
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (this.scaleType == 1) {
            if ((double)this.minValue == 0.0) {
                this.minValue = 1.0E-8f;
            }
            if ((double)this.maxValue == 0.0) {
                this.maxValue = (double)this.minValue < 0.0 ? -1.0E-8f : 1.0f;
            }
            f2 = (double)this.minValue < 0.0 ? MathFunc.log10(-this.minValue) : MathFunc.log10(this.minValue);
            f3 = (double)this.maxValue < 0.0 ? MathFunc.log10(-this.maxValue) : MathFunc.log10(this.maxValue);
            if ((double)this.minValue < 0.0 && (double)this.maxValue > 0.0) {
                this.valueRangeType = 1;
                f4 = Math.abs(f3 + 8.0f);
                f5 = Math.abs(f2 + 8.0f);
            } else if ((double)this.minValue < 0.0 && (double)this.maxValue < 0.0) {
                this.valueRangeType = 2;
                f = Math.abs(f3 - f2);
            } else {
                this.valueRangeType = 0;
                f = Math.abs(f3 - f2);
            }
        } else {
            f = this.maxValue - this.minValue;
            this.valueRangeType = 0;
        }
        for (int i = 0; i < 5; ++i) {
            if (this.scaleType == 1) {
                if ((double)this.minValue < 0.0 || (double)this.maxValue < 0.0) {
                    if ((double)this.minValue < 0.0 && (double)this.maxValue < 0.0) {
                        this.threshold[i] = -f / 4.0f * (float)i + MathFunc.log10(-this.minValue);
                        continue;
                    }
                    if (f5 / 4.0f * (float)i < Math.abs(f2) + 1.0f || (double)this.maxValue < 0.0 || this.valueRangeType == 1 && i < 2) {
                        this.threshold[i] = f2 - 2.0f * f5 / 4.0f * (float)i;
                        continue;
                    }
                    if (f5 / 4.0f * (float)i == Math.abs(f2) + 1.0f) {
                        this.threshold[i] = this.threshold[i - 1] + (this.threshold[i - 1] - this.threshold[i - 2]);
                        continue;
                    }
                    this.threshold[i] = f3 - 2.0f * (f4 - f4 / 4.0f * (float)i);
                    continue;
                }
                this.threshold[i] = f / 4.0f * (float)i + MathFunc.log10(this.minValue);
                continue;
            }
            this.threshold[i] = f / 4.0f * (float)i + this.minValue;
        }
    }

    public float[] getRgb(double d) {
        return this.getRgb((float)d);
    }

    public float[] getRgb(float f) {
        float[] fArray = new float[3];
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (f < this.minValue) {
            f4 = this.colorTable[0].r;
            f3 = this.colorTable[0].g;
            f2 = this.colorTable[0].b;
        } else if (f > this.maxValue) {
            f4 = this.colorTable[4].r;
            f3 = this.colorTable[4].g;
            f2 = this.colorTable[4].b;
        } else {
            float f5 = this.scaleType == 1 ? ((double)f == 0.0 ? 1.0f : ((double)f < 0.0 ? MathFunc.log10(-f) : ((double)f > 0.0 ? MathFunc.log10(f) : 0.0f))) : f;
            if (this.valueRangeType == 0) {
                if (f5 <= this.threshold[0]) {
                    f4 = this.colorTable[0].r;
                    f3 = this.colorTable[0].g;
                    f2 = this.colorTable[0].b;
                } else if (f5 < this.threshold[4]) {
                    for (int i = 1; i < 5; ++i) {
                        if (!(f5 < this.threshold[i])) continue;
                        f4 = this.colorTable[i - 1].r + this.colorTable[i].r_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                        f3 = this.colorTable[i - 1].g + this.colorTable[i].g_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                        f2 = this.colorTable[i - 1].b + this.colorTable[i].b_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                        break;
                    }
                } else {
                    f4 = this.colorTable[4].r;
                    f3 = this.colorTable[4].g;
                    f2 = this.colorTable[4].b;
                }
            } else if (this.valueRangeType == 1) {
                if ((double)f == 0.0) {
                    f4 = this.colorTable[2].r;
                    f3 = this.colorTable[2].g;
                    f2 = this.colorTable[2].b;
                } else if ((double)f < 0.0) {
                    if (f5 >= this.threshold[0]) {
                        f4 = this.colorTable[0].r;
                        f3 = this.colorTable[0].g;
                        f2 = this.colorTable[0].b;
                    } else if (f5 > this.threshold[2]) {
                        for (int i = 1; i <= 2; ++i) {
                            if (!(f5 > this.threshold[i])) continue;
                            f4 = this.colorTable[i - 1].r + this.colorTable[i].r_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                            f3 = this.colorTable[i - 1].g + this.colorTable[i].g_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                            f2 = this.colorTable[i - 1].b + this.colorTable[i].b_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                            break;
                        }
                    } else {
                        f4 = this.colorTable[2].r;
                        f3 = this.colorTable[2].g;
                        f2 = this.colorTable[2].b;
                    }
                } else if (f5 >= this.threshold[4]) {
                    f4 = this.colorTable[4].r;
                    f3 = this.colorTable[4].g;
                    f2 = this.colorTable[4].b;
                } else if (f5 > this.threshold[2]) {
                    for (int i = 3; i < 5; ++i) {
                        if (!(f5 < this.threshold[i])) continue;
                        f4 = this.colorTable[i - 1].r + this.colorTable[i].r_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                        f3 = this.colorTable[i - 1].g + this.colorTable[i].g_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                        f2 = this.colorTable[i - 1].b + this.colorTable[i].b_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                        break;
                    }
                } else {
                    f4 = this.colorTable[2].r;
                    f3 = this.colorTable[2].g;
                    f2 = this.colorTable[2].b;
                }
            } else if ((double)f > 0.0) {
                f4 = this.colorTable[4].r;
                f3 = this.colorTable[4].g;
                f2 = this.colorTable[4].b;
            } else if (f5 > this.threshold[0]) {
                f4 = this.colorTable[0].r;
                f3 = this.colorTable[0].g;
                f2 = this.colorTable[0].b;
            } else if (f5 > this.threshold[4]) {
                for (int i = 1; i < 5; ++i) {
                    if (!(f5 > this.threshold[i])) continue;
                    f4 = this.colorTable[i - 1].r + this.colorTable[i].r_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                    f3 = this.colorTable[i - 1].g + this.colorTable[i].g_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                    f2 = this.colorTable[i - 1].b + this.colorTable[i].b_inc * (f5 - this.threshold[i - 1]) / (this.threshold[i] - this.threshold[i - 1]);
                    break;
                }
            } else {
                f4 = this.colorTable[4].r;
                f3 = this.colorTable[4].g;
                f2 = this.colorTable[4].b;
            }
        }
        fArray[0] = f4;
        fArray[1] = f3;
        fArray[2] = f2;
        return fArray;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public int getScaletype() {
        return this.scaleType;
    }

    public void setMinValue(float f) {
        this.minValue = f;
    }

    public void setMaxValue(float f) {
        this.maxValue = f;
    }

    public void setScaleType(int n) {
        this.scaleType = n;
    }

    public void setMinMaxScaleTypeValue(float f, float f2, int n) {
        this.minValue = f;
        this.maxValue = f2;
        this.scaleType = n;
        this.setThreshold();
    }

    public void setMinMaxValue(float f, float f2) {
        this.minValue = f;
        this.maxValue = f2;
        this.scaleType = 0;
        this.setThreshold();
    }

    public static void main(String[] stringArray) {
        float f;
        float f2;
        float f3;
        if (stringArray.length == 3) {
            f3 = Float.parseFloat(stringArray[0]);
            f2 = Float.parseFloat(stringArray[1]);
            f = Float.parseFloat(stringArray[2]);
        } else {
            f3 = 1.0E-8f;
            f2 = 1.0f;
            f = 1.0E-4f;
        }
        ColorMap colorMap = new ColorMap(f3, f2, 1);
        float[] fArray = colorMap.getRgb(f);
        System.out.println("rgb " + fArray[0] + " " + fArray[1] + " " + fArray[2]);
    }

    class ColorTable {
        float r;
        float g;
        float b;
        float r_inc;
        float g_inc;
        float b_inc;

        ColorTable() {
        }

        ColorTable(float[] fArray) {
            this.r = fArray[0];
            this.g = fArray[1];
            this.b = fArray[2];
            this.r_inc = fArray[3];
            this.g_inc = fArray[4];
            this.b_inc = fArray[5];
        }
    }
}

