/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.Range;
import hep.aida.ref.pdf.Variable;

public class Parameter
extends Variable {
    private double value;
    private Range range;
    private double stepSize = Double.NaN;
    private boolean isFixed = false;
    private boolean useBounds = false;

    public Parameter(String name) {
        this(name, Double.NaN);
    }

    public Parameter(String name, double value) {
        this(name, value, Double.NaN);
    }

    public Parameter(String name, double value, boolean isFixed) {
        this(name, value, Double.NaN, isFixed);
    }

    public Parameter(String name, double value, double lowerBound, double upperBound) {
        this(name, value, Double.NaN, lowerBound, upperBound);
    }

    public Parameter(String name, double value, double stepSize) {
        this(name, value, stepSize, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public Parameter(String name, double value, double stepSize, boolean isFixed) {
        this(name, value, stepSize, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, isFixed);
    }

    public Parameter(String name, double value, double stepSize, double lowerBound, double upperBound) {
        this(name, value, stepSize, lowerBound, upperBound, false);
    }

    public Parameter(String name, double value, double stepSize, double lowerBound, double upperBound, boolean isFixed) {
        super(name, Variable.PARAMETER);
        this.range = new Range(lowerBound, upperBound);
        this.setVariableValue(value);
        this.setStepSize(stepSize);
        this.setFixed(this.isFixed());
    }

    public double value() {
        return this.value;
    }

    protected void setVariableValue(double value) {
        if (this.isFixed()) {
            throw new RuntimeException("Cannot change parameter " + this.name() + " value; it is fixed.");
        }
        if (this.useBounds() && !this.range.isInRange(value)) {
            throw new IllegalArgumentException("Value " + value + " is outside the range " + this.range.lowerBound() + " - " + this.range.upperBound() + " for parameter " + this.name());
        }
        this.value = value;
    }

    public void setFixed(boolean isFixed) {
        this.isFixed = isFixed;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setUseBounds(boolean useBounds) {
        this.useBounds = useBounds;
    }

    public boolean useBounds() {
        return this.useBounds;
    }

    public double stepSize() {
        if (Double.isNaN(this.stepSize) && !Double.isInfinite(this.range.upperBound()) && !Double.isInfinite(this.range.lowerBound())) {
            return (this.range.upperBound() - this.range.lowerBound()) / 2.0;
        }
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        if (stepSize < 0.0) {
            throw new IllegalArgumentException("Cannot set negative step size " + stepSize);
        }
        if (stepSize == 0.0) {
            throw new IllegalArgumentException("Setting step size to 0 is equivalent to fixing the parameter. Please use the setFixed(boolean) method instead.");
        }
        this.stepSize = stepSize;
    }

    public double upperBound() {
        return this.range.upperBound();
    }

    public double lowerBound() {
        return this.range.lowerBound();
    }

    public void setUpperBound(double upperBound) {
        this.range.setUpperBound(upperBound);
    }

    public void setLowerBound(double lowerBound) {
        this.range.setLowerBound(lowerBound);
    }

    public void setBounds(double lowerBound, double upperBound) {
        this.range.setUpperBound(upperBound);
        this.range.setLowerBound(lowerBound);
    }
}

