/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.dataset;

class MeanAndRmsStatistics {
    private double m;
    private double r;
    private double sw;
    private String description;

    protected MeanAndRmsStatistics(String description) {
        this.setDescription(description);
        this.reset();
    }

    public void addEntry(double x, double w) {
        if (w < 0.0) {
            throw new IllegalArgumentException("Cannot accept an entry with negative weight " + w);
        }
        this.m += x * w;
        this.r += x * x * w;
        this.sw += w;
    }

    public void addEntry(double x) {
        this.addEntry(x, 1.0);
    }

    public void removeEntry(double x, double w) {
        if (w < 0.0) {
            throw new IllegalArgumentException("Cannot accept an entry with negative weight " + w);
        }
        this.m -= x * w;
        this.r -= x * x * w;
        this.sw -= w;
    }

    public void removeEntry(double x) {
        this.removeEntry(x, 1.0);
    }

    public void addEntries(double mean, double rms, double sumw) {
        double mEntries = mean * sumw;
        double rEntries = (rms * rms + mean * mean) * sumw;
        this.m += mEntries;
        this.r += rEntries;
        this.sw += sumw;
    }

    public void removeEntries(double mean, double rms, double sumw) {
        double mEntries = mean * sumw;
        double rEntries = (rms * rms + mean * mean) * sumw;
        this.m -= mEntries;
        this.r -= rEntries;
        if (this.r < 0.0) {
            this.r = 0.0;
        }
        this.sw -= sumw;
    }

    public double mean() {
        if (this.sw != 0.0) {
            return this.m / this.sw;
        }
        return 0.0;
    }

    public double rms() {
        if (this.sw != 0.0) {
            double up2 = this.r * this.sw - this.m * this.m;
            if (up2 < -1.0E-12 * this.m * this.m) {
                up2 = 0.0;
            }
            return Math.sqrt(Math.abs(up2)) / this.sw;
        }
        return 0.0;
    }

    public void scale(double scaleFactor) {
        if (scaleFactor > 0.0) {
            this.m *= scaleFactor;
            this.r *= scaleFactor;
            this.sw *= scaleFactor;
        } else {
            throw new IllegalArgumentException("Invalid scale factor " + scaleFactor + ". It must be positive");
        }
    }

    public String description() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public void reset() {
        this.m = 0.0;
        this.r = 0.0;
        this.sw = 0.0;
    }
}

