/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.ImageException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class JASIcon
extends ImageIcon {
    private Class m_c;
    private String m_file;
    private static Hashtable imageCache = new Hashtable();
    private static JASIcon brokenIcon;
    private static Image noImage;
    static /* synthetic */ Class class$jas$util$JASIcon;

    JASIcon(String string) throws ImageException {
        this((Class)null, string);
    }

    public JASIcon(Object object, String string) throws ImageException {
        this(object == null ? null : object.getClass(), string);
    }

    public JASIcon(Class clazz, String string) throws ImageException {
        Class clazz2 = clazz == null ? (class$jas$util$JASIcon == null ? (class$jas$util$JASIcon = JASIcon.class$("jas.util.JASIcon")) : class$jas$util$JASIcon) : clazz;
        this.m_c = clazz2;
        this.setImageImpl(string);
    }

    public JASIcon(Class clazz) {
        Class clazz2 = clazz == null ? (class$jas$util$JASIcon == null ? (class$jas$util$JASIcon = JASIcon.class$("jas.util.JASIcon")) : class$jas$util$JASIcon) : clazz;
        this.m_c = clazz2;
    }

    public void setImage(String string) {
        try {
            this.setImageImpl(string);
        }
        catch (ImageException imageException) {
            this.setImage(brokenIcon.getImage());
        }
    }

    private void setImageImpl(String string) throws ImageException {
        this.m_file = string;
        Image image = (Image)imageCache.get(this);
        if (image == null) {
            try {
                URL uRL = this.m_c.getResource(string);
                if (uRL != null) {
                    image = Toolkit.getDefaultToolkit().getImage(uRL);
                } else {
                    byte[] byArray = this.getImageBytes(this.m_c, this.m_file);
                    if (byArray == null) {
                        throw new ImageException();
                    }
                    image = Toolkit.getDefaultToolkit().createImage(byArray);
                }
                imageCache.put(this, image);
            }
            catch (ImageException imageException) {
                imageCache.put(this, noImage);
                throw imageException;
            }
        } else if (image == noImage) {
            throw new ImageException();
        }
        this.setImage(image);
    }

    private byte[] getImageBytes(Class clazz, String string) throws ImageException {
        try {
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            byte[] byArray = new byte[Math.min(10000, inputStream.available())];
            int n = 0;
            while (true) {
                if (n == byArray.length) {
                    throw new ImageException("Image too big for buffer");
                }
                int n2 = inputStream.read(byArray, byArray.length - n, n);
                if (n2 <= 0) break;
                n += n2;
            }
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        return this.m_file.hashCode() + this.m_c.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JASIcon)) {
            return false;
        }
        JASIcon jASIcon = (JASIcon)object;
        if (jASIcon.m_c != this.m_c) {
            return false;
        }
        return jASIcon.m_file.equals(this.m_file);
    }

    public static JASIcon create(Object object, String string) {
        try {
            return new JASIcon(object, string);
        }
        catch (ImageException imageException) {
            return brokenIcon;
        }
    }

    public static JASIcon create(Class clazz, String string) {
        try {
            return new JASIcon(clazz, string);
        }
        catch (ImageException imageException) {
            return brokenIcon;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            brokenIcon = new JASIcon("brokenIcon.gif");
            noImage = brokenIcon.getImage();
        }
        catch (ImageException imageException) {
            System.err.println("Could not load brokenIcon .. this looks bad!");
        }
    }
}

