/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.StatisticsBlock;
import jas.util.JASDialog;
import jas.util.JASState;
import jas.util.SciFormatPanel;
import jas.util.ScientificFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class StatsWindow
extends JASDialog
implements ActionListener {
    public static JFrame frame;
    private JButton all;
    private JButton none;
    private JRadioButton alltitles;
    private JRadioButton notitles;
    private JRadioButton sometitles;
    private JRadioButton leftalign;
    private JRadioButton rightalign;
    private JRadioButton noalign;
    private JRadioButton alwaysall;
    private JRadioButton subset;
    private String[] names;
    private JLabel selectlabel;
    private SciFormatPanel scipanel;
    private ScientificFormat f;
    private StatisticsBlock statblock;
    private JList list;
    private int showtitles;
    private int splitalign;

    public StatsWindow(StatisticsBlock statisticsBlock) {
        super((Frame)frame, "Statistic Display Options", true, 15);
        this.statblock = statisticsBlock;
        Format format = statisticsBlock.getFormat();
        this.f = format instanceof ScientificFormat ? (ScientificFormat)format : new ScientificFormat();
    }

    public void showStatsWindow() {
        super.setHelpTopic("userInterface.Statistics");
        Container container = this.getContentPane();
        container.removeAll();
        this.scipanel = new SciFormatPanel(this.f);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.alwaysall = new JRadioButton("Always show all statistics");
        this.alwaysall.addActionListener(this);
        this.alwaysall.setActionCommand("alwaysall");
        this.subset = new JRadioButton("Show selection of current statistics");
        this.subset.addActionListener(this);
        this.subset.setActionCommand("subset");
        buttonGroup.add(this.alwaysall);
        buttonGroup.add(this.subset);
        Box box = new Box(0);
        box.add(this.alwaysall);
        box.add(this.subset);
        this.names = this.statblock.getStatNames();
        this.list = new JList<CheckableItem>(this.createData(this.names));
        this.list.setVisibleRowCount(3);
        this.list.setCellRenderer(new CheckListRenderer());
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = StatsWindow.this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1 && StatsWindow.this.list.getModel().getSize() > n) {
                    CheckableItem checkableItem;
                    checkableItem.setSelected(!(checkableItem = (CheckableItem)StatsWindow.this.list.getModel().getElementAt(n)).isSelected());
                    Rectangle rectangle = StatsWindow.this.list.getCellBounds(n, n);
                    StatsWindow.this.list.repaint(rectangle);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        Box box2 = new Box(1);
        this.all = new JButton("All");
        this.none = new JButton("None");
        this.all.setActionCommand("all");
        this.all.addActionListener(this);
        this.none.setActionCommand("none");
        this.none.addActionListener(this);
        box2.add(this.all);
        box2.add(this.none);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.selectlabel = new JLabel("Choose selection of current statistics for display");
        jPanel.add((Component)this.selectlabel, "North");
        jPanel.add((Component)box2, "East");
        jPanel.add((Component)jScrollPane, "Center");
        Box box3 = new Box(1);
        box3.add(box);
        box3.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Choose a statistics display options"));
        jPanel2.add(box3);
        this.showtitles = this.statblock.getShowTitles();
        this.alltitles = new JRadioButton("Always show title");
        this.notitles = new JRadioButton("Never show title");
        this.sometitles = new JRadioButton("Show if multiple plots");
        this.alltitles.setActionCommand("alltitles");
        this.alltitles.addActionListener(this);
        this.notitles.setActionCommand("notitles");
        this.notitles.addActionListener(this);
        this.sometitles.setActionCommand("sometitles");
        this.sometitles.addActionListener(this);
        Box box4 = new Box(0);
        box4.add(this.alltitles);
        box4.add(this.notitles);
        box4.add(this.sometitles);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.alltitles);
        buttonGroup2.add(this.notitles);
        buttonGroup2.add(this.sometitles);
        if (this.showtitles == 1) {
            this.alltitles.setSelected(true);
        } else if (this.showtitles == 2) {
            this.notitles.setSelected(true);
        } else if (this.showtitles == 3) {
            this.sometitles.setSelected(true);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Select a title display option for plots with statistics"));
        jPanel3.add(box4);
        this.splitalign = this.statblock.getSplitStringAlign();
        this.leftalign = new JRadioButton("Left align numbers");
        this.rightalign = new JRadioButton("Right align numbers");
        this.noalign = new JRadioButton("Do not align numbers");
        this.leftalign.setActionCommand("leftalign");
        this.leftalign.addActionListener(this);
        this.rightalign.setActionCommand("rightalign");
        this.rightalign.addActionListener(this);
        this.noalign.setActionCommand("noalign");
        this.noalign.addActionListener(this);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        Box box5 = new Box(0);
        buttonGroup3.add(this.leftalign);
        buttonGroup3.add(this.rightalign);
        buttonGroup3.add(this.noalign);
        box5.add(this.leftalign);
        box5.add(this.rightalign);
        box5.add(this.noalign);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Select an alignment display option for the statistics values"));
        jPanel4.add(box5);
        if (this.splitalign == 1) {
            this.leftalign.setSelected(true);
        } else if (this.splitalign == 2) {
            this.rightalign.setSelected(true);
        } else if (this.splitalign == 3) {
            this.noalign.setSelected(true);
        }
        JPanel jPanel5 = this.scipanel.getPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder("Set number formating parameters for numerical statistics"));
        if (this.statblock.get_AllwaysAll_Subset()) {
            this.alwaysall.setSelected(true);
            this.enableStatSelections(false);
        } else {
            this.subset.setSelected(true);
        }
        Box box6 = new Box(1);
        box6.add(jPanel2);
        box6.add(jPanel3);
        box6.add(jPanel4);
        box6.add(jPanel5);
        container.add(box6);
        this.pack();
        this.show();
    }

    public void onOK() {
        this.scipanel.updateSciFormat();
        ListModel listModel = this.list.getModel();
        if (this.alwaysall.isSelected()) {
            String[] stringArray = null;
            this.statblock.setSelectedEntries(null);
            this.statblock.set_AllwaysAll_Subset(true);
        } else if (listModel.getSize() > 0) {
            String[] stringArray;
            int n;
            int n2 = listModel.getSize();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(n);
                if (!checkableItem.isSelected()) continue;
                ++n3;
            }
            if (n3 > 0) {
                stringArray = new String[n3];
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
                    if (!checkableItem.isSelected()) continue;
                    stringArray[n] = checkableItem.toString();
                    ++n;
                }
            } else {
                stringArray = new String[]{"\none"};
            }
            this.statblock.setSelectedEntries(stringArray);
            this.statblock.set_AllwaysAll_Subset(false);
        } else {
            String[] stringArray = null;
            this.statblock.setSelectedEntries(null);
            this.statblock.set_AllwaysAll_Subset(false);
        }
        this.statblock.setShowTitles(this.showtitles);
        this.statblock.setSplitStringAlign(this.splitalign);
        this.statblock.setFormat(this.f);
        this.dispose();
    }

    protected void enableApply(JASState jASState) {
        jASState.setEnabled(true);
    }

    protected void enableHelp(JASState jASState) {
        jASState.setEnabled(true);
    }

    public void onCancel() {
        this.dispose();
    }

    public void onApply() {
        this.scipanel.updateSciFormat();
        ListModel listModel = this.list.getModel();
        if (this.alwaysall.isSelected()) {
            String[] stringArray = null;
            this.statblock.setSelectedEntries(null);
            this.statblock.set_AllwaysAll_Subset(true);
        } else if (listModel.getSize() > 0) {
            String[] stringArray;
            int n;
            int n2 = listModel.getSize();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(n);
                if (!checkableItem.isSelected()) continue;
                ++n3;
            }
            if (n3 > 0) {
                stringArray = new String[n3];
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
                    if (!checkableItem.isSelected()) continue;
                    stringArray[n] = checkableItem.toString();
                    ++n;
                }
            } else {
                stringArray = new String[]{"\none"};
            }
            this.statblock.setSelectedEntries(stringArray);
            this.statblock.set_AllwaysAll_Subset(false);
        } else {
            String[] stringArray = null;
            this.statblock.setSelectedEntries(null);
            this.statblock.set_AllwaysAll_Subset(false);
        }
        this.statblock.setShowTitles(this.showtitles);
        this.statblock.setSplitStringAlign(this.splitalign);
        this.statblock.setFormat(this.f);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "all") {
            ListModel listModel = this.list.getModel();
            int n = listModel.getSize();
            for (int i = 0; i < n; ++i) {
                CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
                checkableItem.setSelected(true);
            }
            this.list.repaint();
        } else if (actionEvent.getActionCommand() == "none") {
            ListModel listModel = this.list.getModel();
            int n = listModel.getSize();
            for (int i = 0; i < n; ++i) {
                CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
                checkableItem.setSelected(false);
            }
            this.list.repaint();
        } else if (actionEvent.getActionCommand() == "alwaysall") {
            this.enableStatSelections(false);
        } else if (actionEvent.getActionCommand() == "subset") {
            this.enableStatSelections(true);
        } else if (actionEvent.getActionCommand() == "alltitles") {
            this.showtitles = 1;
        } else if (actionEvent.getActionCommand() == "notitles") {
            this.showtitles = 2;
        } else if (actionEvent.getActionCommand() == "sometitles") {
            this.showtitles = 3;
        } else if (actionEvent.getActionCommand() == "leftalign") {
            this.splitalign = 1;
        } else if (actionEvent.getActionCommand() == "rightalign") {
            this.splitalign = 2;
        } else if (actionEvent.getActionCommand() == "noalign") {
            this.splitalign = 3;
        }
    }

    private void enableStatSelections(boolean bl) {
        this.all.setEnabled(bl);
        this.none.setEnabled(bl);
        this.selectlabel.setEnabled(bl);
        this.list.setEnabled(bl);
    }

    private CheckableItem[] createData(String[] stringArray) {
        int n = stringArray.length;
        CheckableItem[] checkableItemArray = new CheckableItem[n];
        for (int i = 0; i < n; ++i) {
            checkableItemArray[i] = new CheckableItem(stringArray[i]);
        }
        return checkableItemArray;
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CheckListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled());
            this.setSelected(((CheckableItem)object).isSelected());
            this.setText(object.toString());
            this.setBackground(Color.white);
            return this;
        }
    }

    class CheckableItem {
        private String str;
        private boolean isSelected;

        public CheckableItem(String string) {
            this.str = string;
            this.isSelected = false;
            this.initializeSelection();
        }

        private void initializeSelection() {
            String[] stringArray = StatsWindow.this.statblock.getSelectedEntries();
            if (stringArray == null) {
                this.setSelected(true);
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.str.equals(stringArray[i])) continue;
                    this.setSelected(true);
                }
            }
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public String toString() {
            return this.str;
        }
    }
}

