/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.IncompatibleMatrices;
import jas.hist.IndeterminateMatrix;
import jas.hist.MatrixBug;
import java.text.NumberFormat;

public class Matrix {
    public static double[][] create(int n) {
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[n];
        }
        return dArrayArray;
    }

    public static double[][] clone(double[][] dArray) {
        double[][] dArray2 = (double[][])dArray.clone();
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = (double[])dArray2[i].clone();
        }
        return dArray2;
    }

    public static void print(double[][] dArray) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                System.out.print(numberFormat.format(dArray[i][j]) + " ");
            }
            System.out.println();
        }
    }

    public static double[][] multiply(double[][] dArray, double[][] dArray2) throws IncompatibleMatrices {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length != dArray2.length) {
                throw new IncompatibleMatrices();
            }
            dArrayArray[i] = new double[dArray2[i].length];
            for (int j = 0; j < dArray2[i].length; ++j) {
                dArrayArray[i][j] = 0.0;
                for (int k = 0; k < dArray[i].length; ++k) {
                    double[] dArray3 = dArrayArray[i];
                    int n = j;
                    dArray3[n] = dArray3[n] + dArray[i][k] * dArray2[k][j];
                }
            }
        }
        return dArrayArray;
    }

    public static double invert(double[][] dArray) throws IndeterminateMatrix {
        int n;
        int n2;
        double d = 1.0;
        int n3 = dArray.length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            double d2;
            int n4;
            double d3 = 0.0;
            for (n = n2; n < n3; ++n) {
                for (n4 = n2; n4 < n3; ++n4) {
                    if (!(Math.abs(dArray[n][n4]) > Math.abs(d3))) continue;
                    d3 = dArray[n][n4];
                    nArray[n2] = n;
                    nArray2[n2] = n4;
                }
            }
            if (d3 == 0.0) {
                throw new IndeterminateMatrix();
            }
            n = nArray[n2];
            if (n2 > n) {
                throw new MatrixBug();
            }
            if (n > n2) {
                for (n4 = 0; n4 < n3; ++n4) {
                    d2 = dArray[n2][n4];
                    dArray[n2][n4] = dArray[n][n4];
                    dArray[n][n4] = -d2;
                }
            }
            if (n2 > (n = nArray2[n2])) {
                throw new MatrixBug();
            }
            if (n > n2) {
                for (n4 = 0; n4 < n3; ++n4) {
                    d2 = dArray[n4][n2];
                    dArray[n4][n2] = dArray[n4][n];
                    dArray[n4][n] = -d2;
                }
            }
            for (n = 0; n < n3; ++n) {
                if (n == n2) continue;
                dArray[n][n2] = -dArray[n][n2] / d3;
            }
            for (n = 0; n < n3; ++n) {
                if (n == n2) continue;
                for (n4 = 0; n4 < n3; ++n4) {
                    if (n4 == n2) continue;
                    double[] dArray2 = dArray[n];
                    int n5 = n4;
                    dArray2[n5] = dArray2[n5] + dArray[n][n2] * dArray[n2][n4];
                }
            }
            for (n = 0; n < n3; ++n) {
                if (n == n2) continue;
                dArray[n2][n] = dArray[n2][n] / d3;
            }
            dArray[n2][n2] = 1.0 / d3;
            d *= d3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = n3 - n2 - 1;
            int n7 = nArray[n6];
            if (n7 > n6) {
                for (n = 0; n < n3; ++n) {
                    double d4 = dArray[n][n6];
                    dArray[n][n6] = -dArray[n][n7];
                    dArray[n][n7] = d4;
                }
            }
            if ((n7 = nArray2[n6]) <= n6) continue;
            for (n = 0; n < n3; ++n) {
                double d5 = dArray[n6][n];
                dArray[n6][n] = -dArray[n7][n];
                dArray[n7][n] = d5;
            }
        }
        return d;
    }
}

