/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.DateTransformationConverter;
import jas.hist.FunctionValueUndefined;
import jas.hist.JASHist1DFunctionData;
import jas.hist.JASHist1DFunctionStyle;
import jas.hist.OverlayWithHandles;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.MutableLegendEntry;
import jas.plot.PlotGraphics;
import jas.plot.Transformation;
import java.awt.BasicStroke;

class JASHistFunctionOverlay
extends OverlayWithHandles
implements MutableLegendEntry {
    private static final float[][] lineStyles = new float[][]{null, {1.0f, 5.0f}, {4.0f, 6.0f}, {6.0f, 4.0f, 2.0f, 4.0f}};
    private JASHist1DFunctionStyle style;
    private JASHist1DFunctionData source;
    private double xmin;
    private double xmax;

    JASHistFunctionOverlay(JASHist1DFunctionData jASHist1DFunctionData, JASHist1DFunctionStyle jASHist1DFunctionStyle) {
        super(jASHist1DFunctionData.getDataSource());
        this.source = jASHist1DFunctionData;
        this.style = jASHist1DFunctionStyle;
    }

    void setXRange(double d, double d2) {
        this.xmin = d;
        this.xmax = d2;
    }

    public void paint(PlotGraphics plotGraphics, boolean bl) {
        CoordinateTransformation coordinateTransformation = this.container.getXTransformation();
        CoordinateTransformation coordinateTransformation2 = this.container.getYTransformation(this.source.getYAxis());
        Basic1DFunction basic1DFunction = (Basic1DFunction)this.source.getDataSource();
        Transformation transformation = null;
        Transformation transformation2 = null;
        if (coordinateTransformation instanceof DoubleCoordinateTransformation) {
            transformation = (Transformation)((Object)coordinateTransformation);
        }
        if (coordinateTransformation instanceof DateCoordinateTransformation) {
            transformation = new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation);
        }
        if (coordinateTransformation2 instanceof DoubleCoordinateTransformation) {
            transformation2 = (Transformation)((Object)coordinateTransformation2);
        }
        if (coordinateTransformation2 instanceof DateCoordinateTransformation) {
            transformation2 = new DateTransformationConverter((DateCoordinateTransformation)coordinateTransformation2);
        }
        if (transformation != null && transformation2 != null) {
            plotGraphics.setTransformation(transformation, transformation2);
            double d = (this.xmax - this.xmin) / (transformation.convert(this.xmax) - transformation.convert(this.xmin));
            double d2 = Double.NEGATIVE_INFINITY;
            plotGraphics.setColor(this.style.getLineColor());
            BasicStroke basicStroke = new BasicStroke(this.style.getLineWidth(), 2, 1, 10.0f, lineStyles[this.style.getLineStyle()], 0.0f);
            plotGraphics.setStroke(basicStroke);
            int n = 0;
            for (double d3 = this.xmin; d3 < this.xmax; d3 += d) {
                ++n;
            }
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            int n2 = 0;
            for (double d4 = this.xmin; d4 < this.xmax; d4 += d) {
                try {
                    double d5;
                    dArray[n2] = d4;
                    dArray2[n2] = d5 = basic1DFunction.valueAt(d4);
                    d2 = d5;
                }
                catch (FunctionValueUndefined functionValueUndefined) {
                    dArray2[n2] = d2;
                }
                ++n2;
            }
            plotGraphics.drawPolyLine(dArray, dArray2, n);
            plotGraphics.setStroke(null);
            super.paint(plotGraphics);
        }
    }

    public boolean titleIsChanged() {
        return this.source.isLegendChanged();
    }

    public void setTitle(String string) {
        this.source.setLegendText(string);
    }

    public String getTitle() {
        return this.source.getLegendText();
    }

    public void paintIcon(PlotGraphics plotGraphics, int n, int n2) {
        plotGraphics.setColor(this.style.getLineColor());
        BasicStroke basicStroke = new BasicStroke(this.style.getLineWidth(), 2, 1, 10.0f, lineStyles[this.style.getLineStyle()], 0.0f);
        plotGraphics.setStroke(basicStroke);
        plotGraphics.drawLine(1.0, n2 / 2, n - 2, n2 / 2);
        plotGraphics.setStroke(null);
    }
}

