/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

public abstract class AbstractStyleParameter {
    private String name;
    private String defaultValue;
    private String currentValue = null;
    private String[] noOptions = new String[0];
    private String[] possibleValues = null;

    AbstractStyleParameter(String name, String defaultValue) {
        this(name, defaultValue, null);
    }

    AbstractStyleParameter(String name, String defaultValue, String[] possibleValues) {
        this.name = name;
        this.setDefaultValue(defaultValue);
        this.possibleValues = possibleValues;
    }

    protected String name() {
        return this.name;
    }

    protected void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected boolean hasAllowedValues() {
        return this.possibleValues != null;
    }

    protected String[] allowedValues() {
        if (this.hasAllowedValues()) {
            return this.possibleValues;
        }
        return this.noOptions;
    }

    protected boolean isParameterValueSet() {
        return this.currentValue != null;
    }

    protected String parameterValue() {
        String parValue = this.isParameterValueSet() ? this.currentValue : this.defaultValue();
        if (!this.hasAllowedValues() || parValue == null) {
            return parValue;
        }
        try {
            int index = Integer.parseInt(parValue);
            if (index >= this.allowedValues().length) {
                return parValue;
            }
            return this.allowedValues()[index];
        }
        catch (NumberFormatException nfe) {
            return parValue;
        }
    }

    protected String defaultValue() {
        return this.defaultValue;
    }

    protected void reset() {
        this.currentValue = null;
    }

    protected boolean setParameter() {
        this.reset();
        return true;
    }

    protected boolean setParameter(String parValue) {
        this.currentValue = parValue;
        return this.isValueAllowed(parValue);
    }

    protected boolean isCurrentValueAllowed() {
        return this.checkValue(this.parameterValue());
    }

    protected boolean isValueAllowed(String val) {
        return this.checkValue(val);
    }

    private boolean checkValue(String val) {
        if (val == null) {
            return !this.hasAllowedValues();
        }
        if (!this.hasAllowedValues()) {
            return true;
        }
        String[] allowedValues = this.allowedValues();
        for (int i = 0; i < allowedValues.length; ++i) {
            if (!val.equals(allowedValues[i])) continue;
            return true;
        }
        try {
            int index = Integer.parseInt(val);
            return index >= 0 && index < allowedValues.length;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public abstract Class type();
}

