/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.CommandProcessor;
import jas.util.CommandSource;
import jas.util.CommandTarget;
import java.util.Enumeration;
import java.util.Observer;
import java.util.Vector;

public final class CommandTargetManager {
    private boolean started = false;
    private final Vector processors = new Vector();
    private final Vector sources = new Vector();

    public synchronized void add(CommandProcessor commandProcessor) {
        this.processors.addElement(commandProcessor);
        if (this.started) {
            Enumeration enumeration = this.sources.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                CommandTarget commandTarget;
                CommandSource commandSource = (CommandSource)enumeration.nextElement();
                if (commandSource.getTarget() != null || (commandTarget = commandProcessor.acceptCommand(string = commandSource.getCommand())) == null || !commandSource.setTarget(commandTarget) || !(commandSource instanceof Observer)) continue;
                commandProcessor.addObserver((Observer)((Object)commandSource));
            }
        }
        commandProcessor.setManager(this);
    }

    public synchronized void remove(CommandProcessor commandProcessor) {
        this.processors.removeElement(commandProcessor);
        if (this.started) {
            Enumeration enumeration = this.sources.elements();
            while (enumeration.hasMoreElements()) {
                CommandSource commandSource = (CommandSource)enumeration.nextElement();
                CommandTarget commandTarget = commandSource.getTarget();
                if (commandTarget == null || commandTarget.getProcessor() != commandProcessor) continue;
                commandSource.clearTarget();
                if (!(commandSource instanceof Observer)) continue;
                commandProcessor.deleteObserver((Observer)((Object)commandSource));
            }
        }
        commandProcessor.setManager(null);
    }

    public synchronized void add(CommandSource commandSource) {
        this.sources.addElement(commandSource);
        if (this.started) {
            this.linkCommandSource(commandSource);
        }
    }

    public synchronized void remove(CommandSource commandSource) {
        this.sources.removeElement(commandSource);
        String string = commandSource.getCommand();
        Enumeration enumeration = this.processors.elements();
        while (enumeration.hasMoreElements()) {
            CommandProcessor commandProcessor = (CommandProcessor)enumeration.nextElement();
            CommandTarget commandTarget = commandProcessor.acceptCommand(string);
            if (commandTarget == null) continue;
            commandSource.clearTarget();
            if (!(commandSource instanceof Observer)) continue;
            commandProcessor.deleteObserver((Observer)((Object)commandSource));
        }
    }

    public synchronized void start() {
        this.started = true;
        Enumeration enumeration = this.sources.elements();
        while (enumeration.hasMoreElements()) {
            this.linkCommandSource((CommandSource)enumeration.nextElement());
        }
    }

    private void linkCommandSource(CommandSource commandSource) {
        String string = commandSource.getCommand();
        Enumeration enumeration = this.processors.elements();
        while (enumeration.hasMoreElements()) {
            CommandProcessor commandProcessor = (CommandProcessor)enumeration.nextElement();
            CommandTarget commandTarget = commandProcessor.acceptCommand(string);
            if (commandTarget == null || !commandSource.setTarget(commandTarget) || !(commandSource instanceof Observer)) continue;
            commandProcessor.addObserver((Observer)((Object)commandSource));
        }
    }
}

