/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.settings.PropertyPanel;
import org.apache.log4j.Logger;

public class Utils {
    private static Logger logger = Logger.getLogger((String)Utils.class.getName());

    protected void Utils() {
    }

    public static boolean getBool(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().equalsIgnoreCase("on") || str.trim().equalsIgnoreCase("yes") || str.trim().equalsIgnoreCase("1") || str.trim().equalsIgnoreCase("true");
    }

    public static String firstLetterCaps(String input) {
        if (input == null) {
            return input;
        }
        String ret = input;
        char[] ch = input.toCharArray();
        if (ch != null && ch.length != 0) {
            ch[0] = Character.toUpperCase(ch[0]);
            ret = new String(ch, 0, ch.length);
        }
        return ret;
    }

    private static String getPath(String pathName) {
        int i;
        String FS = System.getProperty("file.separator");
        Vector<String> pathVector = new Vector<String>();
        StringTokenizer st = new StringTokenizer(pathName, FS);
        while (st.hasMoreTokens()) {
            pathVector.addElement(st.nextToken());
        }
        String path = new String();
        Vector<String> newPathVector = new Vector<String>();
        String replaceString = "\\\\ ";
        for (i = 0; i < pathVector.size(); ++i) {
            path = (String)pathVector.get(i);
            String newPath = path.replaceAll("\\s", replaceString);
            newPathVector.addElement(newPath);
        }
        path = new String();
        for (i = 0; i < newPathVector.size(); ++i) {
            path = path + FS + (String)newPathVector.get(i);
        }
        return path;
    }

    public static String getPathDQ(String pathName) {
        String osName = ConstParameters.osName;
        String ret = new String();
        ret = osName.toLowerCase().trim().startsWith("windows") ? "\"" + pathName + "\"" : Utils.getPath(pathName);
        return ret;
    }

    public static String stripDQ(String path) {
        return path.trim().replaceAll("\"", "");
    }

    public static String stripSQ(String path) {
        return path.trim().replaceAll("'", "");
    }

    public static boolean stop(Object object) {
        boolean stopped = false;
        if (object instanceof JTable) {
            TableCellEditor editor = ((JTable)object).getCellEditor();
            try {
                editor.stopCellEditing();
                stopped = true;
            }
            catch (Exception exc) {
                stopped = false;
            }
        }
        return stopped;
    }

    public static boolean isNumber(String str) {
        boolean ret = true;
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (Character.isDigit(ch[i])) continue;
            ret = false;
        }
        return ret;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Utils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void clearTableModel(TableModel model) {
        int i;
        TableModelListener[] listeners = ((AbstractTableModel)model).getTableModelListeners();
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            model.removeTableModelListener(listeners[i2]);
        }
        int row = model.getRowCount();
        int column = model.getColumnCount();
        logger.debug((Object)("clearing row, column: " + row + " " + column));
        for (i = 0; i < row; ++i) {
            for (int j = 0; j < column; ++j) {
                model.setValueAt("", i, j);
            }
        }
        for (i = 0; i < listeners.length; ++i) {
            model.addTableModelListener(listeners[i]);
        }
    }

    public static void bootPropertyPanel() {
        PropertyPanel pp = new PropertyPanel();
    }

    public static double getNorm(double[] v) {
        double norm = 0.0;
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                norm += v[i] * v[i];
            }
        }
        return Math.sqrt(norm);
    }

    public static void normalize(double[] v) {
        if (v == null) {
            // empty if block
        }
        double norm = Utils.getNorm(v);
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] / norm;
        }
    }

    public static void main(String[] args) {
        System.out.println("original path: " + args[0]);
        System.out.println("parsed path: " + Utils.getPath(args[0]));
    }
}

