/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements;

import jp.advancesoft.chase.acviewer.ACVDataManager;
import jp.advancesoft.chase.acviewer.ConfigDataManager;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.AxisObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.BGObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.CellObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.LegendObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.LightObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.MeasureObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.SceneGraphElement;
import jp.advancesoft.chase.acviewer.scenegraphelements.SceneGraphElementBG;
import jp.advancesoft.chase.acviewer.scenegraphelements.TGAtom;
import jp.advancesoft.chase.acviewer.scenegraphelements.bond.BondObject;
import org.apache.log4j.Logger;

public class SceneGraphElementCreator {
    private static Logger logger = Logger.getLogger((String)SceneGraphElementCreator.class.getName());
    private ConfigDataManager mCD;
    private ACVDataManager mACVD;
    private TGAtom tgatom;

    public SceneGraphElementCreator(ACVDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
    }

    public void setTGAtom(TGAtom tgatom) {
        this.tgatom = tgatom;
    }

    public SceneGraphElement getSceneGraphElement(String ID, int atomicNumber, double[] pos, int mobile, int weight) {
        logger.debug((Object)("pos: " + pos[0] + " " + pos[1] + " " + pos[2]));
        AtomObject element = new AtomObject(ID, atomicNumber, pos, mobile, weight);
        element.register(this.mCD, this.mACVD, this.tgatom);
        element.setAttributes();
        element.create();
        return element;
    }

    public SceneGraphElement getSceneGraphElement(String ID, int atomicNumber, double[] pos, double[] force, int mobile, int weight) {
        AtomObject element = new AtomObject(ID, atomicNumber, pos, force, mobile, weight);
        element.register(this.mCD, this.mACVD, this.tgatom);
        element.setAttributes();
        element.create();
        return element;
    }

    public SceneGraphElementBG getSceneGraphElement(double[] nearestNeighbor) {
        BondObject bond = new BondObject(nearestNeighbor);
        bond.setBondColor(this.mACVD.getBondColor());
        bond.setNumNodes(this.mACVD.getNumNodesBond());
        float scaleatom = 2.2f * this.mACVD.getScaleAtom() / (float)Math.pow(this.mCD.getNumAt(), 0.3333333432674408);
        double bondWidth = (double)scaleatom * this.mACVD.getBondWidth();
        bond.setBondWidth(bondWidth);
        bond.create();
        return bond;
    }

    public SceneGraphElement getSceneGraphElement(double[] cellOrigin, double[][] cellVec) {
        CellObject cell = new CellObject(cellOrigin, cellVec);
        cell.setCellColor(this.mACVD.getCellColor());
        cell.setNumNodes(this.mACVD.getNumNodesCell());
        cell.setCellWidth(this.mACVD.getCellWidth());
        cell.create();
        return cell;
    }

    public SceneGraphElement getSceneGraphElement(double[] atom1, double[] atom2, double result) {
        MeasureObject measure = new MeasureObject(atom1, atom2, result);
        measure.register(this.mCD, this.mACVD, this.tgatom);
        measure.create();
        return measure;
    }

    public SceneGraphElement getSceneGraphElement(double[] atom1, double[] atom2, double[] atom3, double result) {
        MeasureObject measure = new MeasureObject(atom1, atom2, atom3, result);
        measure.register(this.mCD, this.mACVD, this.tgatom);
        measure.create();
        return measure;
    }

    public SceneGraphElement getSceneGraphElement(double[] atom1, double[] atom2, double[] atom3, double[] atom4, double result) {
        MeasureObject measure = new MeasureObject(atom1, atom2, atom3, atom4, result);
        measure.register(this.mCD, this.mACVD, this.tgatom);
        measure.create();
        return measure;
    }

    public SceneGraphElement getSceneGraphElement(int sceneType) {
        SceneGraphElement ret = null;
        if (sceneType == 3) {
            ret = new AxisObject();
        } else if (sceneType == 4) {
            LegendObject lo = new LegendObject();
            lo.setNumAt(this.mCD.getNumAt());
            lo.setElements(this.mCD.getElements());
            lo.setNumEl(this.mACVD.getNumEl());
            lo.setElementAll(this.mACVD.getElement());
            lo.setColor(this.mACVD.getColor());
            lo.setNumNodes(this.mACVD.getNumNodesAtom());
            ret = lo;
        } else if (sceneType == 5) {
            BGObject bo = new BGObject();
            bo.setBgColor(this.mACVD.getBgColor());
            ret = bo;
        } else if (sceneType == 6) {
            ret = new LightObject();
        }
        if (ret != null) {
            ((SceneGraphElement)ret).create();
        }
        return ret;
    }

    public ConfigDataManager getConfigData() {
        return this.mCD;
    }

    public ACVDataManager getACVData() {
        return this.mACVD;
    }
}

