/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements;

import javax.media.j3d.Node;
import jp.advancesoft.chase.acviewer.scenegraphelements.Arc;
import jp.advancesoft.chase.acviewer.scenegraphelements.Line;
import jp.advancesoft.chase.acviewer.scenegraphelements.SceneGraphElement;
import jp.advancesoft.chase.acviewer.scenegraphelements.Word;
import jp.advancesoft.chase.common.ConstParameters;
import org.apache.log4j.Logger;

public class MeasureObject
extends SceneGraphElement {
    private static Logger logger = Logger.getLogger((String)MeasureObject.class.getName());
    public final int DISTANCE = 0;
    public final int ANGLE = 1;
    public final int DIHEDRAL = 2;
    private int measureType = 0;
    private double[][] xyz;
    private double result = 0.0;

    public MeasureObject(double[] atom1, double[] atom2) {
        this.measureType = 0;
        this.xyz = new double[2][3];
        this.xyz[0] = atom1;
        this.xyz[1] = atom2;
    }

    public MeasureObject(double[] atom1, double[] atom2, double result) {
        this.measureType = 0;
        this.xyz = new double[2][3];
        this.xyz[0] = atom1;
        this.xyz[1] = atom2;
        this.result = result;
    }

    public MeasureObject(double[] atom1, double[] atom2, double[] atom3, double result) {
        this.measureType = 1;
        this.xyz = new double[3][3];
        this.xyz[0] = atom1;
        this.xyz[1] = atom2;
        this.xyz[2] = atom3;
        this.result = result;
    }

    public MeasureObject(double[] atom1, double[] atom2, double[] atom3, double[] atom4, double result) {
        this.measureType = 2;
        this.xyz = new double[4][3];
        this.xyz[0] = atom1;
        this.xyz[1] = atom2;
        this.xyz[2] = atom3;
        this.xyz[3] = atom4;
        this.result = result;
    }

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean foo) {
    }

    public void setResult(double result) {
        this.result = result;
    }

    protected void create() {
        if (this.measureType == 0) {
            this.createDistanceObject();
        } else if (this.measureType == 1) {
            this.createAngleObject();
        } else if (this.measureType == 2) {
            this.createDihedObject();
        }
    }

    private void createDistanceObject() {
        double[] midpoint = new double[]{(this.xyz[0][0] + this.xyz[1][0]) * 0.5 - 0.1, (this.xyz[0][1] + this.xyz[1][1]) * 0.5, (this.xyz[0][2] + this.xyz[1][2]) * 0.5};
        this.addChild((Node)new Line(this.xyz[0], this.xyz[1]));
        this.addChild((Node)new Word(ConstParameters.formater_smaller_digits.format(this.result) + " \u212b", midpoint, this.mACVD.getFont()));
    }

    private void createAngleObject() {
        double[] a = new double[]{(this.xyz[0][0] + this.xyz[1][0]) * 0.5, (this.xyz[0][1] + this.xyz[1][1]) * 0.5, (this.xyz[0][2] + this.xyz[1][2]) * 0.5};
        double[] b = new double[]{(this.xyz[1][0] + this.xyz[2][0]) * 0.5, (this.xyz[1][1] + this.xyz[2][1]) * 0.5, (this.xyz[1][2] + this.xyz[2][2]) * 0.5};
        double[] midpoint = new double[]{(this.xyz[0][0] + this.xyz[2][0]) * 0.5 - 0.1, (this.xyz[0][1] + this.xyz[2][1]) * 0.5, (this.xyz[0][2] + this.xyz[2][2]) * 0.5};
        this.addChild((Node)new Arc(this.xyz[0], this.xyz[2], this.xyz[1]));
        this.addChild((Node)new Word(ConstParameters.formater_smaller_digits.format(this.result) + " \u00b0", midpoint, this.mACVD.getFont()));
    }

    private void createDihedObject() {
        double[] a = new double[]{(this.xyz[0][0] + this.xyz[1][0] + this.xyz[2][0]) / 3.0, (this.xyz[0][1] + this.xyz[1][1] + this.xyz[2][1]) / 3.0, (this.xyz[0][2] + this.xyz[1][2] + this.xyz[2][2]) / 3.0};
        double[] b = new double[]{(this.xyz[1][0] + this.xyz[2][0] + this.xyz[3][0]) / 3.0, (this.xyz[1][1] + this.xyz[2][1] + this.xyz[3][1]) / 3.0, (this.xyz[1][2] + this.xyz[2][2] + this.xyz[3][2]) / 3.0};
        double[] c = new double[]{(this.xyz[1][0] + this.xyz[2][0]) * 0.5, (this.xyz[1][1] + this.xyz[2][1]) * 0.5, (this.xyz[1][2] + this.xyz[2][2]) * 0.5};
        double[] pos = new double[]{(a[0] + b[0]) * 0.5 - 0.1, (a[1] + b[1]) * 0.5, (a[2] + b[2]) * 0.5};
        this.addChild((Node)new Arc(a, b, c));
        this.addChild((Node)new Word(ConstParameters.formater_smaller_digits.format(this.result) + " \u00b0", pos, this.mACVD.getFont()));
    }

    public int getMeasureType() {
        return this.measureType;
    }

    public int getType() {
        return 7;
    }
}

