/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.python.compiler.Module;
import org.python.core.BytecodeLoader;
import org.python.core.FileUtil;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.SyspathArchive;
import org.python.core.SyspathJavaLoader;
import org.python.core.__builtin__;
import org.python.core.parser;
import org.python.parser.ast.modType;

public class imp {
    public static final int APIVersion = 12;
    private static Object syspathJavaLoaderLock = new Object();
    private static ClassLoader syspathJavaLoader = null;
    private static PyTuple all = null;
    static /* synthetic */ Class class$org$python$core$PyRunnable;
    static /* synthetic */ Class class$org$python$core$PyObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSyspathJavaLoader() {
        Object object = syspathJavaLoaderLock;
        synchronized (object) {
            if (syspathJavaLoader == null) {
                syspathJavaLoader = new SyspathJavaLoader();
            }
        }
        return syspathJavaLoader;
    }

    private imp() {
    }

    public static PyModule addModule(String name) {
        PyObject modules = Py.getSystemState().modules;
        PyModule module = (PyModule)modules.__finditem__(name = name.intern());
        if (module != null) {
            return module;
        }
        module = new PyModule(name, null);
        modules.__setitem__(name, (PyObject)module);
        return module;
    }

    private static byte[] readBytes(InputStream fp) {
        try {
            byte[] buf = FileUtil.readBytes(fp);
            fp.close();
            return buf;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    private static InputStream makeStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    static PyObject createFromPyClass(String name, InputStream fp, boolean testing, String fileName) {
        PyCode code;
        int n;
        byte[] data = imp.readBytes(fp);
        int api = (data[(n = data.length) - 4] << 24) + (data[n - 3] << 16) + (data[n - 2] << 8) + data[n - 1];
        if (api != 12) {
            if (testing) {
                return null;
            }
            throw Py.ImportError("invalid api version(" + api + " != " + 12 + ") in: " + name);
        }
        try {
            code = BytecodeLoader.makeCode(name + "$py", data);
        }
        catch (Throwable t) {
            if (testing) {
                return null;
            }
            throw Py.JavaError(t);
        }
        Py.writeComment("import", "'" + name + "' as " + fileName);
        return imp.createFromCode(name, code);
    }

    public static byte[] compileSource(String name, File file) {
        return imp.compileSource(name, file, null, null);
    }

    public static byte[] compileSource(String name, File file, String filename, String outFilename) {
        if (filename == null) {
            filename = file.toString();
        }
        if (outFilename == null) {
            outFilename = filename.substring(0, filename.length() - 3) + "$py.class";
        }
        return imp.compileSource(name, imp.makeStream(file), filename, outFilename);
    }

    static byte[] compileSource(String name, InputStream fp, String filename) {
        String outFilename = null;
        if (filename != null) {
            outFilename = filename.substring(0, filename.length() - 3) + "$py.class";
        }
        return imp.compileSource(name, fp, filename, outFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] compileSource(String name, InputStream fp, String filename, String outFilename) {
        try {
            ByteArrayOutputStream ofp = new ByteArrayOutputStream();
            if (filename == null) {
                filename = "<unknown>";
            }
            modType node = null;
            try {
                node = parser.parse(fp, "exec", filename, null);
            }
            finally {
                fp.close();
            }
            Module.compile(node, ofp, name + "$py", filename, true, false, true, null);
            if (outFilename != null) {
                File classFile = new File(outFilename);
                try {
                    FileOutputStream fop = new FileOutputStream(classFile);
                    ofp.writeTo(fop);
                    fop.close();
                }
                catch (IOException exc) {
                    // empty catch block
                }
            }
            return ofp.toByteArray();
        }
        catch (Throwable t) {
            throw parser.fixParseError(null, t, filename);
        }
    }

    public static PyObject createFromSource(String name, InputStream fp, String filename) {
        byte[] bytes = imp.compileSource(name, fp, filename);
        Py.writeComment("import", "'" + name + "' as " + filename);
        PyCode code = BytecodeLoader.makeCode(name + "$py", bytes);
        return imp.createFromCode(name, code);
    }

    static PyObject createFromSource(String name, InputStream fp, String filename, String outFilename) {
        byte[] bytes = imp.compileSource(name, fp, filename, outFilename);
        Py.writeComment("import", "'" + name + "' as " + filename);
        PyCode code = BytecodeLoader.makeCode(name + "$py", bytes);
        return imp.createFromCode(name, code);
    }

    static PyObject createFromCode(String name, PyCode c) {
        PyModule module = imp.addModule(name);
        PyTableCode code = null;
        if (c instanceof PyTableCode) {
            code = (PyTableCode)c;
        }
        PyFrame f = new PyFrame(code, module.__dict__, module.__dict__, null);
        code.call(f);
        return module;
    }

    static PyObject createFromClass(String name, Class c) {
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] != (class$org$python$core$PyRunnable == null ? imp.class$("org.python.core.PyRunnable") : class$org$python$core$PyRunnable)) continue;
            try {
                PyObject o = imp.createFromCode(name, ((PyRunnable)c.newInstance()).getMain());
                return o;
            }
            catch (InstantiationException e) {
                throw Py.JavaError(e);
            }
            catch (IllegalAccessException e) {
                throw Py.JavaError(e);
            }
        }
        return PyJavaClass.lookup(c);
    }

    static PyObject getPathImporter(PyObject cache, PyList hooks, PyObject p) {
        PyObject hook;
        PyObject importer = cache.__finditem__(p);
        if (importer != null) {
            return importer;
        }
        PyObject iter = hooks.__iter__();
        while ((hook = iter.__iternext__()) != null) {
            try {
                importer = hook.__call__(p);
                break;
            }
            catch (PyException e) {
                if (Py.matchException(e, Py.ImportError)) continue;
                throw e;
            }
        }
        importer = importer == null ? Py.None : importer;
        cache.__setitem__(p, importer);
        return importer;
    }

    static PyObject replacePathItem(PyObject path) {
        if (path instanceof SyspathArchive) {
            return null;
        }
        try {
            return new SyspathArchive(path.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    static PyObject find_module(String name, String moduleName, PyList path) {
        PyObject importer;
        PyObject loader = Py.None;
        PySystemState sys = Py.getSystemState();
        PyList metaPath = sys.meta_path;
        PyList ppath = path == null ? sys.path : path;
        for (int i = 0; i < ppath.__len__(); ++i) {
            PyObject p = ppath.__getitem__(i);
            PyObject q = imp.replacePathItem(p);
            if (q == null) continue;
            ppath.__setitem__(i, q);
        }
        PyObject iter = ((PyObject)metaPath).__iter__();
        while ((importer = iter.__iternext__()) != null) {
            PyObject findModule = importer.__getattr__("find_module");
            PyObject[] pyObjectArray = new PyObject[2];
            pyObjectArray[0] = new PyString(moduleName);
            PyObject pyObject = pyObjectArray[1] = path == null ? Py.None : path;
            loader = findModule.__call__(pyObjectArray);
            if (loader == Py.None) continue;
            return imp.loadFromLoader(loader, moduleName);
        }
        PyObject ret = imp.loadBuiltin(moduleName);
        if (ret != null) {
            return ret;
        }
        path = path == null ? sys.path : path;
        for (int i = 0; i < path.__len__(); ++i) {
            PyObject findModule;
            PyObject p = path.__getitem__(i);
            PyObject importer2 = imp.getPathImporter(sys.path_importer_cache, sys.path_hooks, p);
            if (importer2 != Py.None && (loader = (findModule = importer2.__getattr__("find_module")).__call__(new PyObject[]{new PyString(moduleName)})) != Py.None) {
                return imp.loadFromLoader(loader, moduleName);
            }
            ret = imp.loadFromSource(name, moduleName, p);
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    private static PyObject loadBuiltin(String name) {
        Class c;
        if (name == "sys") {
            Py.writeComment("import", "'" + name + "' as sys in " + "builtin modules");
            return Py.java2py(Py.getSystemState());
        }
        String mod = PySystemState.getBuiltin(name);
        if (mod != null && (c = Py.findClassEx(mod, "builtin modules")) != null) {
            Py.writeComment("import", "'" + name + "' as " + mod + " in builtin modules");
            try {
                if ((class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = imp.class$("org.python.core.PyObject")) : class$org$python$core$PyObject).isAssignableFrom(c)) {
                    return PyType.fromClass(c);
                }
                return imp.createFromClass(name, c);
            }
            catch (NoClassDefFoundError e) {
                throw Py.ImportError("Cannot import " + name + ", missing class " + c.getName());
            }
        }
        return null;
    }

    static PyObject loadFromLoader(PyObject importer, String name) {
        PyObject load_module = importer.__getattr__("load_module");
        return load_module.__call__(new PyObject[]{new PyString(name)});
    }

    public static PyObject loadFromSource(String name, InputStream stream, String filename) {
        return imp.createFromSource(name, stream, filename);
    }

    public static PyObject loadFromCompiled(String name, InputStream stream, String filename) {
        return imp.createFromPyClass(name, stream, false, filename);
    }

    static PyObject loadFromSource(String name, String modName, PyObject entry) {
        boolean pkg;
        int nlen = name.length();
        String sourceName = "__init__.py";
        String compiledName = "__init__$py.class";
        String directoryName = entry.toString();
        if (directoryName.length() == 0) {
            directoryName = null;
        }
        File dir = new File(directoryName, name);
        File sourceFile = new File(dir, sourceName);
        File compiledFile = new File(dir, compiledName);
        boolean bl = pkg = dir.isDirectory() && imp.caseok(dir, name, nlen) && (sourceFile.isFile() || compiledFile.isFile());
        if (!pkg) {
            Py.writeDebug("import", "trying source " + dir.getPath());
            sourceName = name + ".py";
            compiledName = name + "$py.class";
            sourceFile = new File(directoryName, sourceName);
            compiledFile = new File(directoryName, compiledName);
        } else {
            PyModule m = imp.addModule(modName);
            PyString filename = new PyString(dir.getPath());
            m.__dict__.__setitem__("__path__", (PyObject)new PyList(new PyObject[]{filename}));
            m.__dict__.__setitem__("__file__", (PyObject)filename);
        }
        if (sourceFile.isFile() && imp.caseok(sourceFile, sourceName, nlen)) {
            if (compiledFile.isFile() && imp.caseok(compiledFile, compiledName, nlen)) {
                PyObject ret;
                Py.writeDebug("import", "trying precompiled " + compiledFile.getPath());
                long pyTime = sourceFile.lastModified();
                long classTime = compiledFile.lastModified();
                if (classTime >= pyTime && (ret = imp.createFromPyClass(modName, imp.makeStream(compiledFile), true, compiledFile.getPath())) != null) {
                    return ret;
                }
            }
            return imp.createFromSource(modName, imp.makeStream(sourceFile), sourceFile.getAbsolutePath());
        }
        Py.writeDebug("import", "trying " + compiledFile.getPath());
        if (compiledFile.isFile() && imp.caseok(compiledFile, compiledName, nlen)) {
            return imp.createFromPyClass(modName, imp.makeStream(compiledFile), false, compiledFile.getPath());
        }
        return null;
    }

    public static boolean caseok(File file, String filename, int namelen) {
        if (Options.caseok) {
            return true;
        }
        try {
            File canFile = new File(file.getCanonicalPath());
            return filename.regionMatches(0, canFile.getName(), 0, namelen);
        }
        catch (IOException exc) {
            return false;
        }
    }

    public static PyObject load(String name) {
        return imp.import_first(name, new StringBuffer());
    }

    private static String getParent(PyObject dict) {
        PyObject tmp = dict.__finditem__("__name__");
        if (tmp == null) {
            return null;
        }
        String name = tmp.toString();
        tmp = dict.__finditem__("__path__");
        if (tmp != null && tmp instanceof PyList) {
            return name.intern();
        }
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return name.substring(0, dot).intern();
    }

    private static PyObject import_next(PyObject mod, StringBuffer parentNameBuffer, String name) {
        if (parentNameBuffer.length() > 0) {
            parentNameBuffer.append('.');
        }
        parentNameBuffer.append(name);
        String fullName = parentNameBuffer.toString().intern();
        PyObject modules = Py.getSystemState().modules;
        PyObject ret = modules.__finditem__(fullName);
        if (ret != null) {
            return ret;
        }
        ret = mod == null ? imp.find_module(fullName.intern(), name, null) : mod.impAttr(name.intern());
        if (ret == null || ret == Py.None) {
            return ret;
        }
        if (modules.__finditem__(fullName) == null) {
            modules.__setitem__(fullName, ret);
        } else {
            ret = modules.__finditem__(fullName);
        }
        return ret;
    }

    private static PyObject import_first(String name, StringBuffer parentNameBuffer) {
        PyObject ret = imp.import_next(null, parentNameBuffer, name);
        if (ret == null || ret == Py.None) {
            throw Py.ImportError("no module named " + name);
        }
        return ret;
    }

    private static PyObject import_logic(PyObject mod, StringBuffer parentNameBuffer, String dottedName) {
        int dot = 0;
        int last_dot = 0;
        do {
            String name;
            if ((mod = imp.import_next(mod, parentNameBuffer, name = (dot = dottedName.indexOf(46, last_dot)) == -1 ? dottedName.substring(last_dot) : dottedName.substring(last_dot, dot))) == null || mod == Py.None) {
                throw Py.ImportError("No module named " + name);
            }
            last_dot = dot + 1;
        } while (dot != -1);
        return mod;
    }

    private static PyObject import_name(String name, boolean top, PyObject modDict) {
        int dot;
        String firstName;
        StringBuffer parentNameBuffer;
        PyObject topMod;
        if (name.length() == 0) {
            throw Py.ValueError("Empty module name");
        }
        PyObject modules = Py.getSystemState().modules;
        PyObject pkgMod = null;
        String pkgName = null;
        if (modDict != null && (pkgMod = modules.__finditem__(pkgName = imp.getParent(modDict))) != null && !(pkgMod instanceof PyModule)) {
            pkgMod = null;
        }
        if ((topMod = imp.import_next(pkgMod, parentNameBuffer = new StringBuffer(pkgMod != null ? pkgName : ""), firstName = (dot = name.indexOf(46)) == -1 ? name : name.substring(0, dot))) == Py.None || topMod == null) {
            if (topMod == null) {
                modules.__setitem__(parentNameBuffer.toString().intern(), Py.None);
            }
            parentNameBuffer = new StringBuffer("");
            topMod = imp.import_first(firstName, parentNameBuffer);
        }
        PyObject mod = topMod;
        if (dot != -1) {
            mod = imp.import_logic(topMod, parentNameBuffer, name.substring(dot + 1));
        }
        if (top) {
            return topMod;
        }
        return mod;
    }

    public static PyObject importName(String name, boolean top) {
        return imp.import_name(name, top, null);
    }

    public static synchronized PyObject importName(String name, boolean top, PyObject modDict) {
        return imp.import_name(name, top, modDict);
    }

    public static PyObject importOne(String mod, PyFrame frame) {
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getf_locals(), Py.EmptyTuple);
        return module;
    }

    public static PyObject importOneAs(String mod, PyFrame frame) {
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getf_locals(), imp.getStarArg());
        return module;
    }

    public static PyObject[] importFrom(String mod, String[] names, PyFrame frame) {
        return imp.importFromAs(mod, names, null, frame);
    }

    public static PyObject[] importFromAs(String mod, String[] names, String[] asnames, PyFrame frame) {
        PyObject[] pynames = new PyObject[names.length];
        for (int i = 0; i < names.length; ++i) {
            pynames[i] = Py.newString(names[i]);
        }
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getf_locals(), new PyTuple(pynames));
        PyObject[] submods = new PyObject[names.length];
        for (int i = 0; i < names.length; ++i) {
            PyObject submod = module.__findattr__(names[i]);
            if (submod == null) {
                throw Py.ImportError("cannot import name " + names[i]);
            }
            submods[i] = submod;
        }
        return submods;
    }

    private static synchronized PyTuple getStarArg() {
        if (all == null) {
            all = new PyTuple(new PyString[]{Py.newString('*')});
        }
        return all;
    }

    public static void importAll(String mod, PyFrame frame) {
        PyObject names;
        PyObject module = __builtin__.__import__(mod, frame.f_globals, frame.getf_locals(), imp.getStarArg());
        boolean filter = true;
        if (module instanceof PyJavaPackage) {
            names = ((PyJavaPackage)module).fillDir();
        } else {
            PyObject __all__ = module.__findattr__("__all__");
            if (__all__ != null) {
                names = __all__;
                filter = false;
            } else {
                names = module.__dir__();
            }
        }
        imp.loadNames(names, module, frame.getf_locals(), filter);
    }

    private static void loadNames(PyObject names, PyObject module, PyObject locals, boolean filter) {
        PyObject name;
        PyObject iter = names.__iter__();
        while ((name = iter.__iternext__()) != null) {
            String sname = ((PyString)name).internedString();
            if (filter && sname.startsWith("_")) continue;
            try {
                locals.__setitem__(sname, module.__getattr__(sname));
            }
            catch (Exception exc) {}
        }
    }

    static PyObject reload(PyJavaClass c) {
        return c;
    }

    static PyObject reload(PyModule m) {
        PyObject modules = Py.getSystemState().modules;
        String name = m.__getattr__("__name__").toString().intern();
        PyModule nm = (PyModule)modules.__finditem__(name);
        if (nm == null || !nm.__getattr__("__name__").toString().equals(name)) {
            throw Py.ImportError("reload(): module " + name + " not in sys.modules");
        }
        PyList path = Py.getSystemState().path;
        String modName = name;
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            String iname = name.substring(0, dot).intern();
            PyObject pkg = modules.__finditem__(iname);
            if (pkg == null) {
                throw Py.ImportError("reload(): parent not in sys.modules");
            }
            path = (PyList)pkg.__getattr__("__path__");
            name = name.substring(dot + 1, name.length()).intern();
        }
        nm.__setattr__("__name__", (PyObject)new PyString(modName));
        PyObject ret = imp.find_module(name, modName, path);
        modules.__setitem__(modName, ret);
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

