/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.date.SerialDate;

public class DateChooserPanel
extends JPanel
implements ActionListener {
    private Calendar chosenDate = null;
    private Color chosenDateButtonColor = Color.red;
    private Color chosenMonthButtonColor = Color.lightGray;
    private Color chosenOtherButtonColor = Color.darkGray;
    private int firstDayOfWeek = 1;
    private int yearSelectionRange = 20;
    private Font dateFont = new Font("SansSerif", 0, 10);
    private JComboBox monthSelector = null;
    private JComboBox yearSelector = null;
    private JButton todayButton = null;
    private JButton[] buttons = null;
    private boolean refreshing = false;

    public DateChooserPanel() {
        this(Calendar.getInstance(), false);
    }

    public DateChooserPanel(Calendar calendar, boolean controlPanel) {
        super(new BorderLayout());
        this.add((Component)this.constructSelectionPanel(), "North");
        this.add((Component)this.getCalendarPanel(), "Center");
        if (controlPanel) {
            this.add((Component)this.constructControlPanel(), "South");
        }
        this.chosenDate = calendar;
        this.setDate(calendar.getTime());
    }

    public void setDate(Date theDate) {
        this.chosenDate.setTime(theDate);
        this.monthSelector.setSelectedIndex(this.chosenDate.get(2));
        this.refreshYearSelector();
        this.refreshButtons();
    }

    public Date getDate() {
        return this.chosenDate.getTime();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("monthSelectionChanged")) {
            JComboBox c = (JComboBox)e.getSource();
            this.chosenDate.set(2, c.getSelectedIndex());
            this.refreshButtons();
        } else if (e.getActionCommand().equals("yearSelectionChanged")) {
            if (!this.refreshing) {
                JComboBox c = (JComboBox)e.getSource();
                Integer y = (Integer)c.getSelectedItem();
                this.chosenDate.set(1, y);
                this.refreshYearSelector();
                this.refreshButtons();
            }
        } else if (e.getActionCommand().equals("todayButtonClicked")) {
            this.setDate(new Date());
        } else if (e.getActionCommand().equals("dateButtonClicked")) {
            JButton b = (JButton)e.getSource();
            int i = Integer.parseInt(b.getName());
            Calendar cal = this.getFirstVisibleDate();
            cal.add(5, i);
            this.setDate(cal.getTime());
        }
    }

    private JPanel getCalendarPanel() {
        JPanel p = new JPanel(new GridLayout(7, 7));
        p.add(new JLabel("Sun", 0));
        p.add(new JLabel("Mon", 0));
        p.add(new JLabel("Tue", 0));
        p.add(new JLabel("Wed", 0));
        p.add(new JLabel("Thu", 0));
        p.add(new JLabel("Fri", 0));
        p.add(new JLabel("Sat", 0));
        this.buttons = new JButton[42];
        for (int i = 0; i < 42; ++i) {
            JButton b = new JButton("");
            b.setMargin(new Insets(1, 1, 1, 1));
            b.setName(new Integer(i).toString());
            b.setFont(this.dateFont);
            b.setFocusPainted(false);
            b.setActionCommand("dateButtonClicked");
            b.addActionListener(this);
            this.buttons[i] = b;
            p.add(b);
        }
        return p;
    }

    private Color getButtonColor(Calendar theDate) {
        if (this.equalDates(theDate, this.chosenDate)) {
            return this.chosenDateButtonColor;
        }
        if (theDate.get(2) == this.chosenDate.get(2)) {
            return this.chosenMonthButtonColor;
        }
        return this.chosenOtherButtonColor;
    }

    private boolean equalDates(Calendar c1, Calendar c2) {
        return c1.get(5) == c2.get(5) && c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }

    private Calendar getFirstVisibleDate() {
        Calendar c = Calendar.getInstance();
        c.set(this.chosenDate.get(1), this.chosenDate.get(2), 1);
        c.add(5, -1);
        while (c.get(7) != this.getFirstDayOfWeek()) {
            c.add(5, -1);
        }
        return c;
    }

    private int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    private void refreshButtons() {
        Calendar c = this.getFirstVisibleDate();
        for (int i = 0; i < 42; ++i) {
            JButton b = this.buttons[i];
            b.setText(new Integer(c.get(5)).toString());
            b.setBackground(this.getButtonColor(c));
            c.add(5, 1);
        }
    }

    private void refreshYearSelector() {
        if (!this.refreshing) {
            this.refreshing = true;
            this.yearSelector.removeAllItems();
            Vector v = this.getYears(this.chosenDate.get(1));
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                this.yearSelector.addItem(e.nextElement());
            }
            this.yearSelector.setSelectedItem(new Integer(this.chosenDate.get(1)));
            this.refreshing = false;
        }
    }

    private Vector getYears(int chosenYear) {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = chosenYear - this.yearSelectionRange; i <= chosenYear + this.yearSelectionRange; ++i) {
            v.addElement(new Integer(i));
        }
        return v;
    }

    private JPanel constructSelectionPanel() {
        JPanel p = new JPanel();
        this.monthSelector = new JComboBox<String>(SerialDate.getMonths());
        this.monthSelector.addActionListener(this);
        this.monthSelector.setActionCommand("monthSelectionChanged");
        p.add(this.monthSelector);
        this.yearSelector = new JComboBox(this.getYears(0));
        this.yearSelector.addActionListener(this);
        this.yearSelector.setActionCommand("yearSelectionChanged");
        p.add(this.yearSelector);
        return p;
    }

    private JPanel constructControlPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.todayButton = new JButton("Today");
        this.todayButton.addActionListener(this);
        this.todayButton.setActionCommand("todayButtonClicked");
        p.add(this.todayButton);
        return p;
    }
}

