/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.linux;

import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.KeyTracker;

public class LinuxEventDeviceTracker
implements WindowListener,
KeyTracker {
    private static final LinuxEventDeviceTracker ledt = new LinuxEventDeviceTracker();
    private WindowImpl focusedWindow = null;
    private final EventDeviceManager eventDeviceManager = new EventDeviceManager();
    private final EventDevicePoller[] eventDevicePollers = new EventDevicePoller[32];

    public static LinuxEventDeviceTracker getSingleton() {
        return ledt;
    }

    @Override
    public void windowResized(WindowEvent windowEvent) {
    }

    @Override
    public void windowMoved(WindowEvent windowEvent) {
    }

    @Override
    public void windowDestroyNotify(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (this.focusedWindow == object) {
            this.focusedWindow = null;
        }
    }

    @Override
    public void windowDestroyed(WindowEvent windowEvent) {
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object instanceof WindowImpl) {
            this.focusedWindow = (WindowImpl)object;
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (this.focusedWindow == object) {
            this.focusedWindow = null;
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("newt.debug.Window.KeyEvent", "true");
        LinuxEventDeviceTracker.getSingleton();
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
    }

    @Override
    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
    }

    static {
        InterruptSource.Thread thread = new InterruptSource.Thread(null, LinuxEventDeviceTracker.ledt.eventDeviceManager, "NEWT-LinuxEventDeviceManager");
        thread.setDaemon(true);
        thread.start();
    }

    class EventDevicePoller
    implements Runnable {
        private volatile boolean stop = false;
        private final String eventDeviceName;

        public EventDevicePoller(int n) {
            this.eventDeviceName = "/dev/input/event" + n;
        }

        @Override
        public void run() {
            FileInputStream fileInputStream;
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            StructAccessor structAccessor = new StructAccessor(byteBuffer);
            File file = new File(this.eventDeviceName);
            file.setReadOnly();
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.stop = true;
                return;
            }
            short s = 0;
            char c = ' ';
            short s2 = 0;
            int n = 0;
            block34: while (!this.stop) {
                int n2;
                for (int i = 16; i > 0; i -= n2) {
                    n2 = 0;
                    try {
                        n2 = ((InputStream)fileInputStream).read(byArray, 0, i);
                    }
                    catch (IOException iOException) {
                        this.stop = true;
                        break block34;
                    }
                    if (n2 >= 0) continue;
                    this.stop = true;
                    break block34;
                }
                int n3 = structAccessor.getIntAt(0);
                short s3 = structAccessor.getShortAt(4);
                short s4 = structAccessor.getShortAt(8);
                short s5 = structAccessor.getShortAt(10);
                int n4 = structAccessor.getIntAt(12);
                block3 : switch (s4) {
                    case 0: {
                        s2 = 0;
                        s = 0;
                        c = '\u0000';
                        if (!Window.DEBUG_KEY_EVENT) continue block34;
                        System.out.println("[SYN_REPORT----]");
                        break;
                    }
                    case 1: {
                        s = this.LinuxEVKey2NewtVKey(s5);
                        c = this.NewtVKey2Unicode(s, n);
                        if (Window.DEBUG_KEY_EVENT) {
                            System.out.println("[EV_KEY: [time " + n3 + ":" + s3 + "] type " + s4 + " / code " + s5 + " = value " + n4);
                        }
                        switch (n4) {
                            case 0: {
                                s2 = 301;
                                switch (s) {
                                    case 15: {
                                        n &= 0xFFFFFFFE;
                                        break;
                                    }
                                    case 18: {
                                        n &= 0xFFFFFFF7;
                                        break;
                                    }
                                    case 19: {
                                        n &= 0xFFFFFFEF;
                                        break;
                                    }
                                    case 17: {
                                        n &= 0xFFFFFFFD;
                                    }
                                }
                                if (null != LinuxEventDeviceTracker.this.focusedWindow) {
                                    LinuxEventDeviceTracker.this.focusedWindow.sendKeyEvent(s2, n, s, s, c);
                                }
                                if (!Window.DEBUG_KEY_EVENT) break;
                                System.out.println("[event released] keyCode: " + s + " keyChar: " + c + " modifiers: " + n);
                                break block3;
                            }
                            case 1: {
                                s2 = 300;
                                switch (s) {
                                    case 15: {
                                        n |= 1;
                                        break;
                                    }
                                    case 18: {
                                        n |= 8;
                                        break;
                                    }
                                    case 19: {
                                        n |= 0x10;
                                        break;
                                    }
                                    case 17: {
                                        n |= 2;
                                    }
                                }
                                if (null != LinuxEventDeviceTracker.this.focusedWindow) {
                                    LinuxEventDeviceTracker.this.focusedWindow.sendKeyEvent(s2, n, s, s, c);
                                }
                                if (!Window.DEBUG_KEY_EVENT) break;
                                System.out.println("[event pressed] keyCode: " + s + " keyChar: " + c + " modifiers: " + n);
                                break block3;
                            }
                            case 2: {
                                s2 = 300;
                                n |= 0x20000000;
                                switch (s) {
                                    case 15: {
                                        n |= 1;
                                        break;
                                    }
                                    case 18: {
                                        n |= 8;
                                        break;
                                    }
                                    case 19: {
                                        n |= 0x10;
                                        break;
                                    }
                                    case 17: {
                                        n |= 2;
                                    }
                                }
                                if (null != LinuxEventDeviceTracker.this.focusedWindow) {
                                    LinuxEventDeviceTracker.this.focusedWindow.sendKeyEvent((short)301, n, s, s, c);
                                    LinuxEventDeviceTracker.this.focusedWindow.sendKeyEvent(s2, n, s, s, c);
                                }
                                if (Window.DEBUG_KEY_EVENT) {
                                    System.out.println("[event released auto] keyCode: " + s + " keyChar: " + c + " modifiers: " + n);
                                    System.out.println("[event pressed auto] keyCode: " + s + " keyChar: " + c + " modifiers: " + n);
                                }
                                n &= 0xDFFFFFFF;
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (s5 != 4) continue block34;
                        break;
                    }
                    default: {
                        if (!Window.DEBUG_KEY_EVENT) continue block34;
                        System.out.println("TODO EventDevicePoller: [time " + n3 + ":" + s3 + "] type " + s4 + " / code " + s5 + " = value " + n4);
                    }
                }
            }
            if (null != fileInputStream) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.stop = true;
        }

        private char NewtVKey2Unicode(short s, int n) {
            if (KeyEvent.isPrintableKey(s, true)) {
                if ((n & 1) == 1) {
                    return (char)s;
                }
                return String.valueOf((char)s).toLowerCase().charAt(0);
            }
            return '\u0000';
        }

        private char LinuxEVKey2Unicode(short s) {
            switch (s) {
                case 17: {
                    return 'w';
                }
                case 31: {
                    return 's';
                }
                case 30: {
                    return 'a';
                }
                case 32: {
                    return 'd';
                }
                case 1: {
                    return '\u001b';
                }
                case 28: 
                case 96: {
                    return '\n';
                }
                case 57: {
                    return ' ';
                }
                case 11: 
                case 82: {
                    return '0';
                }
                case 2: 
                case 79: {
                    return '1';
                }
                case 3: 
                case 80: {
                    return '2';
                }
                case 4: 
                case 81: {
                    return '3';
                }
                case 5: 
                case 75: {
                    return '4';
                }
                case 6: 
                case 76: {
                    return '5';
                }
                case 7: 
                case 77: {
                    return '6';
                }
                case 8: 
                case 71: {
                    return '7';
                }
                case 9: 
                case 72: {
                    return '8';
                }
                case 10: 
                case 73: {
                    return '9';
                }
            }
            return '\u0000';
        }

        private short LinuxEVKey2NewtVKey(short s) {
            switch (s) {
                case 1: {
                    return 27;
                }
                case 2: {
                    return 49;
                }
                case 79: {
                    return 129;
                }
                case 3: {
                    return 50;
                }
                case 80: {
                    return 130;
                }
                case 4: {
                    return 51;
                }
                case 81: {
                    return 131;
                }
                case 5: {
                    return 52;
                }
                case 75: {
                    return 132;
                }
                case 6: {
                    return 53;
                }
                case 76: {
                    return 133;
                }
                case 7: {
                    return 54;
                }
                case 77: {
                    return 134;
                }
                case 8: {
                    return 55;
                }
                case 71: {
                    return 135;
                }
                case 9: {
                    return 56;
                }
                case 72: {
                    return 136;
                }
                case 10: {
                    return 57;
                }
                case 73: {
                    return 137;
                }
                case 11: {
                    return 48;
                }
                case 82: {
                    return 128;
                }
                case 12: {
                    return 45;
                }
                case 13: {
                    return 61;
                }
                case 14: {
                    return 8;
                }
                case 15: {
                    return 9;
                }
                case 16: {
                    return 81;
                }
                case 17: {
                    return 87;
                }
                case 18: {
                    return 69;
                }
                case 19: {
                    return 82;
                }
                case 20: {
                    return 84;
                }
                case 21: {
                    return 89;
                }
                case 22: {
                    return 85;
                }
                case 23: {
                    return 73;
                }
                case 24: {
                    return 79;
                }
                case 25: {
                    return 80;
                }
                case 26: {
                    return 40;
                }
                case 27: {
                    return 41;
                }
                case 28: 
                case 96: {
                    return 13;
                }
                case 29: {
                    return 17;
                }
                case 30: {
                    return 65;
                }
                case 31: {
                    return 83;
                }
                case 32: {
                    return 68;
                }
                case 33: {
                    return 70;
                }
                case 34: {
                    return 71;
                }
                case 35: {
                    return 72;
                }
                case 36: {
                    return 74;
                }
                case 37: {
                    return 75;
                }
                case 38: {
                    return 76;
                }
                case 39: {
                    return 59;
                }
                case 40: {
                    return 39;
                }
                case 41: {
                    return 96;
                }
                case 42: {
                    return 15;
                }
                case 43: {
                    return 92;
                }
                case 44: {
                    return 90;
                }
                case 45: {
                    return 88;
                }
                case 46: {
                    return 67;
                }
                case 47: {
                    return 86;
                }
                case 48: {
                    return 66;
                }
                case 49: {
                    return 78;
                }
                case 50: {
                    return 77;
                }
                case 51: {
                    return 44;
                }
                case 52: {
                    return 46;
                }
                case 53: {
                    return 47;
                }
                case 54: {
                    return 15;
                }
                case 55: {
                    return 42;
                }
                case 56: {
                    return 18;
                }
                case 57: {
                    return 32;
                }
                case 58: {
                    return 20;
                }
                case 59: {
                    return 97;
                }
                case 60: {
                    return 98;
                }
                case 61: {
                    return 99;
                }
                case 62: {
                    return 100;
                }
                case 63: {
                    return 101;
                }
                case 64: {
                    return 102;
                }
                case 65: {
                    return 103;
                }
                case 66: {
                    return 104;
                }
                case 67: {
                    return 105;
                }
                case 68: {
                    return 106;
                }
                case 69: {
                    return 148;
                }
                case 70: {
                    return 23;
                }
                case 74: {
                    return 45;
                }
                case 78: {
                    return 43;
                }
                case 83: {
                    return 46;
                }
                case 85: 
                case 86: {
                    break;
                }
                case 87: {
                    return 107;
                }
                case 88: {
                    return 108;
                }
                case 89: {
                    return -1902;
                }
                case 90: {
                    return -1898;
                }
                case 91: {
                    return -1897;
                }
                case 92: {
                    break;
                }
                case 93: {
                    break;
                }
                case 94: {
                    break;
                }
                case 95: {
                    break;
                }
                case 97: {
                    return 17;
                }
                case 98: {
                    return 47;
                }
                case 99: {
                    break;
                }
                case 100: {
                    return 18;
                }
                case 101: {
                    break;
                }
                case 102: {
                    return 2;
                }
                case 103: {
                    return 150;
                }
                case 104: {
                    return 16;
                }
                case 105: {
                    return 149;
                }
                case 106: {
                    return 151;
                }
                case 107: {
                    return 3;
                }
                case 108: {
                    return 152;
                }
                case 109: {
                    return 11;
                }
                case 110: {
                    return 26;
                }
                case 111: {
                    return 147;
                }
                case 112: {
                    break;
                }
                case 113: {
                    break;
                }
                case 114: {
                    break;
                }
                case 115: {
                    break;
                }
                case 116: {
                    break;
                }
                case 117: {
                    return 61;
                }
                case 118: {
                    break;
                }
                case 119: {
                    return 22;
                }
                case 120: {
                    break;
                }
                case 121: {
                    return 44;
                }
                case 122: {
                    break;
                }
                case 123: {
                    break;
                }
                case 124: {
                    break;
                }
                case 125: 
                case 126: {
                    return 155;
                }
                case 127: {
                    return 157;
                }
                case 128: {
                    return 159;
                }
                case 129: {
                    return -1923;
                }
                case 130: {
                    return -1921;
                }
                case 131: {
                    return -1924;
                }
                case 132: {
                    break;
                }
                case 133: {
                    return -1926;
                }
                case 134: {
                    break;
                }
                case 135: {
                    return -1925;
                }
                case 136: {
                    return -1922;
                }
                case 137: {
                    return -1927;
                }
                case 138: {
                    return 156;
                }
                case 139: {
                    break;
                }
                case 140: {
                    break;
                }
                case 141: {
                    break;
                }
                case 142: {
                    break;
                }
                case 143: {
                    break;
                }
                case 144: {
                    break;
                }
                case 145: {
                    break;
                }
                case 146: {
                    break;
                }
                case 147: {
                    break;
                }
                case 148: {
                    break;
                }
                case 149: {
                    break;
                }
                case 150: {
                    break;
                }
                case 151: {
                    break;
                }
                case 152: {
                    break;
                }
                case 153: {
                    break;
                }
                case 154: {
                    break;
                }
                case 155: {
                    break;
                }
                case 156: {
                    break;
                }
                case 157: {
                    break;
                }
                case 158: {
                    break;
                }
                case 159: {
                    break;
                }
                case 160: {
                    break;
                }
                case 161: {
                    break;
                }
                case 162: {
                    break;
                }
                case 163: {
                    break;
                }
                case 164: {
                    break;
                }
                case 165: {
                    break;
                }
                case 166: {
                    break;
                }
                case 167: {
                    break;
                }
                case 168: {
                    break;
                }
                case 169: {
                    break;
                }
                case 170: {
                    break;
                }
                case 171: {
                    break;
                }
                case 172: {
                    break;
                }
                case 173: {
                    break;
                }
                case 174: {
                    break;
                }
                case 175: {
                    break;
                }
                case 176: {
                    break;
                }
                case 177: {
                    break;
                }
                case 178: {
                    break;
                }
                case 179: {
                    return 40;
                }
                case 180: {
                    return 41;
                }
                case 181: {
                    break;
                }
                case 182: {
                    break;
                }
                case 183: {
                    return 109;
                }
                case 184: {
                    return 110;
                }
                case 185: {
                    return 111;
                }
                case 186: {
                    return 112;
                }
                case 187: {
                    return 113;
                }
                case 188: {
                    return 114;
                }
                case 189: {
                    return 115;
                }
                case 190: {
                    return 116;
                }
                case 191: {
                    return 117;
                }
                case 192: {
                    return 118;
                }
                case 193: {
                    return 119;
                }
                case 194: {
                    return 120;
                }
                case 200: {
                    break;
                }
                case 201: {
                    break;
                }
                case 202: {
                    break;
                }
                case 203: {
                    break;
                }
                case 204: {
                    break;
                }
                case 205: {
                    break;
                }
                case 206: {
                    break;
                }
                case 207: {
                    break;
                }
                case 208: {
                    break;
                }
                case 210: {
                    return 5;
                }
                case 211: {
                    break;
                }
                case 212: {
                    break;
                }
                case 213: {
                    break;
                }
                case 214: {
                    break;
                }
                case 215: {
                    break;
                }
                case 216: {
                    break;
                }
                case 217: {
                    break;
                }
                case 218: {
                    break;
                }
                case 219: {
                    break;
                }
                case 220: {
                    break;
                }
                case 221: {
                    break;
                }
                case 222: {
                    break;
                }
                case 223: {
                    break;
                }
                case 224: {
                    break;
                }
                case 225: {
                    break;
                }
                case 226: {
                    break;
                }
                case 227: {
                    break;
                }
                case 228: {
                    break;
                }
                case 229: {
                    break;
                }
                case 230: {
                    break;
                }
                case 231: {
                    break;
                }
                case 232: {
                    break;
                }
                case 233: {
                    break;
                }
                case 234: {
                    break;
                }
                case 235: {
                    break;
                }
                case 236: {
                    break;
                }
                case 237: {
                    break;
                }
                case 238: {
                    break;
                }
                case 239: {
                    break;
                }
                case 240: {
                    return 0;
                }
                case 241: {
                    break;
                }
                case 242: {
                    break;
                }
                case 243: {
                    break;
                }
                case 244: {
                    break;
                }
                case 245: {
                    break;
                }
                case 246: {
                    break;
                }
                case 247: {
                    break;
                }
                case 248: {
                    break;
                }
            }
            if (Window.DEBUG_KEY_EVENT) {
                System.out.println("TODO LinuxEVKey2NewtVKey: Unmapped EVKey " + s);
            }
            return 0;
        }
    }

    class EventDeviceManager
    implements Runnable {
        private volatile boolean stop = false;

        EventDeviceManager() {
        }

        @Override
        public void run() {
            File file = new File("/dev/input/");
            while (!this.stop) {
                for (String string : file.list()) {
                    String string2;
                    int n;
                    if (!string.startsWith("event") || (n = Integer.parseInt(string2 = string.substring(5))) >= 32 || n < 0) continue;
                    if (LinuxEventDeviceTracker.this.eventDevicePollers[n] == null) {
                        ((LinuxEventDeviceTracker)LinuxEventDeviceTracker.this).eventDevicePollers[n] = new EventDevicePoller(n);
                        InterruptSource.Thread thread = new InterruptSource.Thread(null, LinuxEventDeviceTracker.this.eventDevicePollers[n], "NEWT-LinuxEventDeviceTracker-event" + n);
                        thread.setDaemon(true);
                        thread.start();
                        continue;
                    }
                    if (!LinuxEventDeviceTracker.this.eventDevicePollers[n].stop) continue;
                    ((LinuxEventDeviceTracker)LinuxEventDeviceTracker.this).eventDevicePollers[n] = null;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

