/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.Vector;
import jp.advancesoft.chase.ssh.SessionCreator;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.sftp.Download;
import jp.advancesoft.chase.ssh.sftp.SftpListener;
import jp.advancesoft.chase.ssh.sftp.Upload;
import org.apache.log4j.Logger;

public class Sftp {
    private static Logger logger = Logger.getLogger((String)Sftp.class.getName());
    private HostInfo host;
    private ChannelSftp c;
    private Session session;
    private Channel channel;
    private Vector listeners = new Vector();

    public Sftp(HostInfo host) {
        this.host = host;
    }

    public void addSftpListener(SftpListener sl) {
        this.listeners.add(sl);
    }

    public void connect() {
        try {
            this.session = SessionCreator.getSession(this.host, 5000);
            this.session.setTimeout(0);
            this.channel = this.session.openChannel("sftp");
            this.channel.connect();
            this.c = (ChannelSftp)this.channel;
            logger.info((Object)("sftp connection to host: " + this.host.getName()));
            logger.debug((Object)("current directory: " + this.c.pwd()));
        }
        catch (Exception exc) {
            logger.error((Object)"failed connection");
        }
    }

    public void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    public Session getSession() {
        return this.session;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void lcd(String lcdpath) {
        if (this.c == null) {
            logger.info((Object)"not connected.");
            return;
        }
        try {
            this.c.lcd(lcdpath);
            logger.debug((Object)("changed local directory to: " + lcdpath));
        }
        catch (SftpException se) {
            logger.error((Object)"failed to change local directory");
        }
    }

    public void lcd(File file) {
        if (this.c == null) {
            logger.info((Object)"not connected.");
            return;
        }
        String lcdpath = file.getAbsolutePath();
        try {
            this.c.lcd(lcdpath);
            logger.debug((Object)("changed local directory to: " + lcdpath));
        }
        catch (SftpException se) {
            logger.error((Object)"failed to change local directory");
        }
    }

    public void cd(String cdpath) {
        if (this.c == null) {
            logger.info((Object)"not connected");
            return;
        }
        try {
            this.c.cd(cdpath);
            logger.debug((Object)("changed remote directory to: " + cdpath));
        }
        catch (SftpException se) {
            logger.error((Object)"failed to change remote directory");
        }
    }

    public void download(RemoteFile[] files, RemoteFile dir, boolean recursive) {
        if (this.c == null) {
            logger.info((Object)"not connected.");
            return;
        }
        dir.mkdirs();
        new Thread(new Download(files, dir, this.c, this.listeners, recursive)).start();
    }

    public void download(RemoteFile[] files, RemoteFile dir) {
        if (this.c == null) {
            logger.info((Object)"not connected.");
            return;
        }
        dir.mkdirs();
        new Thread(new Download(files, dir, this.c, this.listeners)).start();
    }

    public void upload(RemoteFile[] files, RemoteFile dir, boolean recursive) {
        if (this.c == null) {
            logger.info((Object)"not connected.");
            return;
        }
        dir.mkdirs();
        new Thread(new Upload(files, dir, this.c, this.listeners, recursive)).start();
        logger.debug((Object)("wd: " + this.c.pwd()));
    }

    public void upload(RemoteFile[] files, RemoteFile dir) {
        if (this.c == null) {
            logger.info((Object)"not connected.");
            return;
        }
        dir.mkdirs();
        new Thread(new Upload(files, dir, this.c, this.listeners)).start();
        logger.debug((Object)("wd: " + this.c.pwd()));
    }

    public void ls(File dir) {
        if (this.c == null) {
            logger.info((Object)"not connected.");
            return;
        }
        String path = ".";
        try {
            Vector lsvec = this.c.ls(path);
            if (lsvec != null) {
                for (int i = 0; i < lsvec.size(); ++i) {
                    logger.debug((Object)((String)lsvec.get(i)));
                }
            }
        }
        catch (SftpException se) {
            logger.error((Object)"failed to perform the \"ls\" command");
        }
    }

    public ChannelSftp getChannelSftp() {
        return this.c;
    }

    public void test() {
        if (this.c != null) {
            RemoteFile remote = new RemoteFile("", this.c);
            logger.debug((Object)("rem. file: " + remote));
            RemoteFile parent = (RemoteFile)remote.getParentFile();
            logger.debug((Object)("parent of rem: " + parent));
            remote.exists();
            parent.exists();
            RemoteFile[] files = (RemoteFile[])remote.listFiles();
            if (files != null) {
                logger.debug((Object)"list of files");
                for (int i = 0; i < files.length; ++i) {
                    logger.debug((Object)files[i]);
                }
            }
        }
    }
}

