/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.remotehostexecuter;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.remotehostexecuter.ChaseFileHolder;
import jp.advancesoft.chase.ssh.remotehostexecuter.FileTransferSchemeManager;
import jp.advancesoft.chase.ssh.sftp.Sftp;
import jp.advancesoft.chase.ssh.sftp.SftpEvent;
import jp.advancesoft.chase.ssh.sftp.SftpListener;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class BatchFileTransferer
implements SftpListener {
    private static Logger logger = Logger.getLogger((String)BatchFileTransferer.class.getName());
    private HostInfo hostinfo;
    private File xmlfile;
    private Document doc;
    private Element filetransferscheme;
    private ChaseFileHolder parent;
    private FileTransferSchemeManager manager;
    private String FS = System.getProperty("file.separator");
    private String targetdir;
    private String localdir;
    private Sftp sftp;
    private ChannelSftp c;
    private Vector regfiles = new Vector();
    private Vector listeners = new Vector();

    public BatchFileTransferer(String localdir, HostInfo hostinfo, ChaseFileHolder parent) {
        this.localdir = localdir;
        this.hostinfo = hostinfo;
        this.parent = parent;
        this.init();
    }

    public void registerFiles(String path) {
        this.regfiles.add(path);
    }

    public void uploadFinished(SftpEvent se) {
        logger.debug((Object)"finished upload.");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((SftpListener)this.listeners.elementAt(i)).uploadFinished(se);
        }
    }

    public void downloadFinished(SftpEvent se) {
        logger.debug((Object)"finished download.");
    }

    public void addSftpListener(SftpListener list) {
        this.listeners.addElement(list);
    }

    private void init() {
        this.filetransferscheme = null;
        this.xmlfile = new File(this.localdir + this.FS + "filetransferscheme.xml");
        if (this.xmlfile.exists()) {
            SAXBuilder builder = new SAXBuilder();
            try {
                this.doc = builder.build(this.xmlfile);
            }
            catch (JDOMException jde) {
                logger.error((Object)("failed to parse " + this.xmlfile));
            }
            catch (IOException ioe) {
                logger.error((Object)("failed to parse " + this.xmlfile));
            }
            this.filetransferscheme = FileTransferSchemeManager.getCorrespondingElement(this.doc, this.xmlfile, this.hostinfo, this.parent);
        }
        if (this.filetransferscheme == null) {
            this.filetransferscheme = this.defaultFileTransferScheme();
        }
        this.targetdir = this.filetransferscheme.getChild("targetdir").getTextTrim();
    }

    private Element defaultFileTransferScheme() {
        Element ret = null;
        FileTransferSchemeManager manager = new FileTransferSchemeManager(this.hostinfo, this.parent);
        ret = manager.createFileTransferElement(null);
        return ret;
    }

    public void setLocalDir(String localdir) {
        this.localdir = localdir;
        this.init();
    }

    public void setHostInfo(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
        this.init();
    }

    public String getTargetDir() {
        return this.targetdir;
    }

    public Session getSession() {
        if (this.sftp != null) {
            return this.sftp.getSession();
        }
        return null;
    }

    public boolean upload(File file) {
        RemoteFile[] rfs = new RemoteFile[]{new RemoteFile(file.getAbsolutePath())};
        this.sftp = new Sftp(this.hostinfo);
        this.sftp.addSftpListener(this);
        this.sftp.connect();
        this.c = this.sftp.getChannelSftp();
        this.sftp.upload(rfs, new RemoteFile(this.targetdir, this.c));
        return true;
    }

    public boolean upload() {
        this.parent.preProcess(1);
        if (this.filetransferscheme == null || this.hostinfo == null) {
            return false;
        }
        if (this.targetdir == null || this.targetdir.trim().equals("$HOME") || this.targetdir.trim().length() == 0) {
            this.targetdir = "";
        }
        logger.debug((Object)("uploading file to " + this.hostinfo.getName() + ", target dir: " + this.targetdir));
        RemoteFile[] rfs = this.getFilesFromElement("upload");
        if (rfs == null) {
            return false;
        }
        this.sftp.upload(rfs, new RemoteFile(this.targetdir, this.c));
        this.parent.postProcess(1);
        return true;
    }

    public boolean download() {
        this.parent.preProcess(0);
        if (this.filetransferscheme == null || this.hostinfo == null) {
            return false;
        }
        if (this.targetdir == null || this.targetdir.trim().equals("$HOME") || this.targetdir.trim().length() == 0) {
            this.targetdir = "";
        }
        logger.debug((Object)("downloading file to " + this.hostinfo.getName() + ", target dir: " + this.targetdir));
        RemoteFile[] rfs = this.getFilesFromElement("download");
        if (rfs == null) {
            return false;
        }
        this.sftp.download(rfs, new RemoteFile(this.localdir), false);
        this.parent.postProcess(0);
        return true;
    }

    private RemoteFile[] getFilesFromElement(String mode) {
        int i;
        List files = this.filetransferscheme.getChildren("file");
        int numfiles = files.size();
        this.sftp = new Sftp(this.hostinfo);
        this.sftp.addSftpListener(this);
        this.sftp.connect();
        this.c = this.sftp.getChannelSftp();
        Vector<RemoteFile> filevector = new Vector<RemoteFile>();
        ChannelSftp ctmp = null;
        if (mode.equals("download")) {
            ctmp = this.c;
        }
        for (i = 0; i < numfiles; ++i) {
            Element file = (Element)files.get(i);
            if (file == null) {
                logger.error((Object)"element is null!");
                return null;
            }
            String fname = "";
            try {
                fname = file.getChild("filename").getTextTrim();
            }
            catch (NullPointerException npe) {
                logger.error((Object)("parse error: " + this.filetransferscheme.getName()));
                return null;
            }
            boolean hasRegExp = new Boolean(file.getAttributeValue("hasregexp"));
            Vector fnamevec = new Vector();
            fnamevec.addElement(fname);
            if (hasRegExp) {
                fnamevec.clear();
                String strans = file.getChild("transfer").getTextTrim();
                if (strans.equals("NEWEST_ONLY")) {
                    fname = this.getFileNameFromRegExpEntry(this.targetdir, fname, this.c);
                    fnamevec.addElement(fname);
                } else if (strans.equals("ALL")) {
                    fnamevec = this.getFileNamesFromRegExpEntry(this.targetdir, fname, this.c);
                } else {
                    fnamevec.addElement(fname);
                }
            }
            if (fname.trim().length() == 0) continue;
            String filename = "";
            String fs = "";
            String dir = "";
            if (mode.equals("download")) {
                if (!this.targetdir.trim().endsWith("/")) {
                    fs = "/";
                }
                dir = this.targetdir + fs;
            } else {
                String loc = file.getChild("localdir").getTextTrim();
                if (!loc.endsWith(System.getProperty("file.separator"))) {
                    fs = System.getProperty("file.separator");
                }
                dir = loc + fs;
            }
            for (int j = 0; j < fnamevec.size(); ++j) {
                filename = dir + (String)fnamevec.elementAt(j);
                logger.debug((Object)("transfer file: " + filename));
                RemoteFile transfile = new RemoteFile(filename, ctmp);
                String tof = file.getChild(mode).getTextTrim();
                if (!tof.equals("true") || !transfile.exists()) continue;
                filevector.add(new RemoteFile(transfile.getAbsolutePath(), ctmp));
            }
        }
        for (i = 0; i < this.regfiles.size(); ++i) {
            filevector.add(new RemoteFile((String)this.regfiles.elementAt(i), ctmp));
        }
        RemoteFile[] rfs = null;
        if (filevector.size() != 0) {
            rfs = new RemoteFile[filevector.size()];
            for (int i2 = 0; i2 < rfs.length; ++i2) {
                rfs[i2] = (RemoteFile)filevector.elementAt(i2);
            }
        } else {
            logger.info((Object)"no file to transfer.");
        }
        return rfs;
    }

    private String getFileNameFromRegExpEntry(String target, String name, ChannelSftp c) {
        String ret = "";
        RemoteFile rf = new RemoteFile(target, c);
        RemoteFile[] rfs = (RemoteFile[])rf.listFiles();
        if (rfs == null || rfs.length == 0) {
            return ret;
        }
        long newest = 0L;
        boolean inew = false;
        for (int i = 0; i < rfs.length; ++i) {
            if (rfs[i].getName().matches(name)) {
                logger.debug((Object)("caught: " + rfs[i].getName()));
                long last = rfs[i].lastModified();
                if (last <= newest) continue;
                ret = rfs[i].getName();
                continue;
            }
            logger.debug((Object)(rfs[i].getName() + " does not match " + name + "."));
        }
        logger.debug((Object)("newest file: " + ret));
        return ret;
    }

    private Vector getFileNamesFromRegExpEntry(String target, String name, ChannelSftp c) {
        Vector<String> ret = new Vector<String>();
        RemoteFile rf = new RemoteFile(target, c);
        RemoteFile[] rfs = (RemoteFile[])rf.listFiles();
        if (rfs == null || rfs.length == 0) {
            return ret;
        }
        for (int i = 0; i < rfs.length; ++i) {
            if (rfs[i].getName().matches(name)) {
                logger.debug((Object)("caught: " + rfs[i].getName()));
                ret.addElement(rfs[i].getName());
                continue;
            }
            logger.debug((Object)(rfs[i].getName() + " does not match " + name + "."));
        }
        return ret;
    }
}

