/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.hosts;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.ssh.SshClient;
import jp.advancesoft.chase.ssh.hosts.ButtonListenerHostConfigurator;
import jp.advancesoft.chase.ssh.hosts.CaretListenerHostConfigurator;
import jp.advancesoft.chase.ssh.hosts.CheckBoxHostConfigurator;
import jp.advancesoft.chase.ssh.hosts.HostConfigButtons;
import jp.advancesoft.chase.ssh.hosts.HostConfigEditors;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.hosts.HostSelectorList;
import jp.advancesoft.chase.ssh.hosts.InputPanelHostConfigurator;
import jp.advancesoft.chase.ssh.hosts.JPasswordFieldHostConfigurator;
import jp.advancesoft.chase.ssh.hosts.PathSelectorHostConfigurator;
import jp.advancesoft.chase.ssh.sftp.SftpClient;
import jp.advancesoft.chase.ssh.terminal.Terminal;
import org.apache.log4j.Logger;

public class HostConfigurator
extends InternalFrameChase
implements ListSelectionListener,
SshClient {
    private static Logger logger = Logger.getLogger((String)HostConfigurator.class.getName());
    private HostSelectorList list;
    private JPasswordFieldHostConfigurator password;
    private CheckBoxHostConfigurator savepass;
    private JTabbedPane tab;
    private CaretListenerHostConfigurator caretListener;
    private ButtonListenerHostConfigurator btnlist;
    private HostInfo hostinfo;
    private Vector textfields = new Vector();
    private Vector buttons = new Vector();

    public HostConfigurator() {
        super("HostConfigurator", true, true, true, true, new Dimension(600, 360));
        this.init();
    }

    public void connect(HostInfo hostinfo) {
    }

    public void disconnect() {
    }

    public void setHostInfo(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    public HostInfo getHostInfo() {
        return this.list.getSelectedHost();
    }

    private void init() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 1));
        JScrollPane scrollpane = new JScrollPane();
        this.list = new HostSelectorList();
        this.caretListener = new CaretListenerHostConfigurator(this.list);
        this.btnlist = new ButtonListenerHostConfigurator(this.list);
        this.adjustSize();
        scrollpane.getViewport().setView(this.list);
        JPanel ppp = new JPanel();
        ppp.setBorder(new TitledBorder("list of hosts"));
        ppp.add(scrollpane);
        JSplitPane split = new JSplitPane(1, true, scrollpane, this.createButtons2());
        p.add(split);
        this.tab = new JTabbedPane();
        this.tab.addTab("host", this.createHosts());
        this.tab.addTab("dir", this.createDirs());
        this.tab.addTab("ssh terminal", this.createTerms());
        p.add(this.tab);
        this.list.addListSelectionListener(this);
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, 1));
        pp.add(p);
        pp.add(this.createButtons());
        this.getContentPane().add(pp);
        this.list.setSelectedIndex(0);
    }

    private JPanel createButtons2() {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(4, 1));
        p.setBorder(new TitledBorder("create connection to selected host"));
        JButton tem = new JButton("ssh terminal");
        JButton tsf = new JButton("sftp client");
        p.add(tem);
        p.add(tsf);
        tem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal term = new Terminal(HostConfigurator.this.list.getSelectedHost());
            }
        });
        tsf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SftpClient sfc = new SftpClient(HostConfigurator.this.list.getSelectedHost());
            }
        });
        return p;
    }

    private void adjustSize() {
        int numHost = this.list.getModel().getSize();
        int widt = (int)((double)this.getSize().width * 0.45);
        Rectangle bounds = this.list.getCellBounds(0, 0);
        this.list.setPreferredSize(new Dimension(widt, 0 * bounds.height * numHost));
    }

    public void valueChanged(ListSelectionEvent e) {
        HostInfo info = this.list.getSelectedHost();
        if (info != null) {
            int i;
            String pas = info.getPasswordString();
            if (pas != null) {
                this.password.setText(pas);
            } else {
                this.password.setText("");
            }
            for (i = 0; i < this.buttons.size(); ++i) {
                HostConfigButtons button = (HostConfigButtons)this.buttons.get(i);
                button.setSelected(info.getBooleanProperty(button.getPropertyType()));
            }
            for (i = 0; i < this.textfields.size(); ++i) {
                HostConfigEditors editor = (HostConfigEditors)this.textfields.get(i);
                editor.setValue(info.getProperty(editor.getPropertyType()));
            }
            this.password.setEditable(this.savepass.isSelected());
        } else {
            logger.debug((Object)"host info was null... something is wrong!");
        }
    }

    private JPanel createButtons() {
        JButton btncreate = new JButton("add new host");
        JButton btndel = new JButton("delete selected host");
        JButton btnsave = new JButton("save to disk");
        JButton btnclose = new JButton("close");
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 0));
        btnpanel.add(btncreate);
        btnpanel.add(btndel);
        btnpanel.add(btnsave);
        btnpanel.add(btnclose);
        btncreate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.addHost();
            }
        });
        btndel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.deleteHost();
            }
        });
        btnsave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.save();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.dispose();
            }
        });
        return btnpanel;
    }

    private void save() {
        this.list.getListofHosts().save();
    }

    private void addHost() {
        String hostName = JOptionPane.showInternalInputDialog(Desktop.getDesktop(), "input name of host (must be unique!)", "new host", -1);
        if (hostName == null) {
            return;
        }
        if (this.isDupli(hostName)) {
            logger.warn((Object)"failed to add host ... found duplicate host name!");
            return;
        }
        this.list.getListofHosts().addLast(new HostInfo(hostName));
        this.list.recreate();
        this.adjustSize();
        this.revalidate();
    }

    private void deleteHost() {
        int selected = this.list.getSelectedIndex();
        if (selected == 0) {
            logger.warn((Object)"can't delete localhost");
            return;
        }
        if (selected <= 0) {
            logger.debug((Object)"host not selected");
            return;
        }
        this.list.getListofHosts().remove(selected);
        this.list.recreate();
        this.adjustSize();
        this.revalidate();
    }

    private boolean isDupli(String hostName) {
        boolean ret = false;
        int n = this.list.getListofHosts().size();
        for (int i = 0; i < n; ++i) {
            if (!hostName.trim().equals(this.list.getListofHosts().getHostInfo(i).getName().trim())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private JPanel createHosts() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        InputPanelHostConfigurator address = new InputPanelHostConfigurator("address", 0, 15, "address");
        address.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(address.getTextField());
        InputPanelHostConfigurator username = new InputPanelHostConfigurator("user name", 0, 15, "username");
        username.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(username.getTextField());
        JPanel ppass = new JPanel();
        ppass.setLayout(new BoxLayout(ppass, 0));
        this.password = new JPasswordFieldHostConfigurator(15);
        this.password.addCaretListener(this.caretListener);
        this.savepass = new CheckBoxHostConfigurator("savepass");
        this.savepass.addActionListener(this.btnlist);
        this.buttons.add(this.savepass);
        ppass.add(this.password);
        ppass.add(this.savepass);
        ppass.setBorder(new TitledBorder("password"));
        this.savepass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostConfigurator.this.password.setEditable(HostConfigurator.this.savepass.isSelected());
                if (!HostConfigurator.this.savepass.isSelected()) {
                    HostConfigurator.this.password.setText("");
                }
            }
        });
        panel.add(username);
        panel.add(ppass);
        panel.add(address);
        return panel;
    }

    private JPanel createDirs() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        PathSelectorHostConfigurator basedir = new PathSelectorHostConfigurator("base directory", 15, "basedir", this);
        basedir.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(basedir.getTextField());
        PathSelectorHostConfigurator bindir = new PathSelectorHostConfigurator("\"bin\" directory", 15, "bindir", this);
        bindir.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(bindir.getTextField());
        PathSelectorHostConfigurator mpidir = new PathSelectorHostConfigurator("MPI directory", 15, "mpidir", this);
        mpidir.getTextField().addCaretListener(this.caretListener);
        this.textfields.add(mpidir.getTextField());
        panel.add(basedir);
        panel.add(bindir);
        panel.add(mpidir);
        return panel;
    }

    private JPanel createTerms() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CheckBoxHostConfigurator cbxforward = new CheckBoxHostConfigurator("enable X forwarding", "xforwarding");
        cbxforward.addActionListener(this.btnlist);
        this.buttons.add(cbxforward);
        CheckBoxHostConfigurator cbantialias = new CheckBoxHostConfigurator("enable anti-aliasing", "antialiasing");
        cbantialias.addActionListener(this.btnlist);
        this.buttons.add(cbantialias);
        panel.add(cbxforward);
        panel.add(cbantialias);
        return panel;
    }
}

