/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.common.ExcelAdapter;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.phase.TableModelForCellPanel;
import jp.advancesoft.chase.phase.TableModelForNonTabularData;
import org.apache.log4j.Logger;

public class TableForNonTabularData
extends JTable {
    private static Logger logger = Logger.getLogger((String)TableForNonTabularData.class.getName());
    private String[] inputSpecifications;
    private InputInterface input;
    private boolean rowOriented = false;
    private Vector entryVector = new Vector();
    private Vector fullNameVector = new Vector();
    private String[] idents;
    private Vector tableData;
    private boolean rowIdent = true;
    private int rowStart = 1;

    public TableForNonTabularData(String[] inputSpecifications, InputInterface input) {
        this.setModel(new TableModelForNonTabularData(this));
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForNonTabularData(String[] inputSpecifications, InputInterface input, int numRows, int numColumns) {
        super(numRows, numColumns);
        this.setModel(new TableModelForNonTabularData(this, numRows, numColumns));
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForNonTabularData(String[] inputSpecifications, InputInterface input, Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.setModel(new TableModelForNonTabularData(this, rowData, columnNames));
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForNonTabularData(String[] inputSpecifications, InputInterface input, Object[][] rowData, Object[] columnNames, AtomCoords coords) {
        super(rowData, columnNames);
        this.setModel(new TableModelForCellPanel(this, rowData, columnNames, coords));
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForNonTabularData(String[] inputSpecifications, InputInterface input, TableModel dm) {
        super(dm);
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForNonTabularData(String[] inputSpecifications, InputInterface input, TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForNonTabularData(String[] inputSpecifications, TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.inputSpecifications = inputSpecifications;
        this.input = this.input;
        this.init();
    }

    public TableForNonTabularData(String[] inputSpecifications, Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.inputSpecifications = inputSpecifications;
        this.input = this.input;
        this.init();
    }

    public boolean hasRowIdentifiers() {
        return this.rowIdent;
    }

    public void unsetRowIdentifiers() {
        this.rowIdent = false;
        this.rowStart = 0;
    }

    public void setRowIdentifiers() {
        this.rowIdent = true;
        this.rowStart = 1;
    }

    private void init() {
        ExcelAdapter ea = new ExcelAdapter(this);
        this.extractInputFile();
    }

    private void extractInputFile() {
        int i;
        for (i = 0; i < this.inputSpecifications.length; ++i) {
            String inp = this.inputSpecifications[i];
            logger.debug((Object)("inp: " + inp));
            String[] fullName = inp.split("\\.");
            this.fullNameVector.addElement(fullName);
        }
        for (i = 0; i < this.fullNameVector.size(); ++i) {
            this.input.selectRoot();
            String[] fullName = (String[])this.fullNameVector.get(i);
            for (int j = 0; j < fullName.length - 1; ++j) {
                String ident = fullName[j];
                if (!this.input.selectBlock(ident)) {
                    logger.debug((Object)("couldn't select block: " + ident));
                    continue;
                }
                logger.debug((Object)("selected block: " + ident));
            }
            InputInterfacePrimitiveEntry entry = this.input.getPrimitiveEntry(fullName[fullName.length - 1]);
            this.entryVector.addElement(entry);
            this.input.selectRoot();
        }
    }

    public Vector getFullNameVector() {
        return this.fullNameVector;
    }

    public void setRowOriented() {
        this.rowOriented = true;
    }

    public boolean isRowOriented() {
        return this.rowOriented;
    }

    public void setInputToModel() {
        this.setEditorsAndRenderes();
        TableModel model = this.getModel();
        int icol = model.getColumnCount();
        int irow = model.getRowCount();
        int idata = icol + this.rowStart;
        int idata2 = irow;
        if (this.rowOriented) {
            idata = irow;
            idata2 = icol + this.rowStart;
        }
        for (int i = 0; i < this.entryVector.size(); ++i) {
            if (i >= idata) continue;
            InputInterfacePrimitiveEntry entry = (InputInterfacePrimitiveEntry)this.entryVector.get(i);
            String value = entry.getValue();
            String[] values = value.trim().split("\\s+");
            for (int j = 0; j < values.length; ++j) {
                if (j >= idata2) continue;
                if (this.rowOriented) {
                    logger.debug((Object)("set value " + values[j] + " at: " + i + " " + j));
                    model.setValueAt(values[j], i, j + this.rowStart);
                    continue;
                }
                logger.debug((Object)("set value " + values[j] + " at: " + j + " " + i));
                model.setValueAt(values[j], j, i + this.rowStart);
            }
        }
    }

    public boolean hasData() {
        boolean hasdata = false;
        TableModel model = this.getModel();
        int icol = model.getColumnCount();
        int irow = model.getRowCount();
        for (int i = 0; i < irow; ++i) {
            for (int j = 1; j < icol; ++j) {
                String data = (String)model.getValueAt(i, j);
                if (data == null || data.trim().length() == 0) continue;
                hasdata = true;
            }
        }
        return hasdata;
    }

    protected InputInterface getInputInterface() {
        return this.input;
    }

    private void setEditorsAndRenderes() {
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        DefaultTableCellRenderer dtcr2 = new DefaultTableCellRenderer();
        JTextField tf = new JTextField("");
        tf.setEditable(false);
        JTextField tf2 = new JTextField("");
        tf2.setEditable(true);
        DefaultCellEditor dce = new DefaultCellEditor(tf);
        DefaultCellEditor dce2 = new DefaultCellEditor(tf2);
        int icol = this.getModel().getColumnCount();
        this.columnModel.getColumn(0).setCellRenderer(dtcr);
        this.columnModel.getColumn(0).setCellEditor(dce);
        for (int i = this.rowStart; i < icol; ++i) {
            this.columnModel.getColumn(i).setCellRenderer(dtcr2);
            this.columnModel.getColumn(i).setCellEditor(dce2);
        }
    }
}

