/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.common.ExcelAdapter;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTable;
import jp.advancesoft.chase.phase.TableModelForInputInterface;
import org.apache.log4j.Logger;

public class TableForInputInterface
extends JTable {
    private static Logger logger = Logger.getLogger((String)TableForInputInterface.class.getName());
    private String[] inputSpecifications;
    private InputInterface input;
    private InputInterfaceTable table;
    private String[] fullName;
    private String[] idents;
    private Vector tableData;

    public TableForInputInterface(String[] inputSpecifications, InputInterface input) {
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface input, int numRows, int numColumns) {
        super(numRows, numColumns);
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface input, Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface input, TableModel dm) {
        super(dm);
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForInputInterface(String[] inputSpecifications, InputInterface input, TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.init();
    }

    public TableForInputInterface(String[] inputSpecifications, TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.inputSpecifications = inputSpecifications;
        this.input = this.input;
        this.init();
    }

    public TableForInputInterface(String[] inputSpecifications, Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.inputSpecifications = inputSpecifications;
        this.input = this.input;
        this.init();
    }

    private void init() {
        ExcelAdapter ea = new ExcelAdapter(this);
        if (this.input != null && this.inputSpecifications != null) {
            this.extractInputFile();
        }
    }

    public void setModel(TableModelForInputInterface model) {
        super.setModel(model);
        if (this.input != null && this.inputSpecifications != null) {
            this.setInputToModel();
        }
    }

    private void extractInputFile() {
        String inp = this.inputSpecifications[0];
        logger.debug((Object)("inp: " + inp));
        if (!this.input.selectBlock(inp)) {
            logger.debug((Object)("failed to select block: " + inp));
            return;
        }
        logger.debug((Object)("name of block: " + this.input.getCurrentBlock().getName()));
        logger.debug((Object)("has table? " + this.input.getCurrentBlock().hasTable()));
        this.table = this.input.getTable();
        this.idents = this.table.getTableIdentifiers();
        this.tableData = this.table.getTableData();
    }

    public void setInputToModel() {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        int icol = model.getColumnCount();
        int irow = model.getRowCount();
        String[] columnNames = new String[icol];
        Vector<Integer[]> map = new Vector<Integer[]>();
        int elementCol = -1;
        if (this.idents != null && this.tableData != null) {
            int i;
            int i2;
            for (i2 = 0; i2 < icol; ++i2) {
                columnNames[i2] = model.getColumnName(i2);
                if (!columnNames[i2].trim().equalsIgnoreCase("element")) continue;
                elementCol = i2;
            }
            for (i2 = 0; i2 < icol; ++i2) {
                for (int j = 0; j < this.idents.length; ++j) {
                    if (!columnNames[i2].equalsIgnoreCase(this.idents[j])) continue;
                    Integer[] it = new Integer[]{new Integer(i2), new Integer(j)};
                    map.addElement(it);
                }
            }
            Vector<Integer> itable = new Vector<Integer>();
            Vector<Integer> iinput = new Vector<Integer>();
            for (int i3 = 0; i3 < map.size(); ++i3) {
                Integer[] it = (Integer[])map.get(i3);
                itable.addElement(it[0]);
                iinput.addElement(it[1]);
            }
            int dataSize = this.tableData.size();
            Vector<String> dummy = new Vector<String>();
            if (dataSize > irow) {
                for (i = irow; i < dataSize; ++i) {
                    for (int j = 0; j < icol; ++j) {
                        dummy.addElement("");
                    }
                    model.addRow(dummy);
                    dummy = new Vector();
                }
            }
            for (i = 0; i < this.tableData.size(); ++i) {
                String[] rowData = (String[])this.tableData.get(i);
                for (int j = 0; j < map.size(); ++j) {
                    int it = (Integer)itable.get(j);
                    int ii = (Integer)iinput.get(j);
                    String dat = rowData[ii];
                    if (it == elementCol) {
                        char[] ch = dat.toCharArray();
                        ch[0] = Character.toUpperCase(ch[0]);
                        dat = new String(ch, 0, ch.length);
                    }
                    model.setValueAt(dat, i, it);
                }
            }
        }
    }

    protected InputInterface getInputInterface() {
        return this.input;
    }

    protected String[] getFullName() {
        return this.fullName;
    }

    protected InputInterfaceTable getInputInterfaceTable() {
        return this.table;
    }
}

