/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.outputinterface;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import jp.advancesoft.chase.outputinterface.OutputData;
import jp.advancesoft.chase.outputinterface.OutputInterface;
import org.apache.log4j.Logger;

public abstract class OutputParser {
    private Logger logger = Logger.getLogger((String)OutputParser.class.getName());
    protected String fileName;
    protected Vector voutputData = new Vector();
    protected BufferedReader reader;
    private OutputInterface parent;

    public OutputParser(String fileName) {
        this.fileName = fileName;
        try {
            FileReader freader = new FileReader(fileName);
            this.reader = new BufferedReader(freader);
        }
        catch (IOException ioe) {
            this.logger.error((Object)("failed to open file: " + fileName));
            ioe.printStackTrace();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public abstract boolean parse();

    public void addOutputData(OutputData outputData) {
        this.voutputData.addElement(outputData);
    }

    public OutputInterface getParent() {
        return this.parent;
    }

    void setParent(OutputInterface parent) {
        this.parent = parent;
    }

    public void initializeOutputDataVector() {
        this.voutputData = new Vector();
    }

    public OutputData[] getOutputData() {
        if (this.voutputData == null || this.voutputData.size() == 0) {
            return null;
        }
        Object[] ret = new OutputData[this.voutputData.size()];
        this.voutputData.copyInto(ret);
        return ret;
    }

    public OutputData[] getOutputDataCustom() {
        return null;
    }

    public String[] getGenericData(String key) {
        return new String[]{""};
    }

    public String[][] getGenericData2D(String key) {
        return new String[][]{{""}, {""}};
    }
}

