/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.mainpanel.Desktop;

public class TemplateCopier {
    private Object parent;
    private String toCopy;
    private String toCopyName;
    private String curDir;
    private String templateDir;
    private String selectedFile;
    private String selectedFileName;
    private final String FS = System.getProperty("file.separator");

    public TemplateCopier(Object parent) {
        this.parent = parent;
    }

    public TemplateCopier(Object parent, String toCopy) {
        this.parent = parent;
        this.toCopy = toCopy;
        File file = new File(toCopy);
        this.curDir = file.getParent();
        this.toCopyName = file.getName();
    }

    public void setToCopy(String toCopy) {
        this.toCopy = toCopy;
        File file = new File(toCopy);
        this.curDir = file.getParent();
        this.toCopyName = file.getName();
    }

    public void setTemplatePath(String templateDir) {
        this.templateDir = templateDir;
    }

    public boolean copyTemplate() {
        JFileChooser filechooser = new JFileChooser();
        filechooser.setDialogType(2);
        filechooser.setDialogTitle("copy template file");
        filechooser.setCurrentDirectory(new File(this.templateDir));
        filechooser.setFileSelectionMode(0);
        if (filechooser.showDialog((Component)this.parent, "open") != 0) {
            return false;
        }
        this.selectedFile = filechooser.getSelectedFile().getAbsolutePath();
        this.selectedFileName = new File(this.selectedFile).getName();
        int selected = 0;
        if (new File(this.toCopy).exists()) {
            selected = JOptionPane.showInternalConfirmDialog(Desktop.getDesktop(), "overwrite?", "confirmation", 0, 3);
        }
        if (selected == 0) {
            try {
                ExternalProgramExecuter.copy(this.selectedFile, this.toCopy);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

